/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.util.RawSqlBlock;

public class RawSql {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s");
    public static final String SELECT = "select";
    public static final String WITH = "with";
    public static final String EXPLAIN = "explain";
    private final String sql;
    private final List<RawSqlBlock> stmtBlockList;
    private final List<RawSqlBlock> allBlockList;
    private String statementStringCache;
    private String fullTextStringCache;

    public RawSql(String sql, List<RawSqlBlock> stmtBlockList, List<RawSqlBlock> allBlockList) {
        this.sql = sql.trim();
        this.stmtBlockList = stmtBlockList;
        this.allBlockList = allBlockList;
        this.removeStatementEndedSemicolon();
    }

    public String getStatementString() {
        if (this.statementStringCache != null) {
            return this.statementStringCache;
        }
        StringBuilder stmt = new StringBuilder();
        int prevEndLine = -1;
        for (RawSqlBlock block : this.stmtBlockList) {
            if (block.getBeginLine() > prevEndLine) {
                if (prevEndLine != -1) {
                    stmt.append(LINE_SEPARATOR);
                }
                stmt.append(block.getTrimmedText());
            } else if (block.getBeginLine() == prevEndLine) {
                stmt.append(" ");
                stmt.append(block.getTrimmedText());
            }
            prevEndLine = block.getEndLine();
        }
        this.statementStringCache = stmt.toString();
        return this.statementStringCache;
    }

    public String getFullTextString() {
        if (this.fullTextStringCache != null) {
            return this.fullTextStringCache;
        }
        StringBuilder fullText = new StringBuilder();
        for (RawSqlBlock block : this.allBlockList) {
            fullText.append(block.getText());
        }
        this.fullTextStringCache = fullText.toString();
        return this.fullTextStringCache;
    }

    public void autoAppendLimit(KylinConfig kylinConfig, int limit) {
        this.autoAppendLimit(kylinConfig, limit, 0);
    }

    public void autoAppendLimit(KylinConfig kylinConfig, int limit, int offset) {
        int forceLimit;
        if (CollectionUtils.isEmpty(this.allBlockList) || !this.isSelectStatement()) {
            return;
        }
        ArrayList sqlElements = Lists.newArrayList((Object[])this.getStatementString().toLowerCase(Locale.ROOT).split("(?![\\._'\"`])\\p{P}|\\s+"));
        boolean limitAppended = false;
        Integer maxRows = kylinConfig.getMaxResultRows();
        if (maxRows != null && maxRows > 0 && (maxRows < limit || limit <= 0)) {
            limit = maxRows;
        }
        if (limit > 0 && !sqlElements.contains("limit")) {
            this.appendStmtBlock("\nLIMIT " + limit);
            limitAppended = true;
        }
        if (offset > 0 && !sqlElements.contains("offset")) {
            this.appendStmtBlock("\nOFFSET " + offset);
        }
        if ((forceLimit = kylinConfig.getForceLimit()) > 0 && !limitAppended && !sqlElements.contains("limit") && this.getStatementString().toLowerCase(Locale.ROOT).matches("^select\\s+\\*\\p{all}*")) {
            this.appendStmtBlock("\nLIMIT " + forceLimit);
        }
    }

    private boolean isSelectStatement() {
        char c;
        String stmt = this.getStatementString();
        int startIndex = 0;
        while ((c = stmt.charAt(startIndex)) == '(' || WHITE_SPACE_PATTERN.matcher(String.valueOf(c)).matches()) {
            ++startIndex;
        }
        return (stmt = stmt.substring(startIndex).toLowerCase(Locale.ROOT)).startsWith(SELECT) || stmt.startsWith(WITH) && stmt.contains(SELECT) || stmt.startsWith(EXPLAIN) && stmt.contains(SELECT);
    }

    private void removeStatementEndedSemicolon() {
        if (CollectionUtils.isEmpty(this.stmtBlockList)) {
            return;
        }
        RawSqlBlock block = this.stmtBlockList.get(this.stmtBlockList.size() - 1);
        String text = block.getText();
        boolean done = false;
        for (int i = text.length() - 1; !done && i >= 0; --i) {
            char c = text.charAt(i);
            if (WHITE_SPACE_PATTERN.matcher(String.valueOf(c)).matches()) continue;
            if (c == ';') {
                text = text.substring(0, i) + text.substring(i + 1);
                continue;
            }
            done = true;
        }
        block.setText(text);
    }

    private void appendStmtBlock(String stmt) {
        this.appendStmtBlock(stmt, 1);
    }

    private void appendStmtBlock(String stmt, int lines) {
        int lineNo = this.allBlockList.get(this.allBlockList.size() - 1).getEndLine() + 1;
        RawSqlBlock block = new RawSqlBlock(stmt, RawSqlBlock.Type.STATEMENT, lineNo, 0, lineNo + lines - 1, stmt.length());
        this.stmtBlockList.add(block);
        this.allBlockList.add(block);
        this.clearCache();
    }

    private void clearCache() {
        this.statementStringCache = null;
        this.fullTextStringCache = null;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }
}

