/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.relnode.KapRel;

public class RelAggPushDownUtil {
    private static final String HEP_REL_VERTEX = "HepRelVertex#";
    private static final String REL = "rel#";
    private static final String KAP = ":Kap";
    private static final String CTX = "ctx=";

    private RelAggPushDownUtil() {
    }

    public static void clearUnmatchedJoinDigest() {
        QueryContext.current().getUnmatchedJoinDigest().clear();
    }

    public static boolean canRelAnsweredBySnapshot(String project, RelNode relNode) {
        List rightRelOptTableList = RelOptUtil.findAllTables((RelNode)relNode);
        if (rightRelOptTableList.size() != 1) {
            return false;
        }
        RelOptTable relOptTable = (RelOptTable)rightRelOptTableList.get(0);
        List qualifiedNameList = relOptTable.getQualifiedName();
        String identity = StringUtils.join((Iterable)qualifiedNameList, (String)".");
        TableDesc table = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getTableDesc(identity);
        return table != null && StringUtils.isNotEmpty((CharSequence)table.getLastSnapshotPath());
    }

    public static void registerUnmatchedJoinDigest(RelNode relNode) {
        KapJoinRel joinRel = RelAggPushDownUtil.collectFirstJoinRel(relNode);
        if (joinRel != null) {
            String digest = joinRel.getDigest();
            digest = RelAggPushDownUtil.handleDigest(digest);
            QueryContext.current().getUnmatchedJoinDigest().put(digest, true);
        }
    }

    public static synchronized boolean isUnmatchedJoinRel(KapJoinRel joinRel) {
        boolean unmatched;
        String digest = RelAggPushDownUtil.getDigest(joinRel);
        boolean bl = unmatched = QueryContext.current().getUnmatchedJoinDigest().get(digest) != null;
        if (unmatched) {
            QueryContext.current().getUnmatchedJoinDigest().clear();
            QueryContext.current().getUnmatchedJoinDigest().put(digest, true);
        }
        return unmatched;
    }

    private static String getDigest(KapJoinRel joinRel) {
        HashMap<String, String> cacheDescMap = new HashMap<String, String>();
        RelAggPushDownUtil.analysisRel(joinRel, cacheDescMap);
        String joinRelDigest = joinRel.getDigest();
        int maxReplaceSize = cacheDescMap.size();
        for (int times = 0; joinRelDigest.contains(HEP_REL_VERTEX) && times < maxReplaceSize; ++times) {
            Iterator iterator = cacheDescMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (!joinRelDigest.contains(key)) continue;
                joinRelDigest = joinRelDigest.replace(key, (CharSequence)cacheDescMap.get(key));
                iterator.remove();
            }
        }
        return joinRelDigest;
    }

    private static void analysisRel(RelNode relNode, Map<String, String> cacheDescMap) {
        if (relNode instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)relNode;
            cacheDescMap.put(relNode.getDescription(), hepRelVertex.getCurrentRel().getDigest());
            relNode = hepRelVertex.getCurrentRel();
        }
        List childRelNodes = relNode.getInputs();
        for (RelNode childRelNode : childRelNodes) {
            RelAggPushDownUtil.analysisRel(childRelNode, cacheDescMap);
        }
    }

    public static KapJoinRel collectFirstJoinRel(RelNode kapRel) {
        if (kapRel == null || CollectionUtils.isEmpty((Collection)kapRel.getInputs())) {
            return null;
        }
        if (kapRel instanceof KapJoinRel) {
            return (KapJoinRel)kapRel;
        }
        return RelAggPushDownUtil.collectFirstJoinRel(kapRel.getInput(0));
    }

    public static void collectAllJoinRel(RelNode kapRel) {
        if (kapRel instanceof KapJoinRel) {
            QueryContext.current().getUnmatchedJoinDigest().put(RelAggPushDownUtil.handleDigest(kapRel.getDigest()), true);
        }
        for (RelNode rel : kapRel.getInputs()) {
            RelAggPushDownUtil.collectAllJoinRel(rel);
        }
    }

    public static void clearCtxRelNode(RelNode relNode) {
        List relNodes = relNode.getInputs();
        for (RelNode childNode : relNodes) {
            KapRel kapRel = (KapRel)childNode;
            if (kapRel.getContext() != null) {
                kapRel.setContext(null);
            }
            RelAggPushDownUtil.clearCtxRelNode(childNode);
        }
    }

    private static String handleDigest(String digest) {
        digest = RelAggPushDownUtil.clearDigestRelID(digest);
        digest = RelAggPushDownUtil.clearDigestCtx(digest);
        return digest;
    }

    private static String clearDigestRelID(String digest) {
        int start = digest.indexOf(REL);
        int end = digest.indexOf(KAP);
        if (start > 0 && end > start && (digest = digest.substring(0, start) + digest.substring(end + 1)).contains(REL)) {
            return RelAggPushDownUtil.clearDigestRelID(digest);
        }
        return digest;
    }

    public static String clearDigestCtx(String digest) {
        String[] digestArray = digest.split(CTX);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < digestArray.length; ++i) {
            String temp = digestArray[i];
            if (i > 0 && !temp.startsWith(")")) {
                temp = temp.substring(temp.indexOf(","));
            }
            builder.append(temp);
            if (i >= digestArray.length - 1) continue;
            builder.append(CTX);
        }
        return builder.toString();
    }
}

