/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSqlConvertletTable;
import org.apache.calcite.rex.RexSqlStandardConvertletTable;
import org.apache.calcite.rex.RexToSqlNodeConverter;
import org.apache.calcite.rex.RexToSqlNodeConverterImpl;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.calcite.sql.fun.SqlDatePartFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.filter.CompareResultType;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexToTblColRefTranslator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RexToTblColRefTranslator.class);
    private Set<TblColRef> sourceColumnCollector;
    private Map<RexNode, TblColRef> nodeAndTblColMap;
    private Map<String, SqlNode> rexToSqlMap = Maps.newHashMap();

    public RexToTblColRefTranslator() {
        this(new HashSet<TblColRef>(), new HashMap<RexNode, TblColRef>());
    }

    public RexToTblColRefTranslator(Set<TblColRef> sourceColumnCollector, Map<RexNode, TblColRef> nodeAndTblColMap) {
        this.sourceColumnCollector = sourceColumnCollector;
        this.nodeAndTblColMap = nodeAndTblColMap;
    }

    public static TblColRef translateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType, String fieldName, Set<TblColRef> sourceColumnCollector, Map<RexNode, TblColRef> nodeAndTblColMap) {
        return new RexToTblColRefTranslator(sourceColumnCollector, nodeAndTblColMap).doTranslateRexNode(rexNode, inputColumnRowType, fieldName);
    }

    public static TblColRef translateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType, String fieldName, Map<RexNode, TblColRef> nodeAndTblColMap) {
        return new RexToTblColRefTranslator(new HashSet<TblColRef>(), nodeAndTblColMap).doTranslateRexNode(rexNode, inputColumnRowType, fieldName);
    }

    public static TblColRef translateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType) {
        return new RexToTblColRefTranslator().doTranslateRexNode(rexNode, inputColumnRowType, rexNode.toString());
    }

    static RexNode createLeftCall(RexNode origin) {
        RexNode newRexNode = origin;
        if (origin instanceof RexCall) {
            RexCall call = (RexCall)origin;
            SqlOperator op = call.getOperator();
            List operands = call.getOperands();
            if ((op.getKind() == SqlKind.AND || op.getKind() == SqlKind.OR) && operands.size() > 2) {
                RexBuilder builder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT));
                RexNode first = builder.makeCall(op, new RexNode[]{(RexNode)operands.get(0), (RexNode)operands.get(1)});
                for (int i = 2; i < operands.size(); ++i) {
                    first = builder.makeCall(op, new RexNode[]{first, (RexNode)operands.get(i)});
                }
                newRexNode = first;
            }
        }
        return newRexNode;
    }

    public TblColRef doTranslateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType, String fieldName) {
        if (rexNode instanceof RexInputRef) {
            RexInputRef inputRef = (RexInputRef)rexNode;
            return this.translateRexInputRef(inputRef, inputColumnRowType, fieldName);
        }
        if (rexNode instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)rexNode;
            return this.translateRexLiteral(literal);
        }
        if (rexNode instanceof RexCall) {
            RexCall call = (RexCall)rexNode;
            return this.translateRexCall(call, inputColumnRowType, fieldName);
        }
        if (rexNode instanceof RexDynamicParam) {
            RexDynamicParam call = (RexDynamicParam)rexNode;
            return this.translateRexDynamicParam(call);
        }
        throw new IllegalStateException("Unsupported RexNode " + rexNode);
    }

    private TblColRef translateRexDynamicParam(RexDynamicParam rexParam) {
        return TblColRef.newDynamicColumn((String)rexParam.getName());
    }

    private TblColRef translateFirstRexInputRef(RexCall call, ColumnRowType inputColumnRowType, String fieldName) {
        for (RexNode operand : call.getOperands()) {
            TblColRef r;
            if (operand instanceof RexInputRef) {
                return this.translateRexInputRef((RexInputRef)operand, inputColumnRowType, fieldName);
            }
            if (!(operand instanceof RexCall) || (r = this.translateFirstRexInputRef((RexCall)operand, inputColumnRowType, fieldName)) == null) continue;
            return r;
        }
        return null;
    }

    protected TblColRef translateRexInputRef(RexInputRef inputRef, ColumnRowType inputColumnRowType, String fieldName) {
        int index = inputRef.getIndex();
        if (index < inputColumnRowType.size()) {
            Set<TblColRef> sourceColumns = inputColumnRowType.getSourceColumnsByIndex(index);
            sourceColumns.stream().filter(col -> !col.isInnerColumn()).forEach(this.sourceColumnCollector::add);
            return inputColumnRowType.getColumnByIndex(index);
        }
        throw new IllegalStateException("Can't find " + inputRef + " from child columnrowtype " + inputColumnRowType + " with fieldname " + fieldName);
    }

    TblColRef translateRexLiteral(RexLiteral literal) {
        if (literal.getTypeName() == SqlTypeName.SYMBOL) {
            Enum symbol = (Enum)((Object)literal.getValue());
            return TblColRef.newInnerColumn((String)symbol.name(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        }
        if (RexLiteral.isNullLiteral((RexNode)literal)) {
            return TblColRef.newInnerColumn((String)"null", (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
        }
        return TblColRef.newInnerColumn((String)literal.getValue().toString(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
    }

    private TblColRef translateRexCall(RexCall call, ColumnRowType inputColumnRowType, String fieldName) {
        SqlOperator operator = call.getOperator();
        if (operator instanceof SqlUserDefinedFunction && "QUARTER".equals(operator.getName())) {
            return this.translateFirstRexInputRef(call, inputColumnRowType, fieldName);
        }
        List<RexNode> children = this.limitTranslateScope(call.getOperands(), operator);
        ArrayList tblColRefs = Lists.newArrayList();
        for (RexNode operand : children) {
            TblColRef colRef = this.doTranslateRexNode(operand, inputColumnRowType, fieldName);
            this.nodeAndTblColMap.put(operand, colRef);
            tblColRefs.add(colRef);
        }
        return TblColRef.newInnerColumn((String)fieldName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL, (String)this.createInnerColumn(call), (SqlOperator)operator, (List)tblColRefs);
    }

    private String createInnerColumn(RexCall call) {
        OLAPRexSqlStandardConvertletTable convertletTable = new OLAPRexSqlStandardConvertletTable(call, this.rexToSqlMap);
        ExtendedRexToSqlNodeConverter rexNodeToSqlConverter = new ExtendedRexToSqlNodeConverter((RexSqlConvertletTable)convertletTable);
        try {
            SqlNode sqlCall = rexNodeToSqlConverter.convertCall(call);
            this.rexToSqlMap.put(call.toString(), sqlCall);
            return sqlCall.toSqlString(SqlDialect.DatabaseProduct.CALCITE.getDialect()).toString();
        }
        catch (Error | Exception e) {
            return call.toString();
        }
    }

    List<RexNode> limitTranslateScope(List<RexNode> children, SqlOperator operator) {
        if (operator instanceof SqlCaseOperator) {
            int unknownWhenCalls = 0;
            for (int i = 0; i < children.size() - 1; i += 2) {
                if (!(children.get(i) instanceof RexCall)) continue;
                RexCall whenCall = (RexCall)children.get(i);
                CompareResultType compareResultType = this.getCompareResultType(whenCall);
                if (compareResultType == CompareResultType.ALWAYS_TRUE) {
                    return Lists.newArrayList((Object[])new RexNode[]{children.get(i), children.get(i + 1)});
                }
                if (compareResultType != CompareResultType.UNKNOWN) continue;
                ++unknownWhenCalls;
            }
            if (unknownWhenCalls == 0) {
                return Lists.newArrayList((Object[])new RexNode[]{children.get(children.size() - 1)});
            }
        }
        return children;
    }

    CompareResultType getCompareResultType(RexCall whenCall) {
        List operands = whenCall.getOperands();
        if (SqlKind.EQUALS == whenCall.getKind() && operands != null && operands.size() == 2) {
            if (((RexNode)operands.get(0)).equals(operands.get(1))) {
                return CompareResultType.ALWAYS_TRUE;
            }
            if (this.isConstant((RexNode)operands.get(0)) && this.isConstant((RexNode)operands.get(1))) {
                return CompareResultType.ALWAYS_FALSE;
            }
        }
        return CompareResultType.UNKNOWN;
    }

    boolean isConstant(RexNode rexNode) {
        if (rexNode instanceof RexLiteral) {
            return true;
        }
        return rexNode instanceof RexCall && SqlKind.CAST == rexNode.getKind() && ((RexCall)rexNode).getOperands().get(0) instanceof RexLiteral;
    }

    class ExtendedRexToSqlNodeConverter
    extends RexToSqlNodeConverterImpl {
        ExtendedRexToSqlNodeConverter(RexSqlConvertletTable convertletTable) {
            super(convertletTable);
        }

        public SqlNode convertLiteral(RexLiteral literal) {
            SqlNode sqlLiteral = super.convertLiteral(literal);
            if (sqlLiteral == null) {
                if (literal.getTypeName().getName().equals("SYMBOL") && literal.getValue() instanceof TimeUnitRange) {
                    TimeUnitRange timeUnitRange = (TimeUnitRange)literal.getValue();
                    return new SqlIntervalQualifier(timeUnitRange.startUnit, timeUnitRange.endUnit, SqlParserPos.ZERO);
                }
                sqlLiteral = SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
            }
            return sqlLiteral;
        }

        public SqlNode convertInputRef(RexInputRef ref) {
            TblColRef colRef = (TblColRef)RexToTblColRefTranslator.this.nodeAndTblColMap.get(ref);
            String colExpr = colRef.isInnerColumn() && colRef.getParserDescription() != null ? colRef.getParserDescription() : "\"" + colRef.getTableAlias() + "\".\"" + colRef.getName() + "\"";
            try {
                return CalciteParser.getExpNode((String)colExpr);
            }
            catch (Exception e) {
                return super.convertInputRef(ref);
            }
        }

        public SqlNode convertCall(RexCall call) {
            RexCall newCall = (RexCall)RexToTblColRefTranslator.createLeftCall((RexNode)call);
            return super.convertCall(newCall);
        }
    }

    static class OLAPRexSqlStandardConvertletTable
    extends RexSqlStandardConvertletTable {
        private static final BigDecimal SECONDS_OF_WEEK = new BigDecimal(604800);
        private static final BigDecimal MONTHS_OF_QUARTER = new BigDecimal(3);
        final Map<TimeUnit, SqlDatePartFunction> timeUnitFunctions = this.initTimeUnitFunctionMap();
        private final Map<String, SqlNode> rexToSqlMap;

        public OLAPRexSqlStandardConvertletTable(RexCall call, Map<String, SqlNode> rexToSqlMap) {
            this.rexToSqlMap = rexToSqlMap;
            this.registerUdfOperator(call);
            this.registerCaseOpNew();
            this.registerReinterpret();
            this.registerCast();
            this.registerDivDate();
            this.registerExtract();
            this.registerTimestampAdd();
            this.registerTimestampDiff();
            this.registerSign();
            this.registerOperatorIfHasNot(call);
        }

        private void registerUdfOperator(RexCall call) {
            HashSet udfs = Sets.newHashSet();
            KylinConfig.getInstanceFromEnv().getUDFs().forEach((key, value) -> {
                try {
                    Method[] methods;
                    for (Method method : methods = Class.forName(value).getMethods()) {
                        udfs.add(method.getName().toLowerCase(Locale.ROOT));
                    }
                }
                catch (Exception e) {
                    log.error("registerUdfOperator not found method for :", (Throwable)e);
                }
            });
            if (udfs.contains(call.getOperator().toString().toLowerCase(Locale.ROOT))) {
                SqlOperator operator = call.getOperator();
                this.registerEquivOp(operator);
            }
            List operands = call.getOperands();
            for (RexNode udfRexNode : operands) {
                if (!(udfRexNode instanceof RexCall)) continue;
                this.registerUdfOperator((RexCall)udfRexNode);
            }
        }

        private void registerOperatorIfHasNot(RexCall call) {
            if (this.get(call) == null) {
                this.registerEquivOp(call.getOperator());
            }
        }

        private Map<TimeUnit, SqlDatePartFunction> initTimeUnitFunctionMap() {
            HashMap rst = Maps.newHashMap();
            rst.putIfAbsent(TimeUnit.YEAR, SqlStdOperatorTable.YEAR);
            rst.putIfAbsent(TimeUnit.DAY, SqlStdOperatorTable.DAYOFMONTH);
            rst.putIfAbsent(TimeUnit.MONTH, SqlStdOperatorTable.MONTH);
            rst.putIfAbsent(TimeUnit.QUARTER, SqlStdOperatorTable.QUARTER);
            rst.putIfAbsent(TimeUnit.WEEK, SqlStdOperatorTable.WEEK);
            rst.putIfAbsent(TimeUnit.HOUR, SqlStdOperatorTable.HOUR);
            rst.putIfAbsent(TimeUnit.SECOND, SqlStdOperatorTable.SECOND);
            rst.putIfAbsent(TimeUnit.MINUTE, SqlStdOperatorTable.MINUTE);
            rst.putIfAbsent(TimeUnit.DOW, SqlStdOperatorTable.DAYOFWEEK);
            rst.putIfAbsent(TimeUnit.DOY, SqlStdOperatorTable.DAYOFYEAR);
            return rst;
        }

        private void registerCaseOpNew() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.CASE, (converter, call) -> {
                int i;
                SqlNode[] operands = this.doConvertExpressionList(converter, call.getOperands());
                if (operands == null) {
                    return null;
                }
                SqlNodeList whenList = new SqlNodeList(SqlParserPos.ZERO);
                SqlNodeList thenList = new SqlNodeList(SqlParserPos.ZERO);
                for (i = 0; i < operands.length - 1; ++i) {
                    whenList.add(operands[i]);
                    thenList.add(operands[++i]);
                }
                SqlNode elseExpr = operands[i];
                SqlNode[] newOperands = new SqlNode[]{null, whenList, thenList, elseExpr};
                return SqlStdOperatorTable.CASE.createCall(null, SqlParserPos.ZERO, newOperands);
            });
        }

        private void registerReinterpret() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.REINTERPRET, (converter, call) -> {
                RexNode node = (RexNode)call.operands.get(0);
                if (node instanceof RexCall && ((RexCall)node).getOperator() == SqlStdOperatorTable.MINUS_DATE) {
                    return converter.convertNode(node);
                }
                return this.convertCall(converter, call);
            });
        }

        private void registerCast() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.CAST, (converter, call) -> {
                RexCall rexCall;
                RexNode node = (RexNode)call.operands.get(0);
                if (node instanceof RexCall && ((rexCall = (RexCall)node).getOperator() == SqlStdOperatorTable.REINTERPRET || rexCall.getOperator() == SqlStdOperatorTable.DIVIDE_INTEGER)) {
                    return converter.convertNode(node);
                }
                Object[] operands = this.doConvertExpressionList(converter, (List<RexNode>)call.operands);
                if (operands == null) {
                    return null;
                }
                ArrayList operandList = Lists.newArrayList((Object[])operands);
                SqlDataTypeSpec typeSpec = call.getType().getFamily() == SqlTypeFamily.TIMESTAMP ? new SqlDataTypeSpec(call.getType().getSqlIdentifier(), -1, -1, null, null, SqlParserPos.ZERO) : SqlTypeUtil.convertTypeToSpec((RelDataType)call.getType());
                operandList.add(typeSpec);
                return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, (List)operandList);
            });
        }

        private void registerDivDate() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.DIVIDE_DATE, (converter, call) -> {
                List rexNodes = call.getOperands();
                if (rexNodes.size() == 2 && (((RexNode)rexNodes.get(0)).isA(SqlKind.REINTERPRET) || ((RexNode)rexNodes.get(0)).isA(SqlKind.DIVIDE))) {
                    SqlNode node = converter.convertCall((RexCall)rexNodes.get(0));
                    RexNode secRex = (RexNode)rexNodes.get(1);
                    if (node.getKind() == SqlKind.TIMESTAMP_DIFF && secRex instanceof RexLiteral) {
                        SqlBasicCall diffCall = (SqlBasicCall)node;
                        RexLiteral literal = (RexLiteral)secRex;
                        if (literal.getValue().equals(SECONDS_OF_WEEK)) {
                            SqlLiteral week = SqlLiteral.createSymbol((Enum)TimeUnit.WEEK, (SqlParserPos)SqlParserPos.ZERO);
                            return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(SqlParserPos.ZERO, (List)Lists.newArrayList((Object[])new SqlNode[]{week, diffCall.operand(1), diffCall.operand(2)}));
                        }
                        if (literal.getValue().equals(MONTHS_OF_QUARTER)) {
                            SqlLiteral quarter = SqlLiteral.createSymbol((Enum)TimeUnit.QUARTER, (SqlParserPos)SqlParserPos.ZERO);
                            return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(SqlParserPos.ZERO, (List)Lists.newArrayList((Object[])new SqlNode[]{quarter, diffCall.operand(1), diffCall.operand(2)}));
                        }
                    }
                    return converter.convertCall((RexCall)rexNodes.get(0));
                }
                return this.convertCall(converter, call);
            });
        }

        private void registerTimestampDiff() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.MINUS_DATE, (converter, call) -> {
                SqlNode[] operands = this.doConvertExpressionList(converter, (List<RexNode>)call.operands);
                TimeUnit unit = call.getType().getIntervalQualifier().getUnit();
                SqlLiteral first = SqlLiteral.createSymbol((Enum)unit, (SqlParserPos)SqlParserPos.ZERO);
                return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(SqlParserPos.ZERO, new SqlNode[]{first, operands[1], operands[0]});
            });
        }

        private void registerTimestampAdd() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, (converter, call) -> {
                RexCall call0;
                RexNode firstOperand = (RexNode)call.operands.get(0);
                RexNode secondOperand = (RexNode)call.operands.get(1);
                TimeUnit unit = secondOperand.getType().getIntervalQualifier().getUnit();
                SqlLiteral first = SqlLiteral.createSymbol((Enum)unit, (SqlParserPos)SqlParserPos.ZERO);
                SqlNode third = this.doConvertExpression(converter, firstOperand);
                BigDecimal multiplier = unit.multiplier;
                if (secondOperand instanceof RexLiteral) {
                    BigDecimal interval = new BigDecimal(((RexLiteral)secondOperand).getValue().toString()).divide(multiplier);
                    SqlNumericLiteral second = SqlLiteral.createExactNumeric((String)interval.toString(), (SqlParserPos)SqlParserPos.ZERO);
                    return SqlStdOperatorTable.TIMESTAMP_ADD.createCall(SqlParserPos.ZERO, new SqlNode[]{first, second, third});
                }
                if (secondOperand instanceof RexCall && (call0 = (RexCall)secondOperand).getOperands().size() == 2) {
                    RexNode subNode = (RexNode)call0.getOperands().get(1);
                    SqlNode second = this.doConvertExpression(converter, subNode);
                    return SqlStdOperatorTable.TIMESTAMP_ADD.createCall(SqlParserPos.ZERO, new SqlNode[]{first, second, third});
                }
                throw new NotImplementedException("Not implement convert for RexCall, " + call.toString());
            });
        }

        private void registerSign() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.SIGN, (converter, call) -> {
                RexNode operand = (RexNode)call.operands.get(0);
                SqlNode node = this.doConvertExpression(converter, operand);
                return SqlStdOperatorTable.SIGN.createCall(SqlParserPos.ZERO, new SqlNode[]{node});
            });
        }

        private void registerExtract() {
            this.registerOp((SqlOperator)SqlStdOperatorTable.EXTRACT, (converter, call) -> {
                RexLiteral firstOperand = (RexLiteral)call.operands.get(0);
                Comparable unit = firstOperand.getValue();
                if (unit instanceof TimeUnitRange && ((TimeUnitRange)unit).endUnit == null) {
                    RexNode secondOperand = (RexNode)call.operands.get(1);
                    SqlNode param = this.doConvertExpression(converter, secondOperand);
                    TimeUnit startUnit = ((TimeUnitRange)unit).startUnit;
                    if (this.timeUnitFunctions.containsKey(startUnit)) {
                        return this.timeUnitFunctions.get(startUnit).createCall(SqlParserPos.ZERO, new SqlNode[]{param});
                    }
                }
                return this.convertCall(converter, call);
            });
        }

        SqlNode[] doConvertExpressionList(RexToSqlNodeConverter converter, List<RexNode> nodes) {
            SqlNode[] exprs = new SqlNode[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                RexNode node = nodes.get(i);
                exprs[i] = this.doConvertExpression(converter, node);
                if (exprs[i] != null) continue;
                return null;
            }
            return exprs;
        }

        SqlNode doConvertExpression(RexToSqlNodeConverter converter, RexNode node) {
            SqlNode sqlNode = this.rexToSqlMap.get(node.toString());
            if (sqlNode == null) {
                sqlNode = converter.convertNode(node);
                this.rexToSqlMap.put(node.toString(), sqlNode);
            }
            return sqlNode;
        }
    }
}

