/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.tool.CalciteParser;

public class SqlNodeExtractor
extends SqlBasicVisitor<SqlNode> {
    private List<SqlIdentifier> allSqlIdentifier = Lists.newArrayList();

    public static List<SqlIdentifier> getAllSqlIdentifier(String sql) throws SqlParseException {
        SqlNode parsed = CalciteParser.parse((String)sql);
        SqlNodeExtractor sqlNodeExtractor = new SqlNodeExtractor();
        parsed.accept((SqlVisitor)sqlNodeExtractor);
        return sqlNodeExtractor.allSqlIdentifier;
    }

    public static Map<SqlIdentifier, Pair<Integer, Integer>> getIdentifierPos(String sql) throws SqlParseException {
        List<SqlIdentifier> identifiers = SqlNodeExtractor.getAllSqlIdentifier(sql);
        HashMap identifierAndPositionMap = Maps.newHashMap();
        for (SqlIdentifier identifier : identifiers) {
            Pair identifyPosition = CalciteParser.getReplacePos((SqlNode)identifier, (String)sql);
            identifierAndPositionMap.put(identifier, identifyPosition);
        }
        return identifierAndPositionMap;
    }

    public SqlNode visit(SqlIdentifier id) {
        this.allSqlIdentifier.add(id);
        return null;
    }
}

