/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimestampString;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterConditionExpander {
    public static final Logger logger = LoggerFactory.getLogger(FilterConditionExpander.class);
    private static final String DATE = "date";
    private static final String TIMESTAMP = "timestamp";
    private final OLAPContext context;
    private final RelNode currentRel;
    private final RexBuilder rexBuilder;

    public FilterConditionExpander(OLAPContext context, RelNode currentRel) {
        this.context = context;
        this.currentRel = currentRel;
        this.rexBuilder = currentRel.getCluster().getRexBuilder();
    }

    public List<RexNode> convert(RexNode node) {
        if (!(node instanceof RexCall)) {
            return new LinkedList<RexNode>();
        }
        try {
            LinkedList<RexNode> results = new LinkedList<RexNode>();
            RexCall call = (RexCall)node;
            for (RexNode conjunction : RelOptUtil.conjunctions((RexNode)RexUtil.toCnf((RexBuilder)this.rexBuilder, (int)100, (RexNode)call))) {
                RexNode converted = this.convertDisjunctionCall(conjunction);
                if (converted == null) continue;
                results.add(converted);
            }
            return results;
        }
        catch (KylinException e) {
            logger.warn("Filter condition is too complex to be converted");
            return new LinkedList<RexNode>();
        }
    }

    public RexNode convertDisjunctionCall(RexNode node) {
        if (!(node instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)node;
        if (call.getOperator() == SqlStdOperatorTable.OR) {
            LinkedList<RexNode> convertedList = new LinkedList<RexNode>();
            for (RexNode operand : call.getOperands()) {
                RexNode converted = this.convertDisjunctionCall(operand);
                if (converted == null) {
                    return null;
                }
                convertedList.add(converted);
            }
            return convertedList.isEmpty() ? null : this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, convertedList);
        }
        if (call.getOperator() == SqlStdOperatorTable.AND) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.UNSUPPORTED_EXPRESSION, "filter expression not in CNF");
        }
        if (call.getOperator() == SqlStdOperatorTable.NOT) {
            RexNode converted = this.convertDisjunctionCall((RexNode)call.getOperands().get(0));
            return converted == null ? null : this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{converted});
        }
        return this.convertSimpleCall(call);
    }

    public RexNode convertSimpleCall(RexCall call) {
        RexNode op0 = (RexNode)call.getOperands().get(0);
        RexInputRef lInputRef = null;
        if (call.getOperands().get(0) instanceof RexInputRef) {
            lInputRef = this.convertInputRef((RexInputRef)call.getOperands().get(0), this.currentRel);
        } else if (op0 instanceof RexCall && ((RexCall)op0).getOperator() == SqlStdOperatorTable.CAST && ((RexCall)op0).getOperands().get(0) instanceof RexInputRef) {
            lInputRef = this.convertInputRef((RexInputRef)((RexCall)op0).getOperands().get(0), this.currentRel);
        }
        if (lInputRef == null) {
            return null;
        }
        if (call.getOperands().size() == 1) {
            return this.rexBuilder.makeCall(call.getOperator(), new RexNode[]{lInputRef});
        }
        if (call.getOperands().size() > 1) {
            if (call.getOperands().get(0) instanceof RexInputRef) {
                SqlOperator operator = call.getOperator();
                if (operator.equals((Object)SqlStdOperatorTable.IN)) {
                    return this.convertIn(lInputRef, call.getOperands().subList(1, call.getOperands().size()), true);
                }
                if (operator.equals((Object)SqlStdOperatorTable.NOT_IN)) {
                    return this.convertIn(lInputRef, call.getOperands().subList(1, call.getOperands().size()), false);
                }
            }
            RexNode op1 = (RexNode)call.getOperands().get(1);
            if (call.getOperands().size() == 2 && op1 instanceof RexLiteral) {
                RexLiteral rLit = (RexLiteral)op1;
                rLit = ((RexLiteral)op1).getValue() instanceof NlsString ? this.transformRexLiteral(lInputRef, rLit) : rLit;
                return this.rexBuilder.makeCall(call.getOperator(), new RexNode[]{lInputRef, rLit});
            }
        }
        return null;
    }

    private RexNode convertIn(RexInputRef rexInputRef, List<RexNode> extendedOperands, boolean isIn) {
        ArrayList transformedOperands = Lists.newArrayList();
        for (RexNode operand : extendedOperands) {
            RexLiteral transformed;
            if (!(operand instanceof RexLiteral)) {
                return null;
            }
            Object transformedOperand = ((RexLiteral)operand).getValue() instanceof NlsString ? ((transformed = this.transformRexLiteral(rexInputRef, (RexLiteral)operand)) == null ? operand : transformed) : operand;
            SqlBinaryOperator operator = isIn ? SqlStdOperatorTable.EQUALS : SqlStdOperatorTable.NOT_EQUALS;
            transformedOperands.add(this.rexBuilder.makeCall((SqlOperator)operator, new RexNode[]{rexInputRef, transformedOperand}));
        }
        if (transformedOperands.size() == 1) {
            return (RexNode)transformedOperands.get(0);
        }
        SqlBinaryOperator operator = isIn ? SqlStdOperatorTable.OR : SqlStdOperatorTable.AND;
        return this.rexBuilder.makeCall((SqlOperator)operator, (List)transformedOperands);
    }

    private RexLiteral transformRexLiteral(RexInputRef inputRef, RexLiteral operand2) {
        Comparable literalValue = operand2.getValue();
        String literalValueInString = ((NlsString)literalValue).getValue();
        String typeName = inputRef.getType().getSqlTypeName().getName();
        try {
            if (typeName.equalsIgnoreCase(DATE)) {
                return this.rexBuilder.makeDateLiteral(new DateString(literalValueInString));
            }
            if (typeName.equalsIgnoreCase(TIMESTAMP)) {
                return this.rexBuilder.makeTimestampLiteral(new TimestampString(literalValueInString), inputRef.getType().getPrecision());
            }
        }
        catch (Exception ex) {
            logger.warn("transform Date/Timestamp RexLiteral for filterRel failed", (Throwable)ex);
        }
        return operand2;
    }

    private RexInputRef convertInputRef(RexInputRef rexInputRef, RelNode relNode) {
        if (relNode instanceof TableScan) {
            return this.context.createUniqueInputRefContextTables((OLAPTableScan)relNode, rexInputRef.getIndex());
        }
        if (relNode instanceof Project) {
            Project projectRel = (Project)relNode;
            RexNode expression = (RexNode)projectRel.getChildExps().get(rexInputRef.getIndex());
            return expression instanceof RexInputRef ? this.convertInputRef((RexInputRef)expression, projectRel.getInput(0)) : null;
        }
        int index = rexInputRef.getIndex();
        int currentSize = 0;
        for (int i = 0; i < relNode.getInputs().size(); ++i) {
            Join join;
            if (relNode instanceof Join && ((join = (Join)relNode).getJoinType() == JoinRelType.LEFT && i == 1 || join.getJoinType() == JoinRelType.RIGHT && i == 0 || join.getJoinType() == JoinRelType.FULL)) continue;
            OLAPRel child = (OLAPRel)relNode.getInput(i);
            int childRowTypeSize = child.getColumnRowType().size();
            if (index < currentSize + childRowTypeSize) {
                return this.convertInputRef(RexInputRef.of((int)(index - currentSize), (RelDataType)child.getRowType()), child);
            }
            currentSize += childRowTypeSize;
        }
        return null;
    }
}

