/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryEnumerator
implements Enumerator<Object[]> {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryEnumerator.class);
    private List<Dictionary<String>> dictList;
    private final Object[] current;
    private final TblColRef dictCol;
    private final int dictColIdx;
    private Iterator<String> currentDict;
    private Iterator<Dictionary<String>> iterator;

    public DictionaryEnumerator(OLAPContext olapContext) {
        Preconditions.checkArgument((olapContext.allColumns.size() == 1 ? 1 : 0) != 0, (Object)"The query should only relate to one column");
        this.dictCol = olapContext.allColumns.iterator().next();
        Preconditions.checkArgument((boolean)DictionaryEnumerator.ifColumnHaveDictionary(this.dictCol, olapContext.realization, false), (Object)("The column " + this.dictCol + " should be encoded as dictionary for " + olapContext.realization));
        this.dictList = DictionaryEnumerator.getAllDictionaries(this.dictCol, olapContext.realization);
        this.current = new Object[olapContext.returnTupleInfo.size()];
        this.dictColIdx = olapContext.returnTupleInfo.getColumnIndex(this.dictCol);
        this.reset();
        logger.info("Will use DictionaryEnumerator to answer query which is only related to column " + this.dictCol);
    }

    public static boolean ifDictionaryEnumeratorEligible(OLAPContext olapContext) {
        if (olapContext.allColumns.size() != 1) {
            return false;
        }
        TblColRef dictCol = olapContext.allColumns.iterator().next();
        return DictionaryEnumerator.ifColumnHaveDictionary(dictCol, olapContext.realization, true);
    }

    private static boolean ifColumnHaveDictionary(TblColRef col, IRealization realization, boolean enableCheck) {
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            boolean ifEnabled = !enableCheck || cube.getConfig().isDictionaryEnumeratorEnabled();
            return ifEnabled && cube.getDescriptor().getAllDimsHaveDictionary().contains(col);
        }
        if (realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)realization;
            for (IRealization entry : hybridInstance.getRealizations()) {
                if (DictionaryEnumerator.ifColumnHaveDictionary(col, entry, enableCheck)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<Dictionary<String>> getAllDictionaries(TblColRef col, IRealization realization) {
        HashSet result = Sets.newHashSet();
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            for (CubeSegment segment : cube.getSegments(SegmentStatusEnum.READY)) {
                result.add(segment.getDictionary(col));
            }
        } else if (realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)realization;
            for (IRealization entry : hybridInstance.getRealizations()) {
                result.addAll(DictionaryEnumerator.getAllDictionaries(col, entry));
            }
        } else {
            throw new IllegalStateException("All leaf realizations should be CubeInstance");
        }
        return Lists.newArrayList((Iterable)result);
    }

    public boolean moveNext() {
        while (this.currentDict == null || !this.currentDict.hasNext()) {
            if (!this.iterator.hasNext()) {
                return false;
            }
            Dictionary<String> dict = this.iterator.next();
            this.currentDict = dict.enumeratorValues().iterator();
        }
        this.current[this.dictColIdx] = Tuple.convertOptiqCellValue((String)this.currentDict.next(), (String)this.dictCol.getDatatype());
        return true;
    }

    public Object[] current() {
        return this.current;
    }

    public void reset() {
        this.iterator = this.dictList.iterator();
    }

    public void close() {
    }
}

