/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateJoinTransposeRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.AggregateUnionTransposeRule;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinPushExpressionsRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.JoinUnionTransposeRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.rules.SortJoinTransposeRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.SortUnionTransposeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.enumerator.DictionaryEnumerator;
import org.apache.kylin.query.optrule.AggregateProjectReduceRule;
import org.apache.kylin.query.optrule.KylinSortProjectTransposeRule;
import org.apache.kylin.query.optrule.OLAPAggregateRule;
import org.apache.kylin.query.optrule.OLAPFilterRule;
import org.apache.kylin.query.optrule.OLAPJoinRule;
import org.apache.kylin.query.optrule.OLAPLimitRule;
import org.apache.kylin.query.optrule.OLAPProjectRule;
import org.apache.kylin.query.optrule.OLAPSortRule;
import org.apache.kylin.query.optrule.OLAPToEnumerableConverterRule;
import org.apache.kylin.query.optrule.OLAPUnionRule;
import org.apache.kylin.query.optrule.OLAPValuesRule;
import org.apache.kylin.query.optrule.OLAPWindowRule;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPProjectRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPToEnumerableConverter;
import org.apache.kylin.query.relnode.OLAPUnionRel;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPTableScan
extends TableScan
implements OLAPRel,
EnumerableRel {
    protected final OLAPTable olapTable;
    private final String tableName;
    protected final int[] fields;
    private String alias;
    private String backupAlias;
    protected ColumnRowType columnRowType;
    protected OLAPContext context;
    protected KylinConfig kylinConfig;

    public OLAPTableScan(RelOptCluster cluster, RelOptTable table, OLAPTable olapTable, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)OLAPRel.CONVENTION), table);
        this.olapTable = olapTable;
        this.fields = fields;
        this.tableName = olapTable.getTableName();
        this.rowType = this.getRowType();
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
    }

    public OLAPTable getOlapTable() {
        return this.olapTable;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int[] getFields() {
        return this.fields;
    }

    public String getBackupAlias() {
        return this.backupAlias;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    void overrideContext(OLAPContext context) {
        this.context = context;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument((boolean)inputs.isEmpty());
        return new OLAPTableScan(this.getCluster(), this.table, this.olapTable, this.fields);
    }

    public void register(RelOptPlanner planner) {
        OLAPContext.clearThreadLocalContexts();
        this.addRules(planner, this.kylinConfig.getCalciteAddRule());
        planner.addRule((RelOptRule)OLAPToEnumerableConverterRule.INSTANCE);
        planner.addRule(OLAPFilterRule.INSTANCE);
        planner.addRule(OLAPProjectRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPAggregateRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPJoinRule.INSTANCE);
        planner.addRule(OLAPLimitRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPSortRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPUnionRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPWindowRule.INSTANCE);
        planner.addRule((RelOptRule)OLAPValuesRule.INSTANCE);
        planner.addRule((RelOptRule)AggregateProjectReduceRule.INSTANCE);
        if (this.kylinConfig.isReduceExpressionsRulesEnabled()) {
            planner.addRule((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE);
            planner.addRule((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
            planner.addRule((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE);
            planner.addRule((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE);
        }
        this.removeRules(planner, this.kylinConfig.getCalciteRemoveRule());
        if (!this.kylinConfig.isEnumerableRulesEnabled()) {
            for (RelOptRule rule : CalcitePrepareImpl.ENUMERABLE_RULES) {
                planner.removeRule(rule);
            }
        }
        planner.removeRule((RelOptRule)FilterJoinRule.FILTER_ON_JOIN);
        planner.removeRule((RelOptRule)FilterJoinRule.JOIN);
        planner.removeRule((RelOptRule)JoinCommuteRule.INSTANCE);
        planner.removeRule(JoinPushThroughJoinRule.LEFT);
        planner.removeRule(JoinPushThroughJoinRule.RIGHT);
        planner.removeRule((RelOptRule)AggregateJoinTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)AggregateProjectMergeRule.INSTANCE);
        planner.removeRule((RelOptRule)FilterProjectTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)SortJoinTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)JoinPushExpressionsRule.INSTANCE);
        planner.removeRule((RelOptRule)SortUnionTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)JoinUnionTransposeRule.LEFT_UNION);
        planner.removeRule((RelOptRule)JoinUnionTransposeRule.RIGHT_UNION);
        planner.removeRule((RelOptRule)AggregateUnionTransposeRule.INSTANCE);
        planner.removeRule(DateRangeRules.FILTER_INSTANCE);
        planner.removeRule((RelOptRule)SemiJoinRule.JOIN);
        planner.removeRule((RelOptRule)SemiJoinRule.PROJECT);
        planner.removeRule((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE);
        planner.removeRule((RelOptRule)AbstractConverter.ExpandConversionRule.INSTANCE);
        planner.removeRule((RelOptRule)SortProjectTransposeRule.INSTANCE);
        planner.addRule((RelOptRule)KylinSortProjectTransposeRule.INSTANCE);
    }

    protected void addRules(final RelOptPlanner planner, List<String> rules) {
        this.modifyRules(rules, new Function<RelOptRule, Void>(){

            @Nullable
            public Void apply(@Nullable RelOptRule input) {
                planner.addRule(input);
                return null;
            }
        });
    }

    protected void removeRules(final RelOptPlanner planner, List<String> rules) {
        this.modifyRules(rules, new Function<RelOptRule, Void>(){

            @Nullable
            public Void apply(@Nullable RelOptRule input) {
                planner.removeRule(input);
                return null;
            }
        });
    }

    private void modifyRules(List<String> rules, Function<RelOptRule, Void> func) {
        for (String rule : rules) {
            if (StringUtils.isEmpty((CharSequence)rule)) continue;
            String[] split = StringUtil.split((String)rule, (String)"#");
            if (split.length != 2) {
                throw new RuntimeException("Customized Rule should be in format <RuleClassName>#<FieldName>");
            }
            String clazz = split[0];
            String field = split[1];
            try {
                func.apply((Object)((RelOptRule)Class.forName(clazz).getDeclaredField(field).get(null)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)builder);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization)).item("fields", (Object)Primitive.asList((int[])this.fields));
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        Preconditions.checkState((this.columnRowType == null ? 1 : 0) != 0, (Object)"OLAPTableScan MUST NOT be shared by more than one prent");
        if (implementor.getContext() == null || !(implementor.getParentNode() instanceof OLAPJoinRel) || implementor.isNewOLAPContextRequired()) {
            implementor.allocateContext();
        }
        this.context = implementor.getContext();
        this.context.allTableScans.add(this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context.olapSchema == null) {
            OLAPSchema schema;
            this.context.olapSchema = schema = this.olapTable.getSchema();
            this.context.storageContext.setConnUrl(schema.getStorageUrl());
        }
        if (this.context.firstTableScan == null) {
            this.context.firstTableScan = this;
        }
        if (this.needCollectionColumns(implementor)) {
            for (TblColRef tblColRef : this.columnRowType.getAllColumns()) {
                if (tblColRef.getName().startsWith("_KY_")) continue;
                this.context.allColumns.add(tblColRef);
            }
        }
    }

    private boolean needCollectionColumns(OLAPRel.OLAPImplementor implementor) {
        Stack<RelNode> allParents = implementor.getParentNodeStack();
        for (int index = allParents.size() - 1; index >= 0; --index) {
            RelNode parent = (RelNode)allParents.get(index);
            if (parent instanceof OLAPProjectRel) {
                return false;
            }
            if (parent instanceof OLAPToEnumerableConverter || parent instanceof OLAPUnionRel) {
                return true;
            }
            OLAPRel olapParent = (OLAPRel)allParents.get(index);
            if (olapParent.getContext() != null && olapParent.getContext() != this.context) break;
        }
        return true;
    }

    public String getAlias() {
        return this.alias;
    }

    private ColumnRowType buildColumnRowType() {
        this.alias = this.context.allTableScans.size() + "_" + Integer.toHexString(System.identityHashCode(this));
        TableRef tableRef = TblColRef.tableForUnknownModel((String)this.alias, (TableDesc)this.olapTable.getSourceTable());
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        for (ColumnDesc sourceColumn : this.olapTable.getSourceColumns()) {
            TblColRef colRef = TblColRef.columnForUnknownModel((TableRef)tableRef, (ColumnDesc)sourceColumn);
            columns.add(colRef);
        }
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    public TableRef getTableRef() {
        return this.columnRowType.getColumnByIndex(0).getTableRef();
    }

    public TblColRef makeRewriteColumn(String name) {
        return this.getTableRef().makeFakeColumn(name);
    }

    public void fixColumnRowTypeWithModel(DataModelDesc model, Map<String, String> aliasMap) {
        String newAlias = aliasMap.get(this.alias);
        for (TblColRef col : this.columnRowType.getAllColumns()) {
            TblColRef.fixUnknownModel((DataModelDesc)model, (String)newAlias, (TblColRef)col);
        }
        this.backupAlias = this.alias;
        this.alias = newAlias;
    }

    public void unfixColumnRowTypeWithModel() {
        this.alias = this.backupAlias;
        this.backupAlias = null;
        for (TblColRef col : this.columnRowType.getAllColumns()) {
            TblColRef.unfixUnknownModel((TblColRef)col);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return this;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        String execFunction = this.genExecFunc();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.ARRAY);
        MethodCallExpression exprCall = Expressions.call((Expression)this.table.getExpression(OLAPTable.class), (String)execFunction, (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.context.id)});
        return implementor.result(physType, Blocks.toBlock((Node)exprCall));
    }

    public String genExecFunc() {
        if (this.context.realization.getModel().isLookupTable(this.tableName)) {
            return "executeLookupTableQuery";
        }
        if (DictionaryEnumerator.ifDictionaryEnumeratorEligible(this.context)) {
            return "executeColumnDictionaryQuery";
        }
        return "executeOLAPQuery";
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        Map<String, RelDataType> rewriteFields = this.context.rewriteFields;
        for (Map.Entry<String, RelDataType> rewriteField : rewriteFields.entrySet()) {
            String fieldName = rewriteField.getKey();
            RelDataTypeField field = this.rowType.getField(fieldName, true, false);
            if (field == null) continue;
            RelDataType fieldType = field.getType();
            rewriteField.setValue(fieldType);
        }
        if (!this.context.hasJoin && !this.context.dynamicFields.isEmpty()) {
            Map<TblColRef, RelDataType> dynFields = this.context.dynamicFields;
            ArrayList newCols = Lists.newArrayList(this.columnRowType.getAllColumns());
            ArrayList newFieldList = Lists.newArrayList((Iterable)this.rowType.getFieldList());
            int paramIndex = this.rowType.getFieldList().size();
            for (TblColRef fieldCol : dynFields.keySet()) {
                newCols.add(fieldCol);
                RelDataType fieldType = dynFields.get(fieldCol);
                RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldCol.getName(), paramIndex++, fieldType);
                newFieldList.add(newField);
            }
            RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
            fieldInfo.addAll((Iterable)newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
            this.columnRowType = new ColumnRowType(newCols);
        }
    }

    @Override
    public boolean hasSubQuery() {
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }
}

