/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.metrics;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metrics.QuerySparkMetrics;
import org.apache.kylin.rest.metrics.QueryMetrics;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

@ThreadSafe
public class QueryMetricsFacade {
    private static final Logger logger = LoggerFactory.getLogger(QueryMetricsFacade.class);
    private static final HashFunction hashFunc = Hashing.murmur3_128();
    private static boolean enabled = false;
    private static ConcurrentHashMap<String, QueryMetrics> metricsMap = new ConcurrentHashMap();

    public static void init() {
        enabled = KylinConfig.getInstanceFromEnv().getQueryMetricsEnabled();
        if (!enabled) {
            return;
        }
        DefaultMetricsSystem.initialize((String)"Kylin");
    }

    private static long getSqlHashCode(String sql) {
        return hashFunc.hashString((CharSequence)sql, Charset.forName("UTF-8")).asLong();
    }

    public static void updateMetrics(String queryId, SQLRequest sqlRequest, SQLResponse sqlResponse) {
        QueryMetricsFacade.updateMetricsToLocal(sqlRequest, sqlResponse);
        QueryMetricsFacade.updateMetricsToCache(queryId, sqlRequest, sqlResponse);
    }

    private static void updateMetricsToLocal(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (!enabled) {
            return;
        }
        String projectName = sqlRequest.getProject();
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics("Server_Total"), sqlResponse);
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(projectName), sqlResponse);
        String cube = sqlResponse.getCube();
        if (StringUtils.isEmpty((CharSequence)cube)) {
            return;
        }
        String cubeName = cube.replace("=", "->");
        String cubeMetricName = projectName + ",sub=" + cubeName;
        QueryMetricsFacade.update(QueryMetricsFacade.getQueryMetrics(cubeMetricName), sqlResponse);
    }

    private static void updateMetricsToCache(String queryId, SQLRequest sqlRequest, SQLResponse sqlResponse) {
        QuerySparkMetrics.QueryExecutionMetrics queryExecutionMetrics;
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        if (user == null) {
            user = "unknown";
        }
        if ((queryExecutionMetrics = (QuerySparkMetrics.QueryExecutionMetrics)QuerySparkMetrics.getInstance().getQueryExecutionMetricsMap().getIfPresent((Object)queryId)) != null) {
            queryExecutionMetrics.setUser(user);
            queryExecutionMetrics.setSqlIdCode(QueryMetricsFacade.getSqlHashCode(sqlRequest.getSql()));
            queryExecutionMetrics.setProject(QueryMetricsFacade.norm(sqlRequest.getProject()));
            queryExecutionMetrics.setQueryType(sqlResponse.isStorageCacheUsed() ? "CACHE" : "PARQUET");
            queryExecutionMetrics.setRealization(sqlResponse.getCube());
            queryExecutionMetrics.setRealizationTypes(sqlResponse.getRealizationTypes());
            queryExecutionMetrics.setCuboidIds(sqlResponse.getCuboidIds());
            queryExecutionMetrics.setSqlDuration(sqlResponse.getDuration());
            queryExecutionMetrics.setTotalScanCount(sqlResponse.getTotalScanCount());
            queryExecutionMetrics.setTotalScanBytes(sqlResponse.getTotalScanBytes());
            queryExecutionMetrics.setResultCount(sqlResponse.getResults() == null ? 0 : sqlResponse.getResults().size());
            queryExecutionMetrics.setException(sqlResponse.getThrowable() == null ? "NULL" : sqlResponse.getThrowable().getClass().getName());
        }
    }

    private static String norm(String project) {
        return project.toUpperCase(Locale.ROOT);
    }

    private static void update(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        try {
            QueryMetricsFacade.incrQueryCount(queryMetrics, sqlResponse);
            QueryMetricsFacade.incrCacheHitCount(queryMetrics, sqlResponse);
            if (!sqlResponse.getIsException()) {
                queryMetrics.addQueryLatency(sqlResponse.getDuration());
                queryMetrics.addScanRowCount(sqlResponse.getTotalScanCount());
                queryMetrics.addResultRowCount(sqlResponse.getResults().size());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static void incrQueryCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (!sqlResponse.isHitExceptionCache() && !sqlResponse.getIsException()) {
            queryMetrics.incrQuerySuccessCount();
        } else {
            queryMetrics.incrQueryFailCount();
        }
        queryMetrics.incrQueryCount();
    }

    private static void incrCacheHitCount(QueryMetrics queryMetrics, SQLResponse sqlResponse) {
        if (sqlResponse.isStorageCacheUsed()) {
            queryMetrics.addCacheHitCount(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryMetrics getQueryMetrics(String name) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int[] intervals = config.getQueryMetricsPercentilesIntervals();
        QueryMetrics queryMetrics = metricsMap.get(name);
        if (queryMetrics != null) {
            return queryMetrics;
        }
        Class<QueryMetricsFacade> clazz = QueryMetricsFacade.class;
        synchronized (QueryMetricsFacade.class) {
            queryMetrics = metricsMap.get(name);
            if (queryMetrics != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return queryMetrics;
            }
            try {
                queryMetrics = new QueryMetrics(intervals).registerWith(name);
                metricsMap.put(name, queryMetrics);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return queryMetrics;
            }
            catch (MetricsException e) {
                logger.warn(name + " register error: ", (Throwable)e);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return queryMetrics;
        }
    }
}

