/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.fs;

import alluxio.client.file.CacheContext;
import alluxio.client.file.FileInStream;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.LocalCacheFileInStream;
import alluxio.conf.AlluxioConfiguration;
import alluxio.hadoop.AlluxioHdfsInputStream;
import alluxio.hadoop.HadoopFileOpener;
import alluxio.hadoop.HadoopUtils;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import alluxio.wire.FileInfo;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Hashing;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.cache.fs.AlluxioHdfsFileInputStream;
import org.apache.kylin.cache.fs.CacheFileInputStream;
import org.apache.kylin.cache.utils.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheFileSystem
extends FilterFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCacheFileSystem.class);
    protected URI uri;
    protected String originalScheme;
    protected int bufferSize = 4096;
    protected boolean useLocalCache = false;
    protected boolean useLegacyFileInputStream = false;
    protected HadoopFileOpener mHadoopFileOpener;
    protected LocalCacheFileInStream.FileInStreamOpener mAlluxioFileOpener;
    protected CacheManager mCacheManager;
    protected AlluxioConfiguration mAlluxioConf;
    protected LoadingCache<Path, FileStatus> fileStatusCache;
    protected static final Map<String, String> schemeClassMap = new HashMap<String, String>(){
        {
            this.put("file", "org.apache.hadoop.fs.LocalFileSystem");
            this.put("viewfs", "org.apache.hadoop.fs.viewfs.ViewFileSystem");
            this.put("s3a", "org.apache.hadoop.fs.s3a.S3AFileSystem");
            this.put("s3", "org.apache.hadoop.fs.s3.S3FileSystem");
            this.put("s3n", "org.apache.hadoop.fs.s3native.NativeS3FileSystem");
            this.put("hdfs", "org.apache.hadoop.hdfs.DistributedFileSystem");
            this.put("wasb", "org.apache.hadoop.fs.azure.NativeAzureFileSystem");
            this.put("wasbs", "org.apache.hadoop.fs.azure.NativeAzureFileSystem$Secure");
            this.put("jfs", "io.juicefs.JuiceFileSystem");
            this.put("alluxio", "alluxio.hadoop.FileSystem");
        }
    };

    protected static FileSystem createInternalFS(URI uri, Configuration conf) throws IOException {
        if (!schemeClassMap.containsKey(uri.getScheme())) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        FileSystem fs = null;
        try {
            Class clazz = conf.getClassByName(schemeClassMap.get(uri.getScheme()));
            fs = (FileSystem)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
            fs.initialize(uri, conf);
            LOG.info("Create filesystem {} for scheme {} .", (Object)schemeClassMap.get(uri.getScheme()), (Object)uri.getScheme());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Can not found FileSystem Clazz for scheme: " + uri.getScheme() + " Exception is: " + e.getMessage());
        }
        return fs;
    }

    protected void createLocalCacheManager(URI name, Configuration conf) throws IOException {
        this.mHadoopFileOpener = uriStatus -> this.fs.open(new Path(uriStatus.getPath()));
        this.mAlluxioFileOpener = status -> new AlluxioHdfsInputStream(this.mHadoopFileOpener.open(status));
        this.mAlluxioConf = HadoopUtils.toAlluxioConf((Configuration)conf);
        Properties metricsProperties = new Properties();
        for (Map.Entry entry : conf) {
            metricsProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        MetricsSystem.startSinksFromConfig((MetricsConfig)new MetricsConfig(metricsProperties));
        this.mCacheManager = CacheManager.Factory.get((AlluxioConfiguration)this.mAlluxioConf);
        if (this.mCacheManager == null) {
            throw new IOException("CacheManager is null !");
        }
    }

    public synchronized void initialize(URI name, Configuration conf) throws IOException {
        this.originalScheme = name.getScheme();
        this.fs = AbstractCacheFileSystem.createInternalFS(name, conf);
        this.statistics = (FileSystem.Statistics)ReflectionUtil.getFieldValue(this.fs, "statistics");
        if (null == this.statistics) {
            LOG.info("======= original statistics is null.");
        } else {
            LOG.info("======= original statistics is {} {}.", (Object)this.statistics.getScheme(), (Object)this.statistics.toString());
        }
        super.initialize(name, conf);
        this.setConf(conf);
        LOG.info("======= current statistics is {} {}.", (Object)this.statistics.getScheme(), (Object)this.statistics.toString());
        this.bufferSize = conf.getInt("io.file.buffer.size", 65536);
        this.useLocalCache = conf.getBoolean("spark.kylin.local-cache.enabled", false) && !this.originalScheme.equals("jfs");
        this.useLegacyFileInputStream = conf.getBoolean("spark.kylin.local-cache.use.legacy.file.input-stream", false);
        long fileStatusTTL = conf.getLong("spark.kylin.local-cache.filestatus.cache.ttl", 3600L);
        long fileStatusMaxSize = conf.getLong("spark.kylin.local-cache.filestatus.cache.max-size", 10000L);
        CacheLoader<Path, FileStatus> fileStatusCacheLoader = new CacheLoader<Path, FileStatus>(){

            public FileStatus load(Path path) throws Exception {
                return AbstractCacheFileSystem.this.getFileStatusForCache(path);
            }
        };
        this.fileStatusCache = CacheBuilder.newBuilder().maximumSize(fileStatusMaxSize).expireAfterAccess(fileStatusTTL, TimeUnit.SECONDS).recordStats().build((CacheLoader)fileStatusCacheLoader);
        if (this.isUseLocalCache()) {
            this.createLocalCacheManager(this.getUri(), conf);
            LOG.info("Create LocalCacheFileSystem successfully .");
        }
    }

    protected FileStatus getFileStatusForCache(Path path) throws IOException {
        return this.fs.getFileStatus(path);
    }

    public String getScheme() {
        return this.originalScheme;
    }

    public FSDataInputStream open(Path f) throws IOException {
        return this.open(f, this.bufferSize);
    }

    public abstract boolean isUseLocalCacheForTargetExecs();

    public FileInfo wrapFileInfo(FileStatus fileStatus) {
        return new FileInfo().setLength(fileStatus.getLen()).setPath(fileStatus.getPath().toString()).setFolder(fileStatus.isDirectory()).setBlockSizeBytes(fileStatus.getBlockSize()).setLastModificationTimeMs(fileStatus.getModificationTime()).setLastAccessTimeMs(fileStatus.getAccessTime()).setOwner(fileStatus.getOwner()).setGroup(fileStatus.getGroup());
    }

    private int checkBufferSize(int size) {
        if (size < this.bufferSize) {
            size = this.bufferSize;
        }
        return size;
    }

    public FSDataInputStream open(Path p, int bufferSize) throws IOException {
        return this.open(p, bufferSize, this.isUseLocalCacheForTargetExecs());
    }

    public FSDataInputStream open(Path p, int bufferSize, boolean useLocalCacheForExec) throws IOException {
        Path f = this.fs.makeQualified(p);
        if (this.isUseLocalCache() && this.mCacheManager != null && useLocalCacheForExec) {
            FileStatus fileStatus = this.getFileStatus(f);
            FileInfo fileInfo = this.wrapFileInfo(fileStatus);
            CacheContext context = CacheContext.defaults().setCacheIdentifier(Hashing.md5().hashString((CharSequence)fileStatus.getPath().toString(), StandardCharsets.UTF_8).toString());
            URIStatus status = new URIStatus(fileInfo, context);
            LOG.info("Use local cache FileSystem to open file {} .", (Object)f);
            if (this.useLegacyFileInputStream) {
                return new FSDataInputStream((InputStream)new AlluxioHdfsFileInputStream((FileInStream)new LocalCacheFileInStream(status, this.mAlluxioFileOpener, this.mCacheManager, this.mAlluxioConf), this.statistics));
            }
            return new FSDataInputStream((InputStream)((Object)new CacheFileInputStream(f, (FileInStream)new LocalCacheFileInStream(status, this.mAlluxioFileOpener, this.mCacheManager, this.mAlluxioConf), null, this.statistics, this.checkBufferSize(bufferSize))));
        }
        LOG.info("Use original FileSystem to open file {} .", (Object)f);
        return super.open(f, bufferSize);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        long start = System.currentTimeMillis();
        FileStatus fileStatus = null;
        Path p = this.fs.makeQualified(f);
        try {
            fileStatus = (FileStatus)this.fileStatusCache.get((Object)p);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                throw new FileNotFoundException("File does not exist: " + p);
            }
            LOG.error("Get file status from cache error: " + p, (Throwable)e);
            return fileStatus;
        }
        LOG.info("Get file status {} from cache took: {}", (Object)f, (Object)(System.currentTimeMillis() - start));
        return fileStatus;
    }

    public CacheManager getmCacheManager() {
        return this.mCacheManager;
    }

    public void setmCacheManager(CacheManager mCacheManager) {
        this.mCacheManager = mCacheManager;
    }

    public AlluxioConfiguration getmAlluxioConf() {
        return this.mAlluxioConf;
    }

    public void setmAlluxioConf(AlluxioConfiguration mAlluxioConf) {
        this.mAlluxioConf = mAlluxioConf;
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isUseLegacyFileInputStream() {
        return this.useLegacyFileInputStream;
    }

    public void setUseLegacyFileInputStream(boolean useLegacyFileInputStream) {
        this.useLegacyFileInputStream = useLegacyFileInputStream;
    }

    public LoadingCache<Path, FileStatus> getFileStatusCache() {
        return this.fileStatusCache;
    }
}

