/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.hive.HiveMetaStoreClientFactory;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.HiveTableMetaBuilder;
import org.apache.kylin.source.hive.IHiveClient;

public class CLIHiveClient
implements IHiveClient {
    protected HiveConf hiveConf = new HiveConf(CLIHiveClient.class);
    protected IMetaStoreClient metaStoreClient = null;

    @Override
    public void executeHQL(String hql) throws IOException {
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(hql);
        Pair response = KylinConfig.getInstanceFromEnv().getCliCommandExecutor().execute(hiveCmdBuilder.toString());
        if ((Integer)response.getFirst() != 0) {
            throw new IllegalArgumentException("Failed to execute hql [" + hql + "], error message is: " + (String)response.getSecond());
        }
    }

    @Override
    public void executeHQL(String[] hqls) throws IOException {
        for (String sql : hqls) {
            this.executeHQL(sql);
        }
    }

    @Override
    public HiveTableMeta getHiveTableMeta(String database, String tableName) throws Exception {
        HiveTableMetaBuilder builder = new HiveTableMetaBuilder();
        org.apache.hadoop.hive.metastore.api.Table table = this.getMetaStoreClient().getTable(database, tableName);
        List allFields = this.getMetaStoreClient().getFields(database, tableName);
        List partitionFields = table.getPartitionKeys();
        if (allFields == null) {
            allFields = Lists.newArrayList();
        }
        if (partitionFields != null && partitionFields.size() > 0) {
            allFields.addAll(partitionFields);
        }
        ArrayList allColumns = Lists.newArrayList();
        ArrayList partitionColumns = Lists.newArrayList();
        for (FieldSchema fieldSchema : allFields) {
            allColumns.add(new HiveTableMeta.HiveTableColumnMeta(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
        }
        if (partitionFields != null && partitionFields.size() > 0) {
            for (FieldSchema fieldSchema : partitionFields) {
                partitionColumns.add(new HiveTableMeta.HiveTableColumnMeta(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
            }
        }
        builder.setAllColumns(allColumns);
        builder.setPartitionColumns(partitionColumns);
        builder.setSdLocation(table.getSd().getLocation());
        builder.setFileSize(this.getBasicStatForTable(new Table(table), "totalSize"));
        builder.setFileNum(this.getBasicStatForTable(new Table(table), "numFiles"));
        builder.setRowNum(this.getBasicStatForTable(new Table(table), "numRows"));
        builder.setIsNative(!MetaStoreUtils.isNonNativeTable((org.apache.hadoop.hive.metastore.api.Table)table));
        builder.setTableName(tableName);
        builder.setSdInputFormat(table.getSd().getInputFormat());
        builder.setSdOutputFormat(table.getSd().getOutputFormat());
        builder.setOwner(table.getOwner());
        builder.setLastAccessTime(table.getLastAccessTime());
        builder.setTableType(table.getTableType());
        builder.setSkipHeaderLineCount((String)table.getParameters().get("skip.header.line.count"));
        return builder.createHiveTableMeta();
    }

    @Override
    public List<String> getHiveDbNames() throws Exception {
        return this.getMetaStoreClient().getAllDatabases();
    }

    @Override
    public List<String> getHiveTableNames(String database) throws Exception {
        return this.getMetaStoreClient().getAllTables(database);
    }

    @Override
    public long getHiveTableRows(String database, String tableName) throws Exception {
        long count = 0L;
        org.apache.hadoop.hive.metastore.api.Table table = this.getMetaStoreClient().getTable(database, tableName);
        count = this.getBasicStatForTable(new Table(table), "numRows");
        if (count <= 0L) {
            String querySQL = "select count(*) from ".concat(database + "." + tableName);
            List<Object[]> datas = null;
            try {
                datas = this.getHiveResult(querySQL);
                if (!Objects.nonNull(datas) || datas.isEmpty()) {
                    throw new IOException("execute get hive table rows result fail : " + querySQL);
                }
                count = Integer.parseInt(datas.get(0)[0] + "");
            }
            catch (Exception e) {
                throw new IOException("execute get hive table rows result fail : " + querySQL, e);
            }
        }
        return count;
    }

    @Override
    public List<Object[]> getHiveResult(String hql) throws Exception {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(hql);
        Pair response = KylinConfig.getInstanceFromEnv().getCliCommandExecutor().execute(hiveCmdBuilder.toString());
        String[] respData = ((String)response.getSecond()).split("\n");
        boolean isData = false;
        for (String item : respData) {
            if (item.trim().equalsIgnoreCase("OK")) {
                isData = true;
                continue;
            }
            if (item.trim().startsWith("Time taken")) {
                isData = false;
            }
            if (!isData) continue;
            String[] arr = item.split("\t");
            data.add(arr);
        }
        return data;
    }

    private IMetaStoreClient getMetaStoreClient() throws Exception {
        if (this.metaStoreClient == null) {
            this.metaStoreClient = HiveMetaStoreClientFactory.getHiveMetaStoreClient(this.hiveConf);
        }
        return this.metaStoreClient;
    }

    private long getBasicStatForTable(Table table, String statType) {
        Map params = table.getParameters();
        long result = 0L;
        if (params != null) {
            try {
                result = Long.parseLong((String)params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
        }
        return result;
    }
}

