/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.apache.kylin.source.hive.HiveClientFactory;
import org.apache.kylin.source.hive.IHiveClient;
import org.apache.kylin.source.hive.MRHiveDictUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMrHiveDictStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CreateMrHiveDictStep.class);
    private final PatternedLogger stepLogger = new PatternedLogger(logger);
    private final Lock threadLock = new ReentrantLock();
    private static final String GET_SQL = "\" Get Max Dict Value Sql : \"";

    protected void createMrHiveDict(KylinConfig config, DistributedLock lock) throws Exception {
        logger.info("Start to run createMrHiveDict {}", (Object)this.getId());
        try {
            if (this.getIsLock()) {
                this.getLock(lock);
            }
            HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder(this.getName());
            hiveCmdBuilder.overwriteHiveProps(config.getHiveConfigOverride());
            hiveCmdBuilder.addStatement(this.getInitStatement());
            String sql = this.getCreateTableStatement();
            if (sql != null && sql.length() > 0) {
                hiveCmdBuilder.addStatement(sql);
            }
            Map<String, String> maxDictValMap = CreateMrHiveDictStep.deserializeForMap(this.getMaxDictStatementMap());
            Map<String, String> dictSqlMap = CreateMrHiveDictStep.deserializeForMap(this.getCreateTableStatementMap());
            if (!dictSqlMap.isEmpty()) {
                IHiveClient hiveClient = HiveClientFactory.getHiveClient();
                if (!maxDictValMap.isEmpty()) {
                    if (maxDictValMap.size() == dictSqlMap.size()) {
                        maxDictValMap.forEach((columnName, maxDictValSql) -> {
                            int max = 0;
                            List<Object[]> datas = null;
                            try {
                                datas = hiveClient.getHiveResult((String)maxDictValSql);
                                if (!Objects.nonNull(datas) || datas.isEmpty()) {
                                    this.stepLogger.log(columnName + GET_SQL + maxDictValSql);
                                    this.stepLogger.log(columnName + " Get Max Dict Value Of ERROR: hive execute result is null.");
                                    throw new IOException("execute get max dict result fail : " + maxDictValSql);
                                }
                                max = Integer.valueOf(datas.get(0)[0] + "");
                                this.stepLogger.log(columnName + GET_SQL + maxDictValSql);
                                this.stepLogger.log(columnName + " Get Max Dict Value Of : " + max);
                            }
                            catch (Exception e) {
                                this.stepLogger.log(columnName + GET_SQL + maxDictValSql);
                                this.stepLogger.log(columnName + " Get Max Dict Value Of ERROR :" + e.getMessage());
                                logger.error("execute get max dict result fail : " + maxDictValSql, (Throwable)e);
                            }
                            String dictSql = ((String)dictSqlMap.get(columnName)).replace("___maxDictVal___", max + "");
                            hiveCmdBuilder.addStatement(dictSql);
                        });
                    } else {
                        logger.error("Max Dict Value size is not equals Dict Sql size ! ");
                    }
                } else {
                    dictSqlMap.forEach((columnName, dictSql) -> hiveCmdBuilder.addStatement(dictSql));
                }
            }
            String cmd = hiveCmdBuilder.toString();
            this.stepLogger.log("Build Hive Global Dictionary by: " + cmd);
            CubeManager manager = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            CubeInstance cube = manager.getCube(this.getCubeName());
            if (config.isLivyEnabled() && cube.getEngineType() == 4) {
                MRHiveDictUtil.runLivySqlJob(this.stepLogger, config, (ImmutableList<String>)ImmutableList.copyOf((Collection)hiveCmdBuilder.getStatements()), this.getManager(), this.getId());
            } else {
                Pair response = config.getCliCommandExecutor().execute(cmd, (org.apache.kylin.common.util.Logger)this.stepLogger);
                if ((Integer)response.getFirst() != 0) {
                    throw new RuntimeException("Failed to create MR/Hive dict, error code " + response.getFirst());
                }
            }
            if (this.getIsUnlock()) {
                this.unLock(lock);
            }
            this.getManager().addJobInfo(this.getId(), this.stepLogger.getInfo());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw e;
        }
    }

    public KylinConfig getCubeSpecificConfig() {
        String cubeName = CubingExecutableUtil.getCubeName((Map)this.getParams());
        CubeManager manager = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        CubeInstance cube = manager.getCube(cubeName);
        return cube.getConfig();
    }

    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        KylinConfig config = this.getCubeSpecificConfig();
        DistributedLock lock = null;
        try {
            if (this.getIsLock() || this.getIsUnlock()) {
                lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
            }
            this.createMrHiveDict(config, lock);
            if (this.isDiscarded()) {
                if (this.getIsLock() && lock != null) {
                    this.unLock(lock);
                }
                return new ExecuteResult(ExecuteResult.State.DISCARDED, this.stepLogger.getBufferedLog());
            }
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", (Throwable)e);
            if (this.isDiscarded()) {
                if (this.getIsLock()) {
                    this.unLock(lock);
                }
                return new ExecuteResult(ExecuteResult.State.DISCARDED, this.stepLogger.getBufferedLog());
            }
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog());
        }
    }

    private void doRetry(String cmd, KylinConfig config) throws Exception {
        if (Objects.nonNull(cmd)) {
            this.stepLogger.log("cmd : " + cmd);
            int currTimes = 0;
            int maxTimes = 360;
            boolean flag = true;
            while (flag && currTimes <= maxTimes) {
                try {
                    Pair result = config.getCliCommandExecutor().execute(cmd, (org.apache.kylin.common.util.Logger)this.stepLogger);
                    this.stepLogger.log(result.toString());
                    flag = false;
                }
                catch (Exception e) {
                    this.stepLogger.log("execute : " + cmd + " Failed && And errLog is " + e.getMessage());
                    Thread.sleep(60000L);
                    currTimes += 60;
                }
            }
        }
    }

    public void setInitStatement(String sql) {
        this.setParam("HiveInit", sql);
    }

    public String getInitStatement() {
        return this.getParam("HiveInit");
    }

    public void setCreateTableStatement(String sql) {
        this.setParam("HiveRedistributeData", sql);
    }

    public String getCreateTableStatement() {
        return this.getParam("HiveRedistributeData");
    }

    public void setCreateTableStatementMap(Map<String, String> dictSqlMap) {
        this.setParam("DictSqlMap", CreateMrHiveDictStep.serializeMap(dictSqlMap));
    }

    public String getCreateTableStatementMap() {
        return this.getParam("DictSqlMap");
    }

    public void setMaxDictStatementMap(Map<String, String> maxDictValMap) {
        this.setParam("DictMaxMap", CreateMrHiveDictStep.serializeMap(maxDictValMap));
    }

    public String getMaxDictStatementMap() {
        return this.getParam("DictMaxMap");
    }

    public void setIsLock(Boolean isLock) {
        this.setParam("isLock", String.valueOf(isLock));
    }

    public boolean getIsLock() {
        String isLock = this.getParam("isLock");
        return !Strings.isNullOrEmpty((String)isLock) && Boolean.parseBoolean(isLock);
    }

    public void setJobFlowJobId(String jobId) {
        this.setParam("jobFlowJobId", jobId);
    }

    public String getJobFlowJobId() {
        return this.getParam("jobFlowJobId");
    }

    public void setIsUnLock(Boolean isUnLock) {
        this.setParam("isUnLock", String.valueOf(isUnLock));
    }

    public boolean getIsUnlock() {
        String isUnLock = this.getParam("isUnLock");
        return !Strings.isNullOrEmpty((String)isUnLock) && Boolean.parseBoolean(isUnLock);
    }

    public void setLockPathName(String pathName) {
        this.setParam("lockPathName", pathName);
    }

    public String getLockPathName() {
        return this.getParam("lockPathName");
    }

    private String getMRDictLockPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty((String)pathName)) {
            throw new IllegalArgumentException(" create MR/Hive dict lock path name is null");
        }
        String flowJobId = this.getJobFlowJobId();
        if (Strings.isNullOrEmpty((String)flowJobId)) {
            throw new IllegalArgumentException(" create MR/Hive dict lock path flowJobId is null");
        }
        return MRHiveDictUtil.getLockPath(pathName, flowJobId);
    }

    private String getMRDictLockParentPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty((String)pathName)) {
            throw new IllegalArgumentException(" create MR/Hive dict lock path name is null");
        }
        return MRHiveDictUtil.getLockPath(pathName, null);
    }

    private String getEphemeralLockPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty((String)pathName)) {
            throw new IllegalArgumentException(" create MR/Hive dict lock path name is null");
        }
        return MRHiveDictUtil.getEphemeralLockPath(pathName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLock(DistributedLock lock) throws InterruptedException {
        long lockStartTime;
        String fullLockPath;
        block13: {
            logger.info("{} try to get global MR/Hive ZK lock", (Object)this.getId());
            String ephemeralLockPath = this.getEphemeralLockPathName();
            fullLockPath = this.getMRDictLockPathName();
            boolean isLocked = true;
            boolean getLocked = false;
            lockStartTime = System.currentTimeMillis();
            boolean isLockedByTheJob = lock.isLocked(fullLockPath);
            logger.info("{} global MR/Hive ZK lock is isLockedByTheJob:{}", (Object)this.getId(), (Object)isLockedByTheJob);
            if (!isLockedByTheJob) {
                while (isLocked) {
                    isLocked = lock.isLocked(this.getMRDictLockParentPathName());
                    if (!isLocked) {
                        isLocked = lock.isLocked(ephemeralLockPath);
                        this.stepLogger.log("zookeeper lock path :" + ephemeralLockPath + ", result is " + isLocked);
                        logger.info("zookeeper lock path :{}, is locked by other job result is {}", (Object)ephemeralLockPath, (Object)isLocked);
                        if (!isLocked) {
                            block14: {
                                try {
                                    logger.debug("{} before start to get lock ephemeralLockPath {}", (Object)this.getId(), (Object)ephemeralLockPath);
                                    this.threadLock.lock();
                                    logger.debug("{} start to get lock ephemeralLockPath {}", (Object)this.getId(), (Object)ephemeralLockPath);
                                    getLocked = lock.lock(ephemeralLockPath);
                                    logger.debug("{} finish get lock ephemeralLockPath {},getLocked {}", new Object[]{this.getId(), ephemeralLockPath, getLocked});
                                }
                                finally {
                                    this.threadLock.unlock();
                                    logger.debug("{} finish unlock the thread lock ,ephemeralLockPath {} ", (Object)this.getId(), (Object)ephemeralLockPath);
                                }
                                if (getLocked) {
                                    try {
                                        getLocked = lock.globalPermanentLock(fullLockPath);
                                        if (getLocked) break block13;
                                        if (lock.isLocked(ephemeralLockPath)) {
                                            lock.unlock(ephemeralLockPath);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!lock.isLocked(ephemeralLockPath)) break block14;
                                        lock.unlock(ephemeralLockPath);
                                    }
                                }
                            }
                            isLocked = true;
                        }
                    }
                    logger.info("{},global parent lock path({}) is locked by other job result is {} ,ephemeral lock path :{} is locked by other job result is {},will try after one minute", new Object[]{this.getId(), this.getMRDictLockParentPathName(), isLocked, ephemeralLockPath, isLocked});
                    Thread.sleep(60000L);
                }
            } else {
                lock.lock(ephemeralLockPath);
            }
        }
        this.stepLogger.log("zookeeper get lock costTime : " + (System.currentTimeMillis() - lockStartTime) / 1000L + " s");
        long useSec = (System.currentTimeMillis() - lockStartTime) / 1000L;
        logger.info("job {} get zookeeper lock path:{} success,zookeeper get lock costTime : {} s", new Object[]{this.getId(), fullLockPath, useSec});
    }

    private void unLock(DistributedLock lock) {
        String parentLockPath = this.getMRDictLockParentPathName();
        String ephemeralLockPath = this.getEphemeralLockPathName();
        if (lock.isLocked(this.getMRDictLockPathName())) {
            lock.purgeLocks(parentLockPath);
            this.stepLogger.log("zookeeper unlock path :" + parentLockPath);
            logger.info("{} unlock full lock path :{} success", (Object)this.getId(), (Object)parentLockPath);
        }
        if (lock.isLocked(ephemeralLockPath)) {
            lock.purgeLocks(ephemeralLockPath);
            this.stepLogger.log("zookeeper unlock path :" + ephemeralLockPath);
            logger.info("{} unlock full lock path :{} success", (Object)this.getId(), (Object)ephemeralLockPath);
        }
    }

    private static String serializeMap(Map<String, String> map) {
        JSONArray result = new JSONArray();
        if (map != null && map.size() > 0) {
            map.forEach((key, value) -> {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put(key, value);
                }
                catch (JSONException e) {
                    logger.error("Json Error", (Throwable)e);
                }
                result.put((Object)jsonObject);
            });
        }
        return result.toString();
    }

    private static Map<String, String> deserializeForMap(String mapStr) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (mapStr != null) {
            try {
                JSONArray jsonArray = new JSONArray(mapStr);
                int size = jsonArray.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    Iterator iterator = jsonObject.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        String value = jsonObject.getString(key);
                        result.put(key, value);
                    }
                }
            }
            catch (JSONException e) {
                logger.error("Json Error", (Throwable)e);
            }
        }
        return result;
    }
}

