/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.mapreduce.HCatInputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatSplit;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.mr.IInput;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.hive.HiveInputBase;
import org.apache.kylin.source.hive.HiveTableReader;

public class HiveMRInput
extends HiveInputBase
implements IMRInput {
    public IInput.IBatchCubingInputSide getBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
        return new HiveMRBatchCubingInputSide(flatDesc);
    }

    public IInput.IBatchMergeInputSide getBatchMergeInputSide(ISegment seg) {
        return new IMRInput.IMRBatchMergeInputSide(){

            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
            }
        };
    }

    public IMRInput.IMRTableInputFormat getTableInputFormat(TableDesc table, String uuid) {
        return new HiveTableInputFormat(HiveMRInput.getTableNameForHCat(table, uuid));
    }

    @Deprecated
    public static class GarbageCollectionStep
    extends org.apache.kylin.source.hive.GarbageCollectionStep {
    }

    @Deprecated
    public static class RedistributeFlatHiveTableStep
    extends org.apache.kylin.source.hive.RedistributeFlatHiveTableStep {
    }

    public static class HiveMRBatchCubingInputSide
    extends HiveInputBase.BaseBatchCubingInputSide
    implements IMRInput.IMRBatchCubingInputSide {
        public HiveMRBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
            super(flatDesc);
        }

        public IMRInput.IMRTableInputFormat getFlatTableInputFormat() {
            return new HiveTableInputFormat(this.getIntermediateTableIdentity());
        }
    }

    public static class HiveTableInputFormat
    implements IMRInput.IMRTableInputFormat {
        final String dbName;
        final String tableName;

        public HiveTableInputFormat(String fullQualifiedTableName) {
            String[] parts = HadoopUtil.parseHiveTableName((String)fullQualifiedTableName);
            this.dbName = parts[0];
            this.tableName = parts[1];
        }

        public void configureJob(Job job) {
            try {
                job.getConfiguration().addResource("hive-site.xml");
                HCatInputFormat.setInput((Job)job, (String)this.dbName, (String)this.tableName);
                job.setInputFormatClass(HCatInputFormat.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public List<String[]> parseMapperInput(Object mapperInput) {
            return Collections.singletonList(HiveTableReader.getRowAsStringArray((HCatRecord)mapperInput));
        }

        public String getInputSplitSignature(InputSplit inputSplit) {
            FileSplit baseSplit = (FileSplit)((HCatSplit)inputSplit).getBaseSplit();
            return baseSplit.getPath().getName() + "_" + baseSplit.getStart() + "_" + baseSplit.getLength();
        }
    }
}

