/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.flink.IFlinkInput;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.spark.ISparkInput;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourcePartition;
import org.apache.kylin.source.hive.HiveFlinkInput;
import org.apache.kylin.source.hive.HiveMRInput;
import org.apache.kylin.source.hive.HiveMetadataExplorer;
import org.apache.kylin.source.hive.HiveSparkInput;
import org.apache.kylin.source.hive.HiveTable;

public class HiveSource
implements ISource {
    public HiveSource(KylinConfig config) {
    }

    public ISourceMetadataExplorer getSourceMetadataExplorer() {
        return new HiveMetadataExplorer();
    }

    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == IMRInput.class) {
            return (I)new HiveMRInput();
        }
        if (engineInterface == ISparkInput.class) {
            return (I)new HiveSparkInput();
        }
        if (engineInterface == IFlinkInput.class) {
            return (I)new HiveFlinkInput();
        }
        throw new RuntimeException("Cannot adapt to " + engineInterface);
    }

    public IReadableTable createReadableTable(TableDesc tableDesc, String uuid) {
        if (tableDesc.isView()) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            String tableName = tableDesc.getMaterializedName(uuid);
            tableDesc = new TableDesc();
            tableDesc.setDatabase(config.getHiveDatabaseForIntermediateTable());
            tableDesc.setName(tableName);
        }
        return new HiveTable(tableDesc);
    }

    public SourcePartition enrichSourcePartitionBeforeBuild(IBuildable buildable, SourcePartition srcPartition) {
        SourcePartition result = SourcePartition.getCopyOf((SourcePartition)srcPartition);
        if (srcPartition.getTSRange() != null) {
            result.setSegRange(null);
        }
        return result;
    }

    public ISampleDataDeployer getSampleDataDeployer() {
        return new HiveMetadataExplorer();
    }

    public void unloadTable(String tableName, String project) throws IOException {
    }

    public void close() throws IOException {
    }
}

