/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.livy.LivyRestBuilder;
import org.apache.kylin.common.livy.LivyRestExecutor;
import org.apache.kylin.common.livy.LivyTypeEnum;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRHiveDictUtil {
    private static final Logger logger = LoggerFactory.getLogger(MRHiveDictUtil.class);
    protected static final Pattern HDFS_LOCATION = Pattern.compile("LOCATION '(.*)';");

    public static String distinctValueTable(IJoinedFlatTableDesc flatDesc) {
        return flatDesc.getTableName() + flatDesc.getSegment().getConfig().getMrHiveDistinctValueTableSuffix();
    }

    public static String segmentLevelDictTableName(IJoinedFlatTableDesc flatDesc) {
        return flatDesc.getTableName() + flatDesc.getSegment().getConfig().getMrHiveDictTableSuffix();
    }

    public static String globalDictTableName(IJoinedFlatTableDesc flatDesc, String cubeName) {
        return cubeName + flatDesc.getSegment().getConfig().getMrHiveDictTableSuffix();
    }

    public static String generateDictionaryDdl(IJoinedFlatTableDesc flatDesc, String db, String tbl) {
        KylinConfig config = flatDesc.getSegment().getConfig();
        String tableFormat = config.getMrHiveDictTableFormat();
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE IF NOT EXISTS " + db + "." + tbl + "\n");
        ddl.append(" ( dict_key STRING COMMENT '', \n");
        ddl.append("   dict_val INT COMMENT '' \n");
        ddl.append(") \n");
        ddl.append("COMMENT 'Hive Global Dictionary' \n");
        ddl.append("PARTITIONED BY (dict_column string) \n");
        if ("TEXTFILE".equalsIgnoreCase(tableFormat)) {
            ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\t' \n");
            ddl.append("STORED AS TEXTFILE; \n");
        } else {
            ddl.append("STORED AS " + tableFormat + "; \n");
        }
        return ddl.toString();
    }

    public static String generateDropTableStatement(String tableName) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("DROP TABLE IF EXISTS " + tableName + ";").append(" \n");
        return ddl.toString();
    }

    public static String generateDistinctValueTableStatement(IJoinedFlatTableDesc flatDesc) {
        KylinConfig config = flatDesc.getSegment().getConfig();
        String table = flatDesc.getTableName() + config.getMrHiveDistinctValueTableSuffix();
        String tableFormat = config.getMrHiveDictTableFormat();
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE IF NOT EXISTS " + table + " \n");
        ddl.append("( \n ");
        ddl.append("  dict_key STRING COMMENT '' \n");
        ddl.append(") \n");
        ddl.append("COMMENT '' \n");
        ddl.append("PARTITIONED BY (dict_column string) \n");
        ddl.append("STORED AS ").append(tableFormat).append(";\n");
        return ddl.toString();
    }

    public static String generateDictTableStatement(IJoinedFlatTableDesc flatDesc, String globalTableName) {
        KylinConfig config = flatDesc.getSegment().getConfig();
        String tableFormat = config.getMrHiveDictTableFormat();
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE IF NOT EXISTS " + globalTableName + " \n");
        ddl.append("( \n ");
        ddl.append("  dict_key STRING COMMENT '' , \n");
        ddl.append("  dict_val INT COMMENT '' \n");
        ddl.append(") \n");
        ddl.append("COMMENT '' \n");
        ddl.append("PARTITIONED BY (dict_column string) \n");
        if ("TEXTFILE".equalsIgnoreCase(tableFormat)) {
            ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\t' \n");
            ddl.append("STORED AS TEXTFILE \n");
        } else {
            ddl.append("STORED AS ").append(tableFormat).append("\n");
        }
        ddl.append(";").append("\n");
        return ddl.toString();
    }

    public static String generateInsertDataStatement(IJoinedFlatTableDesc flatDesc, String dictColumn, String globalDictDatabase, String globalDictTable) {
        TblColRef tblColRef;
        int index = 0;
        Iterator iterator = flatDesc.getAllColumns().iterator();
        while (iterator.hasNext() && !JoinedFlatTable.colName((TblColRef)(tblColRef = (TblColRef)iterator.next()), (boolean)flatDesc.useAlias()).equalsIgnoreCase(dictColumn)) {
            ++index;
        }
        if (index == flatDesc.getAllColumns().size()) {
            String msg = "Can not find correct column for " + dictColumn + ", please check 'kylin.dictionary.mr-hive.columns'";
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        String table = MRHiveDictUtil.distinctValueTable(flatDesc);
        StringBuilder sql = new StringBuilder();
        TblColRef col = (TblColRef)flatDesc.getAllColumns().get(index);
        sql.append("SELECT a.DICT_KEY FROM (\n");
        sql.append("  SELECT \n");
        sql.append(JoinedFlatTable.colName((TblColRef)col)).append(" as DICT_KEY \n");
        sql.append("  FROM ").append(flatDesc.getTableName()).append("\n");
        sql.append("  GROUP BY ");
        sql.append(JoinedFlatTable.colName((TblColRef)col)).append(") a \n");
        sql.append("    LEFT JOIN \n");
        sql.append("  (SELECT DICT_KEY FROM ").append(globalDictDatabase).append(".").append(globalDictTable);
        sql.append("    WHERE DICT_COLUMN = '").append(dictColumn);
        sql.append("' ) b \n");
        sql.append("ON a.DICT_KEY = b.DICT_KEY \n");
        sql.append("WHERE b.DICT_KEY IS NULL \n");
        return "INSERT OVERWRITE TABLE " + table + " \nPARTITION (dict_column = '" + dictColumn + "') \n" + sql.toString() + ";\n";
    }

    public static String generateDictStatisticsSql(String distinctValueTable, String globalDictTable, String globalDictDatabase) {
        return "INSERT OVERWRITE TABLE  " + distinctValueTable + " PARTITION (DICT_COLUMN = '" + "KYLIN_MAX_DISTINCT_COUNT" + "') \nSELECT CONCAT_WS(',', tc.dict_column, cast(tc.total_distinct_val AS String), if(tm.max_dict_val is null, '0', cast(max_dict_val as string))) \nFROM (\n    SELECT dict_column, count(1) total_distinct_val\n    FROM " + distinctValueTable + "\n    WHERE DICT_COLUMN != '" + "KYLIN_MAX_DISTINCT_COUNT" + "'\n    GROUP BY dict_column) tc \nLEFT JOIN (\n\n    SELECT dict_column, if(max(dict_val) is null, 0, max(dict_val)) as max_dict_val \n    FROM " + globalDictDatabase + "." + globalDictTable + "\n    GROUP BY dict_column) tm \nON tc.dict_column = tm.dict_column;";
    }

    public static void runLivySqlJob(PatternedLogger stepLogger, KylinConfig config, ImmutableList<String> sqls, ExecutableManager executableManager, String jobId) throws IOException {
        LivyRestBuilder livyRestBuilder = new LivyRestBuilder();
        livyRestBuilder.overwriteHiveProps(config.getHiveConfigOverride());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(livyRestBuilder.parseProps());
        for (String sql : sqls) {
            stringBuilder.append(sql);
        }
        String args = stringBuilder.toString();
        livyRestBuilder.addArgs(args);
        stepLogger.log("Create and distribute table. ");
        livyRestBuilder.setLivyTypeEnum(LivyTypeEnum.sql);
        LivyRestExecutor executor = new LivyRestExecutor();
        executor.execute(livyRestBuilder, (org.apache.kylin.common.util.Logger)stepLogger);
        Map info = stepLogger.getInfo();
        Matcher matcher = HDFS_LOCATION.matcher(args);
        if (matcher.find()) {
            String hiveFlatTableHdfsUrl = matcher.group(1);
            long size = MRHiveDictUtil.getFileSize(hiveFlatTableHdfsUrl);
            info.put("hdfs_bytes_written", "" + size);
            logger.info("HDFS_Bytes_Writen: {}", (Object)size);
        }
        executableManager.addJobInfo(jobId, info);
    }

    public static String getLockPath(String cubeName, String jobId) {
        if (jobId == null) {
            return DictHiveType.MrDictLockPath.getName() + cubeName;
        }
        return DictHiveType.MrDictLockPath.getName() + cubeName + "/" + jobId;
    }

    public static String getEphemeralLockPath(String cubeName) {
        return DictHiveType.MrEphemeralDictLockPath.getName() + cubeName;
    }

    private static long getFileSize(String hdfsUrl) throws IOException {
        Configuration configuration = new Configuration();
        Path path = new Path(hdfsUrl);
        FileSystem fs = path.getFileSystem(configuration);
        ContentSummary contentSummary = fs.getContentSummary(path);
        return contentSummary.getLength();
    }

    public static enum DictHiveType {
        MrDictLockPath("/mr_dict_lock/"),
        MrEphemeralDictLockPath("/mr_dict_ephemeral_lock/");

        private String name;

        private DictHiveType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

