/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive.cardinality;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.measure.hllc.HLLCounter;

public class ColumnCardinalityReducer
extends KylinReducer<IntWritable, BytesWritable, IntWritable, LongWritable> {
    public static final int ONE = 1;
    private Map<Integer, HLLCounter> hllcMap = new HashMap<Integer, HLLCounter>();

    protected void doSetup(Reducer.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
    }

    public void doReduce(IntWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        int skey = key.get();
        for (BytesWritable v : values) {
            ByteBuffer buffer = ByteBuffer.wrap(v.getBytes());
            HLLCounter hll = new HLLCounter();
            hll.readRegisters(buffer);
            this.getHllc(skey).merge(hll);
            hll.clear();
        }
    }

    private HLLCounter getHllc(Integer key) {
        if (!this.hllcMap.containsKey(key)) {
            this.hllcMap.put(key, new HLLCounter());
        }
        return this.hllcMap.get(key);
    }

    protected void doCleanup(Reducer.Context context) throws IOException, InterruptedException {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        Iterator<Integer> it = this.hllcMap.keySet().iterator();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Collections.sort(keys);
        for (int key : keys) {
            HLLCounter hllc = this.hllcMap.get(key);
            ByteBuffer buf = ByteBuffer.allocate(0x100000);
            buf.clear();
            hllc.writeRegisters(buf);
            buf.flip();
            context.write((Object)new IntWritable(key), (Object)new LongWritable(hllc.getCountEstimate()));
        }
    }
}

