/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.IInput;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.util.FlatTableSqlQuoteUtils;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.source.hive.CreateFlatHiveTableByLivyStep;
import org.apache.kylin.source.hive.CreateFlatHiveTableStep;
import org.apache.kylin.source.hive.CreateMrHiveDictStep;
import org.apache.kylin.source.hive.GarbageCollectionStep;
import org.apache.kylin.source.hive.MRHiveDictUtil;
import org.apache.kylin.source.hive.RedistributeFlatHiveTableByLivyStep;
import org.apache.kylin.source.hive.RedistributeFlatHiveTableStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveInputBase {
    private static final Logger logger = LoggerFactory.getLogger(HiveInputBase.class);

    protected static String getTableNameForHCat(TableDesc table, String uuid) {
        String tableName = table.isView() ? table.getMaterializedName(uuid) : table.getName();
        String database = table.isView() ? KylinConfig.getInstanceFromEnv().getHiveDatabaseForIntermediateTable() : table.getDatabase();
        return String.format(Locale.ROOT, "%s.%s", database, tableName).toUpperCase(Locale.ROOT);
    }

    protected static AbstractExecutable createFlatHiveTableStep(String hiveInitStatements, String jobWorkingDir, String cubeName, IJoinedFlatTableDesc flatDesc) {
        String dropTableHql = JoinedFlatTable.generateDropTableStatement((IJoinedFlatTableDesc)flatDesc);
        String createTableHql = JoinedFlatTable.generateCreateTableStatement((IJoinedFlatTableDesc)flatDesc, (String)jobWorkingDir);
        String insertDataHqls = JoinedFlatTable.generateInsertDataStatement((IJoinedFlatTableDesc)flatDesc);
        CreateFlatHiveTableStep step = new CreateFlatHiveTableStep();
        step.setInitStatement(hiveInitStatements);
        step.setCreateTableStatement(dropTableHql + createTableHql + insertDataHqls);
        CubingExecutableUtil.setCubeName((String)cubeName, (Map)step.getParams());
        step.setName("Create Intermediate Flat Hive Table");
        return step;
    }

    protected static AbstractExecutable createFlatHiveTableByLivyStep(String hiveInitStatements, String jobWorkingDir, String cubeName, IJoinedFlatTableDesc flatDesc) {
        String dropTableHql = JoinedFlatTable.generateDropTableStatement((IJoinedFlatTableDesc)flatDesc);
        String createTableHql = JoinedFlatTable.generateCreateTableStatement((IJoinedFlatTableDesc)flatDesc, (String)jobWorkingDir);
        String insertDataHqls = JoinedFlatTable.generateInsertDataStatement((IJoinedFlatTableDesc)flatDesc);
        CreateFlatHiveTableByLivyStep step = new CreateFlatHiveTableByLivyStep();
        step.setInitStatement(hiveInitStatements);
        step.setCreateTableStatement(dropTableHql + createTableHql + insertDataHqls);
        CubingExecutableUtil.setCubeName((String)cubeName, (Map)step.getParams());
        step.setName("Create Intermediate Flat Hive Table");
        return step;
    }

    private static String base64EncodeStr(String str) {
        return new String(Base64.getEncoder().encode(str.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    protected static AbstractExecutable createRedistributeFlatHiveTableStep(String hiveInitStatements, String cubeName, IJoinedFlatTableDesc flatDesc, CubeDesc cubeDesc) {
        RedistributeFlatHiveTableStep step = new RedistributeFlatHiveTableStep();
        step.setInitStatement(hiveInitStatements);
        step.setIntermediateTable(flatDesc.getTableName());
        step.setRedistributeDataStatement(JoinedFlatTable.generateRedistributeFlatTableStatement((IJoinedFlatTableDesc)flatDesc, (CubeDesc)cubeDesc));
        CubingExecutableUtil.setCubeName((String)cubeName, (Map)step.getParams());
        step.setName("Redistribute Flat Hive Table");
        return step;
    }

    protected static AbstractExecutable createRedistributeFlatHiveTableByLivyStep(String hiveInitStatements, String cubeName, IJoinedFlatTableDesc flatDesc, CubeDesc cubeDesc) {
        RedistributeFlatHiveTableByLivyStep step = new RedistributeFlatHiveTableByLivyStep();
        step.setInitStatement(hiveInitStatements);
        step.setIntermediateTable(flatDesc.getTableName());
        step.setRedistributeDataStatement(JoinedFlatTable.generateRedistributeFlatTableStatement((IJoinedFlatTableDesc)flatDesc, (CubeDesc)cubeDesc));
        CubingExecutableUtil.setCubeName((String)cubeName, (Map)step.getParams());
        step.setName("Redistribute Flat Hive Table");
        return step;
    }

    protected static ShellExecutable createLookupHiveViewMaterializationStep(String hiveInitStatements, String jobWorkingDir, IJoinedFlatTableDesc flatDesc, List<String> intermediateTables, String uuid) {
        ShellExecutable step = new ShellExecutable();
        step.setName("Materialize Hive View in Lookup Tables");
        KylinConfig kylinConfig = flatDesc.getSegment().getConfig();
        TableMetadataManager metadataManager = TableMetadataManager.getInstance((KylinConfig)kylinConfig);
        HashSet lookupViewsTables = Sets.newHashSet();
        String prj = flatDesc.getDataModel().getProject();
        for (JoinTableDesc lookupDesc : flatDesc.getDataModel().getJoinTables()) {
            TableDesc tableDesc = metadataManager.getTableDesc(lookupDesc.getTable(), prj);
            if (lookupDesc.getKind() != DataModelDesc.TableKind.LOOKUP || !tableDesc.isView()) continue;
            lookupViewsTables.add(tableDesc);
        }
        if (lookupViewsTables.size() == 0) {
            return null;
        }
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.overwriteHiveProps(kylinConfig.getHiveConfigOverride());
        hiveCmdBuilder.addStatement(hiveInitStatements);
        for (TableDesc lookUpTableDesc : lookupViewsTables) {
            String identity = FlatTableSqlQuoteUtils.quoteTableIdentity((String)lookUpTableDesc.getDatabase(), (String)lookUpTableDesc.getName(), null);
            if (!lookUpTableDesc.isView()) continue;
            String intermediate = lookUpTableDesc.getMaterializedName(uuid);
            String materializeViewHql = HiveInputBase.materializeViewHql(intermediate, identity, jobWorkingDir);
            hiveCmdBuilder.addStatement(materializeViewHql);
            intermediateTables.add(intermediate);
        }
        step.setCmd(hiveCmdBuilder.build());
        return step;
    }

    protected static String materializeViewHql(String viewName, String tableName, String jobWorkingDir) {
        StringBuilder createIntermediateTableHql = new StringBuilder();
        createIntermediateTableHql.append("DROP TABLE IF EXISTS `" + viewName + "`;\n");
        createIntermediateTableHql.append("CREATE TABLE IF NOT EXISTS `" + viewName + "` LIKE " + tableName + " LOCATION '" + jobWorkingDir + "/" + viewName + "';\n");
        createIntermediateTableHql.append("ALTER TABLE `" + viewName + "` SET TBLPROPERTIES('auto.purge'='true');\n");
        createIntermediateTableHql.append("INSERT OVERWRITE TABLE `" + viewName + "` SELECT * FROM " + tableName + ";\n");
        return createIntermediateTableHql.toString();
    }

    protected static String getJobWorkingDir(DefaultChainedExecutable jobFlow, String hdfsWorkingDir) {
        String jobWorkingDir = JobBuilderSupport.getJobWorkingDir((String)hdfsWorkingDir, (String)jobFlow.getId());
        if (KylinConfig.getInstanceFromEnv().getHiveTableDirCreateFirst()) {
            HiveInputBase.checkAndCreateWorkDir(jobWorkingDir);
        }
        return jobWorkingDir;
    }

    protected static void checkAndCreateWorkDir(String jobWorkingDir) {
        try {
            Path path = new Path(jobWorkingDir);
            FileSystem fileSystem = HadoopUtil.getFileSystem((Path)path);
            if (!fileSystem.exists(path)) {
                logger.info("Create jobWorkDir : " + jobWorkingDir);
                fileSystem.mkdirs(path);
            }
        }
        catch (IOException e) {
            logger.error("Could not create lookUp table dir : " + jobWorkingDir);
        }
    }

    public static class BaseBatchCubingInputSide
    implements IInput.IBatchCubingInputSide {
        protected final IJoinedFlatTableDesc flatDesc;
        protected final String flatTableDatabase;
        protected final String hdfsWorkingDir;
        List<String> hiveViewIntermediateTables = Lists.newArrayList();

        public BaseBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            this.flatDesc = flatDesc;
            this.flatTableDatabase = config.getHiveDatabaseForIntermediateTable();
            this.hdfsWorkingDir = config.getHdfsWorkingDirectory();
        }

        public void addStepPhase1_CreateFlatTable(DefaultChainedExecutable jobFlow) {
            String cubeName = CubingExecutableUtil.getCubeName((Map)jobFlow.getParams());
            CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getCube(cubeName);
            KylinConfig cubeConfig = cubeInstance.getConfig();
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements((String)this.flatTableDatabase);
            this.addStepPhase1_DoCreateFlatTable(jobFlow);
            KylinConfig dictConfig = this.flatDesc.getSegment().getConfig();
            String[] mrHiveDictColumns = dictConfig.getMrHiveDictColumns();
            if (mrHiveDictColumns.length > 0) {
                String globalDictDatabase = dictConfig.getMrHiveDictDB();
                if (null == globalDictDatabase) {
                    throw new IllegalArgumentException("Mr-Hive Global dict database is null.");
                }
                String globalDictTable = cubeName + dictConfig.getMrHiveDictTableSuffix();
                this.addStepPhase1_DoCreateMrHiveGlobalDict(jobFlow, mrHiveDictColumns, globalDictDatabase, globalDictTable);
            }
            if (cubeConfig.isHiveRedistributeEnabled()) {
                KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
                if (kylinConfig.isLivyEnabled() && cubeInstance.getEngineType() == 4) {
                    jobFlow.addTask(HiveInputBase.createRedistributeFlatHiveTableByLivyStep(hiveInitStatements, cubeName, this.flatDesc, cubeInstance.getDescriptor()));
                } else {
                    jobFlow.addTask(HiveInputBase.createRedistributeFlatHiveTableStep(hiveInitStatements, cubeName, this.flatDesc, cubeInstance.getDescriptor()));
                }
            }
            this.addStepPhase1_DoMaterializeLookupTable(jobFlow);
        }

        protected void addStepPhase1_DoCreateMrHiveGlobalDict(DefaultChainedExecutable jobFlow, String[] mrHiveDictColumns, String globalDictDatabase, String globalDictTable) {
            String cubeName = CubingExecutableUtil.getCubeName((Map)jobFlow.getParams());
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements((String)this.flatTableDatabase);
            String jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir);
            jobFlow.addTask(BaseBatchCubingInputSide.createMrHiveGlobalDictExtractStep(this.flatDesc, hiveInitStatements, jobWorkingDir, cubeName, mrHiveDictColumns, globalDictDatabase, globalDictTable));
            jobFlow.addTask(BaseBatchCubingInputSide.createMrHIveGlobalDictBuildStep(this.flatDesc, hiveInitStatements, this.hdfsWorkingDir, cubeName, mrHiveDictColumns, this.flatTableDatabase, globalDictDatabase, globalDictTable));
            jobFlow.addTask(BaseBatchCubingInputSide.createMrHiveGlobalDictReplaceStep(this.flatDesc, hiveInitStatements, this.hdfsWorkingDir, cubeName, mrHiveDictColumns, this.flatTableDatabase, globalDictDatabase, globalDictTable));
        }

        protected static AbstractExecutable createMrHiveGlobalDictExtractStep(IJoinedFlatTableDesc flatDesc, String hiveInitStatements, String jobWorkingDir, String cubeName, String[] mrHiveDictColumns, String globalDictDatabase, String globalDictTable) {
            String createGlobalDictTableHql = "CREATE TABLE IF NOT EXISTS " + globalDictDatabase + "." + globalDictTable + "\n( dict_key STRING COMMENT '', \ndict_val INT COMMENT '' \n) \nCOMMENT '' \nPARTITIONED BY (dict_column string) \nSTORED AS TEXTFILE; \n";
            String dropDictIntermediateTableHql = MRHiveDictUtil.generateDropTableStatement(flatDesc);
            String createDictIntermediateTableHql = MRHiveDictUtil.generateCreateTableStatement(flatDesc);
            StringBuilder insertDataToDictIntermediateTableSql = new StringBuilder();
            for (String dictColumn : mrHiveDictColumns) {
                insertDataToDictIntermediateTableSql.append(MRHiveDictUtil.generateInsertDataStatement(flatDesc, dictColumn));
            }
            CreateMrHiveDictStep step = new CreateMrHiveDictStep();
            step.setInitStatement(hiveInitStatements);
            step.setCreateTableStatement(createGlobalDictTableHql + dropDictIntermediateTableHql + createDictIntermediateTableHql + insertDataToDictIntermediateTableSql.toString());
            CubingExecutableUtil.setCubeName((String)cubeName, (Map)step.getParams());
            step.setName("Build Global Dict - extract distinct value from data");
            return step;
        }

        protected static AbstractExecutable createMrHIveGlobalDictBuildStep(IJoinedFlatTableDesc flatDesc, String hiveInitStatements, String hdfsWorkingDir, String cubeName, String[] mrHiveDictColumns, String flatTableDatabase, String globalDictDatabase, String globalDictTable) {
            String flatTable = flatTableDatabase + "." + MRHiveDictUtil.getHiveTableName(flatDesc, MRHiveDictUtil.DictHiveType.GroupBy);
            HashMap<String, String> maxDictValMap = new HashMap<String, String>();
            HashMap<String, String> dictHqlMap = new HashMap<String, String>();
            for (String dictColumn : mrHiveDictColumns) {
                String maxDictValHql = "SELECT if(max(dict_val) is null,0,max(dict_val)) as max_dict_val \n FROM " + globalDictDatabase + "." + globalDictTable + " \n WHERE dict_column = '" + dictColumn + "' \n";
                maxDictValMap.put(dictColumn, maxDictValHql);
                try {
                    String dictHql = "INSERT OVERWRITE TABLE " + globalDictDatabase + "." + globalDictTable + " \nPARTITION (dict_column = '" + dictColumn + "') \nSELECT dict_key, dict_val FROM " + globalDictDatabase + "." + globalDictTable + " \nWHERE dict_column = '" + dictColumn + "' \n" + flatDesc.getDataModel().getConfig().getHiveUnionStyle() + "\nSELECT a.dict_key as dict_key, (row_number() over(order by a.dict_key asc)) + (___maxDictVal___) as dict_val \nFROM \n( \n SELECT dict_key FROM " + flatTable + " WHERE dict_column = '" + dictColumn + "' AND dict_key is not null \n) a \nLEFT JOIN \n( \nSELECT dict_key, dict_val FROM " + globalDictDatabase + "." + globalDictTable + " WHERE dict_column = '" + dictColumn + "' \n) b \nON a.dict_key = b.dict_key \nWHERE b.dict_val is null; \n";
                    dictHqlMap.put(dictColumn, dictHql);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            String hiveInitStatementForUnstrict = "set hive.mapred.mode=unstrict;";
            CreateMrHiveDictStep step = new CreateMrHiveDictStep();
            step.setInitStatement(hiveInitStatements + hiveInitStatementForUnstrict);
            step.setCreateTableStatementMap(dictHqlMap);
            step.setMaxDictStatementMap(maxDictValMap);
            step.setIsLock(true);
            step.setLockPathName(cubeName);
            CubingExecutableUtil.setCubeName((String)cubeName, (Map)step.getParams());
            step.setName("Build Global Dict - merge to dict table");
            return step;
        }

        protected static AbstractExecutable createMrHiveGlobalDictReplaceStep(IJoinedFlatTableDesc flatDesc, String hiveInitStatements, String hdfsWorkingDir, String cubeName, String[] mrHiveDictColumns, String flatTableDatabase, String globalDictDatabase, String globalDictTable) {
            HashMap<String, String> dictHqlMap = new HashMap<String, String>();
            for (String dictColumn : mrHiveDictColumns) {
                StringBuilder dictHql = new StringBuilder();
                TblColRef dictColumnRef = null;
                String flatTable = flatTableDatabase + "." + flatDesc.getTableName();
                dictHql.append("INSERT OVERWRITE TABLE " + flatTable + " \n");
                try {
                    dictHql.append("SELECT \n");
                    Integer flatTableColumnSize = flatDesc.getAllColumns().size();
                    for (int i = 0; i < flatTableColumnSize; ++i) {
                        TblColRef tblColRef = (TblColRef)flatDesc.getAllColumns().get(i);
                        if (i > 0) {
                            dictHql.append(",");
                        }
                        if (JoinedFlatTable.colName((TblColRef)tblColRef, (boolean)flatDesc.useAlias()).equalsIgnoreCase(dictColumn)) {
                            dictHql.append("b. dict_val \n");
                            dictColumnRef = tblColRef;
                            continue;
                        }
                        dictHql.append("a." + JoinedFlatTable.colName((TblColRef)tblColRef) + " \n");
                    }
                    dictHql.append("FROM " + flatTable + " a \nLEFT OUTER JOIN \n( \nSELECT dict_key, dict_val FROM " + globalDictDatabase + "." + globalDictTable + " WHERE dict_column = '" + dictColumn + "' \n) b \n ON a." + JoinedFlatTable.colName((TblColRef)dictColumnRef) + " = b.dict_key;");
                    dictHqlMap.put(dictColumn, dictHql.toString());
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            CreateMrHiveDictStep step = new CreateMrHiveDictStep();
            step.setInitStatement(hiveInitStatements);
            step.setCreateTableStatementMap(dictHqlMap);
            step.setIsUnLock(true);
            step.setLockPathName(cubeName);
            CubingExecutableUtil.setCubeName((String)cubeName, (Map)step.getParams());
            step.setName("Build Global Dict - replace intermediate table");
            return step;
        }

        protected void addStepPhase1_DoCreateFlatTable(DefaultChainedExecutable jobFlow) {
            String cubeName = CubingExecutableUtil.getCubeName((Map)jobFlow.getParams());
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements((String)this.flatTableDatabase);
            String jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir);
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)kylinConfig).getCube(cubeName);
            if (cubeInstance.getEngineType() == 4) {
                if (kylinConfig.isLivyEnabled()) {
                    jobFlow.addTask(HiveInputBase.createFlatHiveTableByLivyStep(hiveInitStatements, jobWorkingDir, cubeName, this.flatDesc));
                }
            } else {
                jobFlow.addTask(HiveInputBase.createFlatHiveTableStep(hiveInitStatements, jobWorkingDir, cubeName, this.flatDesc));
            }
        }

        protected void addStepPhase1_DoMaterializeLookupTable(DefaultChainedExecutable jobFlow) {
            String jobWorkingDir;
            String hiveInitStatements = JoinedFlatTable.generateHiveInitStatements((String)this.flatTableDatabase);
            ShellExecutable task = HiveInputBase.createLookupHiveViewMaterializationStep(hiveInitStatements, jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir), this.flatDesc, this.hiveViewIntermediateTables, jobFlow.getId());
            if (task != null) {
                jobFlow.addTask((AbstractExecutable)task);
            }
        }

        public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
            String jobWorkingDir = HiveInputBase.getJobWorkingDir(jobFlow, this.hdfsWorkingDir);
            GarbageCollectionStep step = new GarbageCollectionStep();
            step.setName("Hive Cleanup");
            ArrayList<String> deleteTables = new ArrayList<String>();
            deleteTables.add(this.getIntermediateTableIdentity());
            String[] mrHiveDicts = this.flatDesc.getSegment().getConfig().getMrHiveDictColumns();
            if (Objects.nonNull(mrHiveDicts) && mrHiveDicts.length > 0) {
                String dictDb = this.flatDesc.getSegment().getConfig().getMrHiveDictDB();
                String tableName = dictDb + "." + this.flatDesc.getTableName() + "_" + MRHiveDictUtil.DictHiveType.GroupBy.getName();
                deleteTables.add(tableName);
            }
            step.setIntermediateTables(deleteTables);
            step.setExternalDataPaths(Collections.singletonList(JoinedFlatTable.getTableDir((IJoinedFlatTableDesc)this.flatDesc, (String)jobWorkingDir)));
            step.setHiveViewIntermediateTableIdentities(StringUtil.join(this.hiveViewIntermediateTables, (String)","));
            jobFlow.addTask((AbstractExecutable)step);
        }

        protected String getIntermediateTableIdentity() {
            return this.flatTableDatabase + "." + this.flatDesc.getTableName();
        }
    }
}

