/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.livy.LivyRestBuilder;
import org.apache.kylin.common.livy.LivyRestExecutor;
import org.apache.kylin.common.livy.LivyTypeEnum;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRHiveDictUtil {
    private static final Logger logger = LoggerFactory.getLogger(MRHiveDictUtil.class);
    protected static final Pattern HDFS_LOCATION = Pattern.compile("LOCATION '(.*)';");

    public static String generateDropTableStatement(IJoinedFlatTableDesc flatDesc) {
        StringBuilder ddl = new StringBuilder();
        String table = MRHiveDictUtil.getHiveTableName(flatDesc, DictHiveType.GroupBy);
        ddl.append("DROP TABLE IF EXISTS " + table + ";").append(" \n");
        return ddl.toString();
    }

    public static String generateCreateTableStatement(IJoinedFlatTableDesc flatDesc) {
        StringBuilder ddl = new StringBuilder();
        String table = MRHiveDictUtil.getHiveTableName(flatDesc, DictHiveType.GroupBy);
        ddl.append("CREATE TABLE IF NOT EXISTS " + table + " \n");
        ddl.append("( \n ");
        ddl.append("dict_key STRING COMMENT '' \n");
        ddl.append(") \n");
        ddl.append("COMMENT '' \n");
        ddl.append("PARTITIONED BY (dict_column string) \n");
        ddl.append("STORED AS SEQUENCEFILE \n");
        ddl.append(";").append("\n");
        return ddl.toString();
    }

    public static String generateInsertDataStatement(IJoinedFlatTableDesc flatDesc, String dictColumn) {
        TblColRef tblColRef;
        String table = MRHiveDictUtil.getHiveTableName(flatDesc, DictHiveType.GroupBy);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT\n");
        int index = 0;
        Iterator iterator = flatDesc.getAllColumns().iterator();
        while (iterator.hasNext() && !JoinedFlatTable.colName((TblColRef)(tblColRef = (TblColRef)iterator.next()), (boolean)flatDesc.useAlias()).equalsIgnoreCase(dictColumn)) {
            ++index;
        }
        if (index == flatDesc.getAllColumns().size()) {
            String msg = "Can not find correct column for " + dictColumn + ", please check 'kylin.dictionary.mr-hive.columns'";
            logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        TblColRef col = (TblColRef)flatDesc.getAllColumns().get(index);
        sql.append(JoinedFlatTable.colName((TblColRef)col) + " \n");
        MRHiveDictUtil.appendJoinStatement(flatDesc, sql);
        sql.append("GROUP BY ");
        sql.append(JoinedFlatTable.colName((TblColRef)col) + " \n");
        return "INSERT OVERWRITE TABLE " + table + " \nPARTITION (dict_column = '" + dictColumn + "') \n" + sql + ";\n";
    }

    public static String getHiveTableName(IJoinedFlatTableDesc flatDesc, DictHiveType dictHiveType) {
        StringBuffer table = new StringBuffer(flatDesc.getTableName());
        table.append("__");
        table.append(dictHiveType.getName());
        return table.toString();
    }

    public static void appendJoinStatement(IJoinedFlatTableDesc flatDesc, StringBuilder sql) {
        sql.append("FROM " + flatDesc.getTableName() + "\n");
    }

    public static void runLivySqlJob(PatternedLogger stepLogger, KylinConfig config, ImmutableList<String> sqls, ExecutableManager executableManager, String jobId) throws IOException {
        LivyRestBuilder livyRestBuilder = new LivyRestBuilder();
        livyRestBuilder.overwriteHiveProps(config.getHiveConfigOverride());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(livyRestBuilder.parseProps());
        for (String sql : sqls) {
            stringBuilder.append(sql);
        }
        String args = stringBuilder.toString();
        livyRestBuilder.addArgs(args);
        stepLogger.log("Create and distribute table. ");
        livyRestBuilder.setLivyTypeEnum(LivyTypeEnum.sql);
        LivyRestExecutor executor = new LivyRestExecutor();
        executor.execute(livyRestBuilder, (org.apache.kylin.common.util.Logger)stepLogger);
        Map info = stepLogger.getInfo();
        Matcher matcher = HDFS_LOCATION.matcher(args);
        if (matcher.find()) {
            String hiveFlatTableHdfsUrl = matcher.group(1);
            long size = MRHiveDictUtil.getFileSize(hiveFlatTableHdfsUrl);
            info.put("hdfs_bytes_written", "" + size);
            logger.info("HDFS_Bytes_Writen: {}", (Object)size);
        }
        executableManager.addJobInfo(jobId, info);
    }

    private static long getFileSize(String hdfsUrl) throws IOException {
        Configuration configuration = new Configuration();
        Path path = new Path(hdfsUrl);
        FileSystem fs = path.getFileSystem(configuration);
        ContentSummary contentSummary = fs.getContentSummary(path);
        return contentSummary.getLength();
    }

    public static enum DictHiveType {
        GroupBy("group_by"),
        MrDictLockPath("/mr_dict_lock/");

        private String name;

        private DictHiveType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

