/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.HiveTableMetaBuilder;
import org.apache.kylin.source.hive.IHiveClient;
import org.apache.spark.sql.SparderContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;

public class SparkHiveClient
implements IHiveClient {
    private static final String CHAR_VARCHAR_TYPE_STRING = "__CHAR_VARCHAR_TYPE_STRING";
    private static final String HIVE_COMMENT = "comment";
    private static final String HIVE_TABLE_ROWS = "numRows";
    private static final String TABLE_TOTAL_SIZE = "totalSize";
    private static final String TABLE_FILE_NUM = "numFiles";
    protected SparkSession ss = SparderContext.getOriginalSparkSession();
    protected SessionCatalog catalog = this.ss.sessionState().catalog();

    @Override
    public void executeHQL(String hql) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeHQL(String[] hqls) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public HiveTableMeta getHiveTableMeta(String database, String tableName) throws Exception {
        HiveTableMetaBuilder builder = new HiveTableMetaBuilder();
        CatalogTable catalogTable = this.catalog.getTempViewOrPermanentTableMetadata(new TableIdentifier(tableName, Option.apply((Object)database)));
        List structFieldList = catalogTable.schema().toList();
        Iterator structFieldIterator = structFieldList.iterator();
        ArrayList allColumns = Lists.newArrayList();
        ArrayList partitionColumns = Lists.newArrayList();
        while (structFieldIterator.hasNext()) {
            StructField structField = (StructField)structFieldIterator.next();
            String name = structField.name();
            String hiveDataType = structField.dataType().simpleString();
            Metadata metadata = structField.metadata();
            String description = metadata.contains(HIVE_COMMENT) ? metadata.getString(HIVE_COMMENT) : "";
            String datatype = metadata.contains(CHAR_VARCHAR_TYPE_STRING) ? metadata.getString(CHAR_VARCHAR_TYPE_STRING) : hiveDataType;
            allColumns.add(new HiveTableMeta.HiveTableColumnMeta(name, datatype, description));
            if (!catalogTable.partitionColumnNames().contains((Object)name)) continue;
            partitionColumns.add(new HiveTableMeta.HiveTableColumnMeta(name, datatype, description));
        }
        Map properties = catalogTable.ignoredProperties();
        builder.setAllColumns(allColumns);
        builder.setPartitionColumns(partitionColumns);
        if (catalogTable.tableType().equals((Object)CatalogTableType.MANAGED())) {
            builder.setSdLocation(catalogTable.location().getPath());
        } else {
            builder.setSdLocation("unknown");
        }
        long totalSize = properties.contains((Object)TABLE_TOTAL_SIZE) ? Long.parseLong((String)properties.apply((Object)TABLE_TOTAL_SIZE)) : 0L;
        builder.setFileSize(totalSize);
        long totalFileNum = properties.contains((Object)TABLE_FILE_NUM) ? Long.parseLong((String)properties.apply((Object)TABLE_FILE_NUM)) : 0L;
        builder.setFileNum(totalFileNum);
        builder.setIsNative(catalogTable.tableType().equals((Object)CatalogTableType.MANAGED()));
        builder.setTableName(tableName);
        builder.setSdInputFormat(catalogTable.storage().inputFormat().toString());
        builder.setSdOutputFormat(catalogTable.storage().outputFormat().toString());
        builder.setOwner(catalogTable.owner());
        builder.setLastAccessTime(catalogTable.lastAccessTime());
        builder.setTableType(catalogTable.tableType().name());
        return builder.createHiveTableMeta();
    }

    @Override
    public java.util.List<String> getHiveDbNames() throws Exception {
        return JavaConversions.seqAsJavaList((Seq)this.catalog.listDatabases());
    }

    @Override
    public java.util.List<String> getHiveTableNames(String database) throws Exception {
        java.util.List tableIdentifiers = JavaConversions.seqAsJavaList((Seq)this.catalog.listTables(database));
        java.util.List<String> tableNames = tableIdentifiers.stream().map(table -> table.table()).collect(Collectors.toList());
        return tableNames;
    }

    @Override
    public long getHiveTableRows(String database, String tableName) throws Exception {
        Map properties = this.catalog.getTempViewOrPermanentTableMetadata(new TableIdentifier(tableName, Option.apply((Object)database))).ignoredProperties();
        long hiveTableRows = properties.contains((Object)HIVE_TABLE_ROWS) ? Long.parseLong((String)properties.apply((Object)HIVE_TABLE_ROWS)) : 0L;
        return hiveTableRows;
    }

    @Override
    public java.util.List<Object[]> getHiveResult(String sql) throws Exception {
        return null;
    }
}

