/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive.cardinality;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.hive.cardinality.ColumnCardinalityMapper;
import org.apache.kylin.source.hive.cardinality.ColumnCardinalityReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveColumnCardinalityJob
extends AbstractHadoopJob {
    private static final Logger logger = LoggerFactory.getLogger(HiveColumnCardinalityJob.class);
    public static final String JOB_TITLE = "Kylin Hive Column Cardinality Job";
    protected static final Option OPTION_TABLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        try {
            Options options = new Options();
            options.addOption(OPTION_PROJECT);
            options.addOption(OPTION_TABLE);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            String jobName = JOB_TITLE + this.getOptionsAsString();
            logger.info("Starting: {}", (Object)jobName);
            Configuration conf = this.getConf();
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            JobEngineConfig jobEngineConfig = new JobEngineConfig(kylinConfig);
            conf.addResource(new Path(jobEngineConfig.getHadoopJobConfFilePath(null)));
            this.job = Job.getInstance((Configuration)conf, (String)jobName);
            this.setJobClasspath(this.job, kylinConfig);
            String project = this.getOptionValue(OPTION_PROJECT);
            String table = this.getOptionValue(OPTION_TABLE);
            this.job.getConfiguration().set("project.name", project);
            this.job.getConfiguration().set("table.name", table);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.getConfiguration().set("dfs.blocksize", "67108864");
            this.job.getConfiguration().set("mapreduce.output.fileoutputformat.compress", "false");
            IMRInput.IMRTableInputFormat tableInputFormat = MRUtil.getTableInputFormat((String)table, (String)project, (String)this.getOptionValue(OPTION_CUBING_JOB_ID));
            tableInputFormat.configureJob(this.job);
            this.job.setMapperClass(ColumnCardinalityMapper.class);
            this.job.setMapOutputKeyClass(IntWritable.class);
            this.job.setMapOutputValueClass(BytesWritable.class);
            this.job.setReducerClass(ColumnCardinalityReducer.class);
            this.job.setOutputFormatClass(TextOutputFormat.class);
            this.job.setOutputKeyClass(IntWritable.class);
            this.job.setOutputValueClass(LongWritable.class);
            this.job.setNumReduceTasks(1);
            this.deletePath(this.job.getConfiguration(), output);
            logger.info("Going to submit HiveColumnCardinalityJob for table '{}'", (Object)table);
            TableDesc tableDesc = TableMetadataManager.getInstance((KylinConfig)kylinConfig).getTableDesc(table, project);
            this.attachTableMetadata(tableDesc, this.job.getConfiguration());
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    static {
        OptionBuilder.withArgName((String)"table name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"The hive table name");
        OPTION_TABLE = OptionBuilder.create((String)"table");
    }
}

