/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import java.util.Locale;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.jdbc.JdbcTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTable
implements IReadableTable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTable.class);
    private final String database;
    private final String tableName;

    public JdbcTable(TableDesc tableDesc) {
        this.database = tableDesc.getDatabase();
        this.tableName = tableDesc.getName();
    }

    public IReadableTable.TableReader getReader() throws IOException {
        return new JdbcTableReader(this.database, this.tableName);
    }

    public IReadableTable.TableSignature getSignature() throws IOException {
        String path = String.format(Locale.ROOT, "%s.%s", this.database, this.tableName);
        long lastModified = System.currentTimeMillis();
        int size = 0;
        return new IReadableTable.TableSignature(path, (long)size, lastModified);
    }

    public boolean exists() {
        return true;
    }

    public String toString() {
        return "database=[" + this.database + "], table=[" + this.tableName + "]";
    }
}

