/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.extensible;

import org.apache.kylin.engine.mr.IInput;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.source.hive.HiveMRInput;
import org.apache.kylin.source.jdbc.extensible.JdbcHiveInputBase;

public class JdbcHiveMRInput
extends JdbcHiveInputBase
implements IMRInput {
    private final JdbcConnector dataSource;

    JdbcHiveMRInput(JdbcConnector dataSource) {
        this.dataSource = dataSource;
    }

    public IMRInput.IMRBatchCubingInputSide getBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
        return new JdbcMRBatchCubingInputSide(flatDesc, this.dataSource);
    }

    public IInput.IBatchMergeInputSide getBatchMergeInputSide(ISegment seg) {
        return new IMRInput.IMRBatchMergeInputSide(){

            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
            }
        };
    }

    public IMRInput.IMRTableInputFormat getTableInputFormat(TableDesc table, String uuid) {
        return new HiveMRInput.HiveTableInputFormat(JdbcHiveMRInput.getTableNameForHCat((TableDesc)table, (String)uuid));
    }

    public static class JdbcMRBatchCubingInputSide
    extends JdbcHiveInputBase.JDBCBaseBatchCubingInputSide
    implements IMRInput.IMRBatchCubingInputSide {
        public JdbcMRBatchCubingInputSide(IJoinedFlatTableDesc flatDesc, JdbcConnector dataSource) {
            super(flatDesc, dataSource);
        }

        public IMRInput.IMRTableInputFormat getFlatTableInputFormat() {
            return new HiveMRInput.HiveTableInputFormat(this.getIntermediateTableIdentity());
        }
    }
}

