/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.extensible;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.spark.ISparkInput;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.sdk.datasource.framework.SourceConnectorFactory;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourcePartition;
import org.apache.kylin.source.jdbc.extensible.JdbcExplorer;
import org.apache.kylin.source.jdbc.extensible.JdbcHiveMRInput;
import org.apache.kylin.source.jdbc.extensible.JdbcHiveSparkInput;
import org.apache.kylin.source.jdbc.extensible.JdbcTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSource
implements ISource {
    private static final Logger logger = LoggerFactory.getLogger(JdbcSource.class);
    public static final int SOURCE_ID = 16;
    private JdbcConnector dataSource;

    public JdbcSource(KylinConfig config) {
        try {
            this.dataSource = SourceConnectorFactory.getJdbcConnector((KylinConfig)config);
        }
        catch (Throwable e) {
            logger.warn("DataSource cannot be connected. This may not be required in a MapReduce job.", e);
        }
    }

    public ISourceMetadataExplorer getSourceMetadataExplorer() {
        return new JdbcExplorer(this.dataSource);
    }

    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == IMRInput.class) {
            return (I)((Object)new JdbcHiveMRInput(this.dataSource));
        }
        if (engineInterface == ISparkInput.class) {
            return (I)((Object)new JdbcHiveSparkInput(this.dataSource));
        }
        throw new RuntimeException("Cannot adapt to " + engineInterface);
    }

    public IReadableTable createReadableTable(TableDesc tableDesc, String uuid) {
        return new JdbcTable(this.dataSource, tableDesc);
    }

    public SourcePartition enrichSourcePartitionBeforeBuild(IBuildable buildable, SourcePartition srcPartition) {
        SourcePartition result = SourcePartition.getCopyOf((SourcePartition)srcPartition);
        result.setSegRange(null);
        return result;
    }

    public ISampleDataDeployer getSampleDataDeployer() {
        return new JdbcExplorer(this.dataSource);
    }

    public void unloadTable(String tableName, String project) throws IOException {
    }

    public void close() throws IOException {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }
}

