/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.sqoop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SourceConfigurationUtil;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopCmdStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(SqoopCmdStep.class);
    private final PatternedLogger stepLogger = new PatternedLogger(logger);
    private static final String MR_OVERRIDE_QUEUE_KEY = "mapreduce.job.queuename";
    private static final String DEFAULT_QUEUE = "default";

    public void setCmd(String cmd) {
        this.setParam("cmd", cmd);
    }

    protected void sqoopFlatHiveTable(KylinConfig config) throws IOException {
        String cmd = this.getParam("cmd");
        cmd = String.format(Locale.ROOT, "%s/bin/sqoop import -Dorg.apache.sqoop.splitter.allow_text_splitter=true " + this.generateSqoopConfigArgString() + cmd, config.getSqoopHome());
        this.stepLogger.log(String.format(Locale.ROOT, "exe cmd:%s", cmd));
        Pair response = config.getCliCommandExecutor().execute(cmd, (org.apache.kylin.common.util.Logger)this.stepLogger);
        this.getManager().addJobInfo(this.getId(), this.stepLogger.getInfo());
        if ((Integer)response.getFirst() != 0) {
            throw new RuntimeException("Failed to create flat hive table, error code " + response.getFirst());
        }
    }

    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        try {
            this.sqoopFlatHiveTable(config);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog(), (Throwable)e);
        }
    }

    protected String generateSqoopConfigArgString() {
        KylinConfig kylinConfig = this.getConfig();
        HashMap config = Maps.newHashMap();
        config.put(MR_OVERRIDE_QUEUE_KEY, this.getSqoopJobQueueName(kylinConfig));
        config.putAll(SourceConfigurationUtil.loadSqoopConfiguration());
        config.putAll(kylinConfig.getSqoopConfigOverride());
        StringBuilder args = new StringBuilder();
        for (Map.Entry entry : config.entrySet()) {
            args.append(" -D" + (String)entry.getKey() + "=" + (String)entry.getValue() + " ");
        }
        return args.toString();
    }

    protected String getSqoopJobQueueName(KylinConfig config) {
        Map mrConfigOverride = config.getMRConfigOverride();
        if (mrConfigOverride.containsKey(MR_OVERRIDE_QUEUE_KEY)) {
            return (String)mrConfigOverride.get(MR_OVERRIDE_QUEUE_KEY);
        }
        return DEFAULT_QUEUE;
    }
}

