/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConfigManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<KafkaConfig> kafkaMap;
    private CachedCrudAssist<KafkaConfig> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public static KafkaConfigManager getInstance(KylinConfig config) {
        return (KafkaConfigManager)config.getManager(KafkaConfigManager.class);
    }

    static KafkaConfigManager newInstance(KylinConfig config) throws IOException {
        return new KafkaConfigManager(config);
    }

    private KafkaConfigManager(KylinConfig config) throws IOException {
        this.config = config;
        this.kafkaMap = new CaseInsensitiveStringCache(config, "kafka");
        this.crud = new CachedCrudAssist<KafkaConfig>(this.getStore(), "/kafka", KafkaConfig.class, this.kafkaMap){

            protected KafkaConfig initEntityAfterReload(KafkaConfig t, String resourceName) {
                return t;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance((KylinConfig)config).registerListener((Broadcaster.Listener)new KafkaSyncListener(), new String[]{"kafka"});
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore((KylinConfig)this.config);
    }

    public KafkaConfig getKafkaConfig(String name) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            KafkaConfig kafkaConfig = (KafkaConfig)((Object)this.kafkaMap.get((Object)name));
            return kafkaConfig;
        }
    }

    public List<KafkaConfig> listAllKafkaConfigs() {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            ArrayList<KafkaConfig> arrayList = new ArrayList<KafkaConfig>(this.kafkaMap.values());
            return arrayList;
        }
    }

    public boolean createKafkaConfig(KafkaConfig kafkaConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            if (this.kafkaMap.containsKey(kafkaConfig.resourceName())) {
                throw new IllegalArgumentException("KafkaConfig '" + kafkaConfig.getName() + "' already exists");
            }
            kafkaConfig.updateRandomUuid();
            this.checkKafkaConfig(kafkaConfig);
            this.crud.save((RootPersistentEntity)kafkaConfig);
            boolean bl = true;
            return bl;
        }
    }

    public KafkaConfig updateKafkaConfig(KafkaConfig kafkaConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            if (!this.kafkaMap.containsKey(kafkaConfig.resourceName())) {
                throw new IllegalArgumentException("KafkaConfig '" + kafkaConfig.getName() + "' does not exist.");
            }
            this.checkKafkaConfig(kafkaConfig);
            KafkaConfig kafkaConfig2 = (KafkaConfig)this.crud.save((RootPersistentEntity)kafkaConfig);
            return kafkaConfig2;
        }
    }

    private void checkKafkaConfig(KafkaConfig kafkaConfig) {
        if (kafkaConfig == null || StringUtils.isEmpty((CharSequence)kafkaConfig.getName())) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((CharSequence)kafkaConfig.getTopic())) {
            throw new IllegalArgumentException("No topic info");
        }
        if (kafkaConfig.getKafkaClusterConfigs() == null || kafkaConfig.getKafkaClusterConfigs().size() == 0) {
            throw new IllegalArgumentException("No cluster info");
        }
    }

    public void removeKafkaConfig(KafkaConfig kafkaConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.delete((RootPersistentEntity)kafkaConfig);
        }
    }

    private class KafkaSyncListener
    extends Broadcaster.Listener {
        private KafkaSyncListener() {
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = KafkaConfigManager.this.lock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    KafkaConfigManager.this.kafkaMap.removeLocal((Object)cacheKey);
                } else {
                    KafkaConfigManager.this.crud.reloadQuietly(cacheKey);
                }
            }
        }
    }
}

