/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.source.kafka.config.KafkaClusterConfig;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class KafkaConfig
extends RootPersistentEntity {
    public static Serializer<KafkaConfig> SERIALIZER = new JsonSerializer(KafkaConfig.class);
    @JsonProperty(value="name")
    private String name;
    @JsonManagedReference
    @JsonProperty(value="clusters")
    private List<KafkaClusterConfig> kafkaClusterConfigs;
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="timeout")
    private int timeout;
    @JsonProperty(value="parserName")
    private String parserName;
    @JsonProperty(value="timestampField")
    private String timestampField;
    @Deprecated
    @JsonProperty(value="margin")
    private long margin;
    @JsonProperty(value="splitRows")
    private int splitRows = 1000000;
    @JsonProperty(value="parserProperties")
    private String parserProperties;

    public String resourceName() {
        return this.name;
    }

    public String getResourcePath() {
        return KafkaConfig.concatResourcePath(this.name);
    }

    public static String concatResourcePath(String streamingName) {
        return "/kafka/" + streamingName + ".json";
    }

    public List<KafkaClusterConfig> getKafkaClusterConfigs() {
        return this.kafkaClusterConfigs;
    }

    public String getParserName() {
        return this.parserName;
    }

    public void setParserName(String parserName) {
        this.parserName = parserName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public long getMargin() {
        return this.margin;
    }

    @Deprecated
    public void setMargin(long margin) {
        this.margin = margin;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public String getParserProperties() {
        return this.parserProperties;
    }

    public void setParserProperties(String parserProperties) {
        this.parserProperties = parserProperties;
    }

    public String getAllParserProperties() {
        StringBuilder sb = new StringBuilder();
        if (this.timestampField != null) {
            sb.append("tsColName=" + this.timestampField);
            sb.append(";");
        }
        if (this.parserProperties != null) {
            sb.append(this.parserProperties);
        }
        return sb.toString();
    }

    public int getSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(int splitRows) {
        this.splitRows = splitRows;
    }

    public KafkaConfig clone() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SERIALIZER.serialize((RootPersistentEntity)this, new DataOutputStream(baos));
            return (KafkaConfig)SERIALIZER.deserialize(new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

