/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.hadoop;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.source.kafka.KafkaConfigManager;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.apache.kylin.source.kafka.config.KafkaConsumerProperties;
import org.apache.kylin.source.kafka.hadoop.KafkaFlatTableMapper;
import org.apache.kylin.source.kafka.hadoop.KafkaInputFormat;
import org.apache.kylin.source.kafka.util.KafkaClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaFlatTableJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(KafkaFlatTableJob.class);
    public static final String CONFIG_KAFKA_PARITION_MIN = "kafka.partition.min";
    public static final String CONFIG_KAFKA_PARITION_MAX = "kafka.partition.max";
    public static final String CONFIG_KAFKA_PARITION_START = "kafka.partition.start.";
    public static final String CONFIG_KAFKA_PARITION_END = "kafka.partition.end.";
    public static final String CONFIG_KAFKA_BROKERS = "kafka.brokers";
    public static final String CONFIG_KAFKA_TOPIC = "kafka.topic";
    public static final String CONFIG_KAFKA_TIMEOUT = "kafka.connect.timeout";
    public static final String CONFIG_KAFKA_CONSUMER_GROUP = "kafka.consumer.group";
    public static final String CONFIG_KAFKA_INPUT_FORMAT = "input.format";
    public static final String CONFIG_KAFKA_PARSER_NAME = "kafka.parser.name";
    public static final String CONFIG_KAFKA_SPLIT_ROWS = "kafka.split.rows";

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_SEGMENT_ID);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String segmentId = this.getOptionValue(OPTION_SEGMENT_ID);
            CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentId);
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            KafkaConfigManager kafkaConfigManager = KafkaConfigManager.getInstance(KylinConfig.getInstanceFromEnv());
            KafkaConfig kafkaConfig = kafkaConfigManager.getKafkaConfig(cube.getRootFactTable());
            String brokers = KafkaClient.getKafkaBrokers(kafkaConfig);
            String topic = kafkaConfig.getTopic();
            if (brokers == null || brokers.length() == 0 || topic == null) {
                throw new IllegalArgumentException("Invalid Kafka information, brokers " + brokers + ", topic " + topic);
            }
            JobEngineConfig jobEngineConfig = new JobEngineConfig(KylinConfig.getInstanceFromEnv());
            this.job.getConfiguration().addResource(new Path(jobEngineConfig.getHadoopJobConfFilePath(null)));
            KafkaConsumerProperties kafkaConsumerProperties = KafkaConsumerProperties.getInstanceFromEnv();
            this.job.getConfiguration().addResource(new Path(kafkaConsumerProperties.getKafkaConsumerHadoopJobConf()));
            this.job.getConfiguration().set(CONFIG_KAFKA_BROKERS, brokers);
            this.job.getConfiguration().set(CONFIG_KAFKA_TOPIC, topic);
            this.job.getConfiguration().set(CONFIG_KAFKA_TIMEOUT, String.valueOf(kafkaConfig.getTimeout()));
            this.job.getConfiguration().set(CONFIG_KAFKA_INPUT_FORMAT, "json");
            this.job.getConfiguration().set(CONFIG_KAFKA_PARSER_NAME, kafkaConfig.getParserName());
            this.job.getConfiguration().set(CONFIG_KAFKA_SPLIT_ROWS, String.valueOf(kafkaConfig.getSplitRows()));
            this.job.getConfiguration().set(CONFIG_KAFKA_CONSUMER_GROUP, cubeName);
            KafkaFlatTableJob.appendKafkaOverrideProperties(cube.getConfig(), this.job.getConfiguration());
            this.setupMapper(cube.getSegmentById(segmentId));
            this.job.setNumReduceTasks(0);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            FileOutputFormat.setCompressOutput((Job)this.job, (boolean)true);
            org.apache.log4j.Logger.getRootLogger().info((Object)("Output hdfs location: " + output));
            org.apache.log4j.Logger.getRootLogger().info((Object)"Output hdfs compression: true");
            this.job.getConfiguration().set("output.path", output.toString());
            this.attachCubeMetadata(cube, this.job.getConfiguration());
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in KafkaFlatTableJob", (Throwable)e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void setupMapper(CubeSegment cubeSeg) throws IOException {
        Map offsetStart = cubeSeg.getSourcePartitionOffsetStart();
        Map offsetEnd = cubeSeg.getSourcePartitionOffsetEnd();
        Integer minPartition = (Integer)Collections.min(offsetStart.keySet());
        Integer maxPartition = (Integer)Collections.max(offsetStart.keySet());
        this.job.getConfiguration().set(CONFIG_KAFKA_PARITION_MIN, minPartition.toString());
        this.job.getConfiguration().set(CONFIG_KAFKA_PARITION_MAX, maxPartition.toString());
        for (Integer partition : offsetStart.keySet()) {
            this.job.getConfiguration().set(CONFIG_KAFKA_PARITION_START + partition, ((Long)offsetStart.get(partition)).toString());
            this.job.getConfiguration().set(CONFIG_KAFKA_PARITION_END + partition, ((Long)offsetEnd.get(partition)).toString());
        }
        this.job.setMapperClass(KafkaFlatTableMapper.class);
        this.job.setInputFormatClass(KafkaInputFormat.class);
        this.job.setOutputKeyClass(BytesWritable.class);
        this.job.setOutputValueClass(Text.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
    }

    private static void appendKafkaOverrideProperties(KylinConfig kylinConfig, Configuration conf) {
        Map kafkaConfOverride = kylinConfig.getKafkaConfigOverride();
        if (!kafkaConfOverride.isEmpty()) {
            for (String key : kafkaConfOverride.keySet()) {
                conf.set(key, (String)kafkaConfOverride.get(key), "kafka");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        KafkaFlatTableJob job = new KafkaFlatTableJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

