/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.StreamingMessageRow;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.kafka.KafkaConfigManager;
import org.apache.kylin.source.kafka.StreamingParser;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.apache.kylin.source.kafka.model.StreamCubeFactTableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaFlatTableMapper
extends KylinMapper<LongWritable, BytesWritable, BytesWritable, Text> {
    private BytesWritable outKey = new BytesWritable();
    private static final Logger logger = LoggerFactory.getLogger(KafkaFlatTableMapper.class);
    private Text outValue = new Text();
    private KylinConfig config;
    private CubeSegment cubeSegment;
    private StreamingParser streamingParser;
    private String data;
    private String delimiter;

    protected void doSetup(Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        this.bindCurrentConfiguration(conf);
        this.config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        String cubeName = conf.get("cube.name");
        CubeInstance cube = CubeManager.getInstance((KylinConfig)this.config).getCube(cubeName);
        this.cubeSegment = cube.getSegmentById(conf.get("cube.segment.id"));
        this.delimiter = "\u0001";
        logger.info("Use delimiter: " + this.delimiter);
        KafkaConfigManager kafkaConfigManager = KafkaConfigManager.getInstance(this.config);
        KafkaConfig kafkaConfig = kafkaConfigManager.getKafkaConfig(this.cubeSegment.getCubeInstance().getRootFactTable());
        CubeJoinedFlatTableDesc flatTableDesc = new CubeJoinedFlatTableDesc(this.cubeSegment);
        StreamCubeFactTableDesc streamFactTableDesc = new StreamCubeFactTableDesc(this.cubeSegment.getCubeDesc(), this.cubeSegment, (IJoinedFlatTableDesc)flatTableDesc);
        List<TblColRef> allColumns = streamFactTableDesc.getAllColumns();
        try {
            this.streamingParser = StreamingParser.getStreamingParser(kafkaConfig.getParserName(), kafkaConfig.getAllParserProperties(), allColumns);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void doMap(LongWritable key, BytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
        ByteBuffer buffer = ByteBuffer.wrap(value.getBytes(), 0, value.getLength());
        StreamingMessageRow row = this.streamingParser.parse(buffer).get(0);
        if (row == null) {
            throw new IllegalArgumentException("");
        }
        this.data = StringUtil.join((Iterable)row.getData(), (String)this.delimiter);
        this.outValue.set(Bytes.toBytes((String)this.data));
        context.write((Object)this.outKey, (Object)this.outValue);
    }
}

