/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSampleProducer {
    private static final Logger logger = LoggerFactory.getLogger(KafkaSampleProducer.class);
    private static final Option OPTION_TOPIC;
    private static final Option OPTION_BROKER;
    private static final Option OPTION_INTERVAL;
    protected static final String OTHER = "Other";
    private static final ObjectMapper mapper;

    public static void main(String[] args) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("args: {}", (Object)Arrays.toString(args));
        }
        OptionsHelper optionsHelper = new OptionsHelper();
        Options options = new Options();
        options.addOption(OPTION_TOPIC);
        options.addOption(OPTION_BROKER);
        options.addOption(OPTION_INTERVAL);
        optionsHelper.parseOptions(options, args);
        logger.info("options: '{}'", (Object)optionsHelper.getOptionsAsString());
        String topic = optionsHelper.getOptionValue(OPTION_TOPIC);
        String broker = optionsHelper.getOptionValue(OPTION_BROKER);
        long interval = 10L;
        String intervalString = optionsHelper.getOptionValue(OPTION_INTERVAL);
        if (intervalString != null) {
            interval = Long.parseLong(intervalString);
        }
        ArrayList<String> countries = new ArrayList<String>();
        countries.add("AUSTRALIA");
        countries.add("CANADA");
        countries.add("CHINA");
        countries.add("INDIA");
        countries.add("JAPAN");
        countries.add("KOREA");
        countries.add("US");
        countries.add(OTHER);
        ArrayList<String> category = new ArrayList<String>();
        category.add("BOOK");
        category.add("TOY");
        category.add("CLOTH");
        category.add("ELECTRONIC");
        category.add(OTHER);
        ArrayList<String> devices = new ArrayList<String>();
        devices.add("iOS");
        devices.add("Windows");
        devices.add("Andriod");
        devices.add(OTHER);
        ArrayList<String> genders = new ArrayList<String>();
        genders.add("Male");
        genders.add("Female");
        Properties props = new Properties();
        props.put("bootstrap.servers", broker);
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        long startTime = System.currentTimeMillis();
        try (KafkaProducer producer = new KafkaProducer(props);){
            boolean alive = true;
            Random rnd = new Random();
            HashMap<String, Object> record = new HashMap<String, Object>();
            while (alive) {
                record.put("order_time", new Date().getTime());
                record.put("country", countries.get(rnd.nextInt(countries.size())));
                record.put("category", category.get(rnd.nextInt(category.size())));
                record.put("device", devices.get(rnd.nextInt(devices.size())));
                record.put("qty", rnd.nextInt(10));
                record.put("currency", "USD");
                record.put("amount", rnd.nextDouble() * 100.0);
                HashMap<String, Object> user = new HashMap<String, Object>();
                user.put("id", RandomUtil.randomUUID().toString());
                user.put("gender", genders.get(rnd.nextInt(2)));
                user.put("age", rnd.nextInt(20) + 10);
                user.put("first_name", "unknown");
                record.put("user", user);
                ProducerRecord data = new ProducerRecord(topic, (Object)(System.currentTimeMillis() + ""), (Object)mapper.writeValueAsString(record));
                if (logger.isInfoEnabled()) {
                    logger.info("Sending 1 message: {}", (Object)JsonUtil.writeValueAsString(record));
                }
                producer.send(data);
                Thread.sleep(interval);
                if (System.currentTimeMillis() - startTime < 604800000L) continue;
                alive = false;
            }
        }
    }

    static {
        OptionBuilder.withArgName((String)"topic");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Kafka topic");
        OPTION_TOPIC = OptionBuilder.create((String)"topic");
        OptionBuilder.withArgName((String)"broker");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Kafka broker");
        OPTION_BROKER = OptionBuilder.create((String)"broker");
        OptionBuilder.withArgName((String)"interval");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Simulated message interval in mili-seconds, default 1000");
        OPTION_INTERVAL = OptionBuilder.create((String)"interval");
        mapper = new ObjectMapper();
    }
}

