/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.common.logging;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.engine.spark.common.logging.AbstractHdfsLogAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.spark.utils.SparkHadoopUtils;

public class SparkDriverHdfsLogAppender
extends AbstractHdfsLogAppender {
    private String logPath;
    private boolean kerberosEnable = false;
    private String kerberosPrincipal;
    private String kerberosKeytab;

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public boolean isKerberosEnable() {
        return this.kerberosEnable;
    }

    public void setKerberosEnable(boolean kerberosEnable) {
        this.kerberosEnable = kerberosEnable;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public String getKerberosKeytab() {
        return this.kerberosKeytab;
    }

    public void setKerberosKeytab(String kerberosKeytab) {
        this.kerberosKeytab = kerberosKeytab;
    }

    @Override
    public void init() {
        LogLog.warn((String)("spark.driver.log4j.appender.hdfs.File -> " + this.getLogPath()));
        LogLog.warn((String)("kerberosEnable -> " + this.isKerberosEnable()));
        if (this.isKerberosEnable()) {
            LogLog.warn((String)("kerberosPrincipal -> " + this.getKerberosPrincipal()));
            LogLog.warn((String)("kerberosKeytab -> " + this.getKerberosKeytab()));
        }
    }

    @Override
    String getAppenderName() {
        return "SparkDriverHdfsLogAppender";
    }

    @Override
    public boolean isSkipCheckAndFlushLog() {
        return false;
    }

    @Override
    public void doWriteLog(int eventSize, List<LoggingEvent> transaction) throws IOException, InterruptedException {
        if (!this.isWriterInited()) {
            Configuration conf = SparkHadoopUtils.newConfigurationWithSparkConf();
            if (this.isKerberosEnable()) {
                UserGroupInformation.setConfiguration((Configuration)conf);
                UserGroupInformation.loginUserFromKeytab((String)this.getKerberosPrincipal(), (String)this.getKerberosKeytab());
            }
            if (!this.initHdfsWriter(new Path(this.getLogPath()), conf)) {
                LogLog.error((String)"init the hdfs writer failed!");
            }
        }
        while (eventSize > 0) {
            LoggingEvent loggingEvent = this.getLogBufferQue().take();
            transaction.add(loggingEvent);
            this.writeLogEvent(loggingEvent);
            --eventSize;
        }
    }
}

