/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.metadata.cube;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathManager {
    private static final Logger logger = LoggerFactory.getLogger(PathManager.class);

    public static String getParquetStoragePath(KylinConfig config, String cubeName, String segName, String identifier, String cuboidId) {
        CubeInstance cube = CubeManager.getInstance((KylinConfig)config).getCube(cubeName);
        return PathManager.getParquetStoragePath(cube, segName, identifier, Long.parseLong(cuboidId));
    }

    public static String getParquetStoragePath(CubeInstance cube, String segName, String identifier, Long cuboidId) {
        String hdfsWorkDir = cube.getConfig().getHdfsWorkingDirectory(cube.getProject());
        return hdfsWorkDir + "parquet" + File.separator + cube.getName() + File.separator + segName + "_" + identifier + File.separator + cuboidId;
    }

    public static String getSegmentParquetStoragePath(CubeInstance cube, String segName, String identifier) {
        String hdfsWorkDir = cube.getConfig().getHdfsWorkingDirectory(cube.getProject());
        return hdfsWorkDir + "parquet" + File.separator + cube.getName() + File.separator + segName + "_" + identifier;
    }

    public static String getSegmentParquetStoragePath(String hdfsWorkDir, String cubeName, CubeSegment segment) {
        String segmentName = segment.getName();
        String identifier = segment.getStorageLocationIdentifier();
        return hdfsWorkDir + "parquet" + File.separator + cubeName + File.separator + segmentName + "_" + identifier;
    }

    public static boolean deleteSegmentParquetStoragePath(CubeInstance cube, String segmentName, String identifier) throws IOException {
        if (cube == null || StringUtils.isBlank((CharSequence)segmentName) || StringUtils.isBlank((CharSequence)identifier)) {
            return false;
        }
        String path = PathManager.getSegmentParquetStoragePath(cube, segmentName, identifier);
        logger.info("Deleting segment parquet path {}", (Object)path);
        HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(path));
        return true;
    }

    public static boolean deleteJobTempPath(KylinConfig kylinConfig, String project, String jobId) {
        if (StringUtils.isEmpty((CharSequence)jobId) || StringUtils.isEmpty((CharSequence)project)) {
            return false;
        }
        Path jobTmpPath = new Path(kylinConfig.getJobTmpDir(project));
        try {
            Path[] toDeletedPath = HadoopUtil.getFilteredPath((FileSystem)jobTmpPath.getFileSystem(HadoopUtil.getCurrentConfiguration()), (Path)jobTmpPath, (String)jobId);
            if (toDeletedPath != null && toDeletedPath.length > 0) {
                for (Path deletedPath : toDeletedPath) {
                    logger.info("Deleting job tmp path {}", (Object)deletedPath.toString());
                    HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)deletedPath);
                }
            }
        }
        catch (IOException e) {
            logger.error("Can not delete job tmp path: {}", (Object)jobTmpPath);
            return false;
        }
        return true;
    }
}

