/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasource;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.MetadataConverter$;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.datasource.FilePruner$;
import org.apache.spark.sql.execution.datasource.ResetShufflePartition;
import org.apache.spark.sql.execution.datasource.SegFilters;
import org.apache.spark.sql.execution.datasource.SegmentDirectory;
import org.apache.spark.sql.execution.datasource.ShardFileStatusCache$;
import org.apache.spark.sql.execution.datasource.ShardSpec;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.sources.AlwaysFalse$;
import org.apache.spark.sql.sources.AlwaysTrue$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import org.apache.spark.util.collection.BitSet;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0005b\u0001B\u001d;\u0001\u001dC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"AQ\u000e\u0001BC\u0002\u0013\u0005a\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003p\u0011!!\bA!b\u0001\n\u0003)\b\"CA\u0005\u0001\t\u0005\t\u0015!\u0003w\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bA\u0011\"!\u0007\u0001\u0005\u0004%\t!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A!\"!\n\u0001\u0011\u000b\u0007I\u0011BA\u0014\u0011%\t\t\u0005\u0001b\u0001\n\u0003\t\u0019\u0005\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA#\u0011%\ty\u0006\u0001b\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA2\u0011\u001d\t\t\b\u0001C!\u0003gBq!a\"\u0001\t\u0003\tI\t\u0003\u0006\u0002\u0014\u0002A)\u0019!C!\u0003CB1\"!&\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0018\"Y\u0011\u0011\u0014\u0001A\u0002\u0003\u0007I\u0011AAN\u0011-\t9\u000b\u0001a\u0001\u0002\u0003\u0006K!a\u0001\t\u0015\u0005%\u0006\u0001#b\u0001\n\u0003\t\t\u0007\u0003\u0006\u0002,\u0002A)\u0019!C\u0001\u0003CB1\"!,\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020\"Y\u0011\u0011\u0019\u0001A\u0002\u0003\u0007I\u0011BAb\u0011-\t9\r\u0001a\u0001\u0002\u0003\u0006K!!-\t\u0017\u0005%\u0007\u00011AA\u0002\u0013%\u0011q\u0016\u0005\f\u0003\u0017\u0004\u0001\u0019!a\u0001\n\u0013\ti\rC\u0006\u0002R\u0002\u0001\r\u0011!Q!\n\u0005E\u0006\"CAj\u0001\u0001\u0007I\u0011BAk\u0011%\ti\u000e\u0001a\u0001\n\u0013\ty\u000e\u0003\u0005\u0002d\u0002\u0001\u000b\u0015BAl\u0011\u001d\t)\u000f\u0001C\u0001\u0003OD\u0011Ba\b\u0001\u0001\u0004%IA!\t\t\u0013\t=\u0002\u00011A\u0005\n\tE\u0002\u0002\u0003B\u001b\u0001\u0001\u0006KAa\t\t\u000f\t]\u0002\u0001\"\u0001\u0003\"!9!\u0011\b\u0001\u0005\n\tm\u0002\"\u0003B!\u0001\u0001\u0007I\u0011\u0001B\"\u0011%\u0011Y\u0007\u0001a\u0001\n\u0003\u0011i\u0007\u0003\u0005\u0003r\u0001\u0001\u000b\u0015\u0002B#\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005kBqA!\"\u0001\t\u0003\u00129\tC\u0004\u0003\u0012\u0002!IAa%\t\u000f\t5\u0006\u0001\"\u0003\u00030\"9!q\u0017\u0001\u0005\n\te\u0006b\u0002Bb\u0001\u0011%!Q\u0019\u0005\b\u0005\u001f\u0004A\u0011\u0002Bi\u0011)\u00119\u000e\u0001EC\u0002\u0013\u0005#\u0011\u001c\u0005\u000b\u0005C\u0004\u0001R1A\u0005B\u0005m\u0001b\u0002Br\u0001\u0011\u0005#Q\u001d\u0005\b\u0005O\u0004A\u0011\u0002Bu\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001b9qa!\u0005;\u0011\u0003\u0019\u0019B\u0002\u0004:u!\u00051Q\u0003\u0005\b\u0003\u00171D\u0011AB\f\u0011\u001d\u0019IB\u000eC\u0001\u00077\u0011!BR5mKB\u0013XO\\3s\u0015\tYD(\u0001\u0006eCR\f7o\\;sG\u0016T!!\u0010 \u0002\u0013\u0015DXmY;uS>t'BA A\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0003\n\u000bQa\u001d9be.T!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO\u000e\u00011#\u0002\u0001I\u001dRC\u0006CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g\r\u0005\u0002P%6\t\u0001K\u0003\u0002Ry\u0005YA-\u0019;bg>,(oY3t\u0013\t\u0019\u0006KA\u0005GS2,\u0017J\u001c3fqB\u0011QKV\u0007\u0002u%\u0011qK\u000f\u0002\u0016%\u0016\u001cX\r^*ik\u001a4G.\u001a)beRLG/[8o!\tIF,D\u0001[\u0015\tY\u0006)\u0001\u0005j]R,'O\\1m\u0013\ti&LA\u0004M_\u001e<\u0017N\\4\u0002\u0019\r,(-Z%ogR\fgnY3\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001B2vE\u0016T!\u0001\u001a\"\u0002\u000b-LH.\u001b8\n\u0005\u0019\f'\u0001D\"vE\u0016Len\u001d;b]\u000e,\u0017AB2vE>LG\r\u0005\u0002jW6\t!N\u0003\u0002hC&\u0011AN\u001b\u0002\u0007\u0007V\u0014w.\u001b3\u0002\u000fM,7o]5p]V\tq\u000e\u0005\u0002qc6\ta(\u0003\u0002s}\ta1\u000b]1sWN+7o]5p]\u0006A1/Z:tS>t\u0007%A\u0004paRLwN\\:\u0016\u0003Y\u0004ba\u001e@\u0002\u0004\u0005\raB\u0001=}!\tI(*D\u0001{\u0015\tYh)\u0001\u0004=e>|GOP\u0005\u0003{*\u000ba\u0001\u0015:fI\u00164\u0017bA@\u0002\u0002\t\u0019Q*\u00199\u000b\u0005uT\u0005cA<\u0002\u0006%!\u0011qAA\u0001\u0005\u0019\u0019FO]5oO\u0006Aq\u000e\u001d;j_:\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0001CA+\u0001\u0011\u0015qv\u00011\u0001`\u0011\u00159w\u00011\u0001i\u0011\u0015iw\u00011\u0001p\u0011\u0015!x\u00011\u0001w\u0003ii\u0015\tW0T\u0011\u0006\u0013F)\u0013(H?NK%,R0Q\u000bJ{F+Q*L+\t\ti\u0002E\u0002J\u0003?I1!!\tK\u0005\u0011auN\\4\u000275\u000b\u0005lX*I\u0003J#\u0015JT$`'&SVi\u0018)F%~#\u0016iU&!\u0003-\u0019XmZ7f]R$\u0015N]:\u0016\u0005\u0005%\u0002CBA\u0016\u0003k\tYD\u0004\u0003\u0002.\u0005EbbA=\u00020%\t1*C\u0002\u00024)\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0005e\"aA*fc*\u0019\u00111\u0007&\u0011\u0007U\u000bi$C\u0002\u0002@i\u0012\u0001cU3h[\u0016tG\u000fR5sK\u000e$xN]=\u0002\u00191\f\u0017p\\;u\u000b:$\u0018\u000e^=\u0016\u0005\u0005\u0015\u0003\u0003BA$\u00033j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0006[>$W\r\u001c\u0006\u0004E\u0006=#\u0002BA)\u0003'\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0004\u0003\u0006U#bAA,G\u00061QM\\4j]\u0016LA!a\u0017\u0002J\taA*Y=pkR,e\u000e^5us\u0006iA.Y=pkR,e\u000e^5us\u0002\n!\u0002Z1uCN\u001b\u0007.Z7b+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tIGP\u0001\u0006if\u0004Xm]\u0005\u0005\u0003[\n9G\u0001\u0006TiJ,8\r\u001e+za\u0016\f1\u0002Z1uCN\u001b\u0007.Z7bA\u0005I!o\\8u!\u0006$\bn]\u000b\u0003\u0003k\u0002b!a\u000b\u00026\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0003MNT1!!!C\u0003\u0019A\u0017\rZ8pa&!\u0011QQA>\u0005\u0011\u0001\u0016\r\u001e5\u0002\rQ|\u0007+\u0019;i)\u0019\t\u0019!a#\u0002\u0010\"9\u0011Q\u0012\tA\u0002\u0005\r\u0011aC:fO6,g\u000e\u001e(b[\u0016Dq!!%\u0011\u0001\u0004\t\u0019!\u0001\u0006jI\u0016tG/\u001b4jKJ\fq\u0002]1si&$\u0018n\u001c8TG\",W.Y\u0001\ba\u0006$H/\u001a:o+\t\t\u0019!A\u0006qCR$XM\u001d8`I\u0015\fH\u0003BAO\u0003G\u00032!SAP\u0013\r\t\tK\u0013\u0002\u0005+:LG\u000fC\u0005\u0002&N\t\t\u00111\u0001\u0002\u0004\u0005\u0019\u0001\u0010J\u0019\u0002\u0011A\fG\u000f^3s]\u0002\n1\u0003^5nKB\u000b'\u000f^5uS>t7k\u00195f[\u0006\fQb\u001d5be\u0012\u0014\u0015pU2iK6\f\u0017a\u0005;j[\u0016\u0004\u0016M\u001d;ji&|gnQ8mk6tWCAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u00111\u0018 \u0002\u0011\r\fG/\u00197zgRLA!a0\u00026\nI\u0011\t\u001e;sS\n,H/Z\u0001\u0018i&lW\rU1si&$\u0018n\u001c8D_2,XN\\0%KF$B!!(\u0002F\"I\u0011Q\u0015\r\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u0015i&lW\rU1si&$\u0018n\u001c8D_2,XN\u001c\u0011\u0002\u001bMD\u0017M\u001d3Cs\u000e{G.^7o\u0003E\u0019\b.\u0019:e\u0005f\u001cu\u000e\\;n]~#S-\u001d\u000b\u0005\u0003;\u000by\rC\u0005\u0002&n\t\t\u00111\u0001\u00022\u0006q1\u000f[1sI\nK8i\u001c7v[:\u0004\u0013AC5t%\u0016\u001cx\u000e\u001c<fIV\u0011\u0011q\u001b\t\u0004\u0013\u0006e\u0017bAAn\u0015\n9!i\\8mK\u0006t\u0017AD5t%\u0016\u001cx\u000e\u001c<fI~#S-\u001d\u000b\u0005\u0003;\u000b\t\u000fC\u0005\u0002&z\t\t\u00111\u0001\u0002X\u0006Y\u0011n\u001d*fg>dg/\u001a3!\u0003\u001d\u0011Xm]8mm\u0016$b!!(\u0002j\u0006M\bbBAvA\u0001\u0007\u0011Q^\u0001\te\u0016d\u0017\r^5p]B\u0019q*a<\n\u0007\u0005E\bKA\bM_\u001eL7-\u00197SK2\fG/[8o\u0011\u001d\t)\u0010\ta\u0001\u0003o\f\u0001B]3t_24XM\u001d\t\u0005\u0003s\u0014IB\u0004\u0003\u0002|\nUa\u0002BA\u007f\u0005#qA!a@\u0003\u00109!!\u0011\u0001B\u0007\u001d\u0011\u0011\u0019Aa\u0003\u000f\t\t\u0015!\u0011\u0002\b\u0004s\n\u001d\u0011\"A#\n\u0005\r#\u0015BA!C\u0013\ty\u0004)C\u0002\u0002<zJAAa\u0005\u0002:\u0006A\u0011M\\1msNL7/\u0003\u0003\u00024\t]!\u0002\u0002B\n\u0003sKAAa\u0007\u0003\u001e\tA!+Z:pYZ,'O\u0003\u0003\u00024\t]\u0011!C:iCJ$7\u000b]3d+\t\u0011\u0019\u0003E\u0003J\u0005K\u0011I#C\u0002\u0003()\u0013aa\u00149uS>t\u0007cA+\u0003,%\u0019!Q\u0006\u001e\u0003\u0013MC\u0017M\u001d3Ta\u0016\u001c\u0017!D:iCJ$7\u000b]3d?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\nM\u0002\"CASE\u0005\u0005\t\u0019\u0001B\u0012\u0003)\u0019\b.\u0019:e'B,7\rI\u0001\rO\u0016$8\u000b[1sIN\u0003XmY\u0001\rO\u0016t7\u000b[1sIN\u0003Xm\u0019\u000b\u0005\u0005G\u0011i\u0004C\u0004\u0003@\u0015\u0002\r!!\u000b\u0002\u0011M,G.Z2uK\u0012\faaY1dQ\u0016$WC\u0001B#!!\u00119E!\u0015\u0003V\t\rTB\u0001B%\u0015\u0011\u0011YE!\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005\u001f\nAA[1wC&!!1\u000bB%\u0005\u001dA\u0015m\u001d5NCB\u0004r!\u0013B,\u00057\u0012Y&C\u0002\u0003Z)\u0013a\u0001V;qY\u0016\u0014\u0004CBA\u0016\u0003k\u0011i\u0006\u0005\u0003\u00024\n}\u0013\u0002\u0002B1\u0003k\u0013!\"\u0012=qe\u0016\u001c8/[8o!\u0019\tY#!\u000e\u0003fA\u0019qJa\u001a\n\u0007\t%\u0004K\u0001\nQCJ$\u0018\u000e^5p]\u0012K'/Z2u_JL\u0018AC2bG\",Gm\u0018\u0013fcR!\u0011Q\u0014B8\u0011%\t)kJA\u0001\u0002\u0004\u0011)%A\u0004dC\u000eDW\r\u001a\u0011\u0002%\u001d,GOR5mKN#\u0018\r^;t\u0005f\u001cVm\u001a\u000b\u0007\u0003w\u00119Ha\u001f\t\u000f\te\u0014\u00061\u0001\u0002<\u0005\u00191/Z4\t\u000f\tu\u0014\u00061\u0001\u0003\u0000\u0005\u0019am]2\u0011\u0007=\u0013\t)C\u0002\u0003\u0004B\u0013qBR5mKN#\u0018\r^;t\u0007\u0006\u001c\u0007.Z\u0001\nY&\u001cHOR5mKN$bAa\u0019\u0003\n\n5\u0005b\u0002BFU\u0001\u0007!1L\u0001\u0011a\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;feNDqAa$+\u0001\u0004\u0011Y&A\u0006eCR\fg)\u001b7uKJ\u001c\u0018\u0001D1gi\u0016\u0014\bK];oS:<G\u0003\u0003BK\u0005C\u0013)K!+\u0015\t\u0005%\"q\u0013\u0005\b\u00053[\u0003\u0019\u0001BN\u0003-\u0001(/\u001e8j]\u001e4UO\\2\u0011\u0013%\u0013iJa\u0017\u0002*\u0005%\u0012b\u0001BP\u0015\nIa)\u001e8di&|gN\r\u0005\b\u0005G[\u0003\u0019AA\u0002\u0003-\u0001(/\u001e8j]\u001e$\u0016\u0010]3\t\u000f\t\u001d6\u00061\u0001\u0003\\\u0005Y1\u000f]3d\r&dG/\u001a:t\u0011\u001d\u0011Yk\u000ba\u0001\u0003S\ta!\u001b8qkR\u001c\u0018\u0001E4fiN+w-\\3oi\u001aKG\u000e^3s)\u0019\u0011YF!-\u00034\"9!q\u0012\u0017A\u0002\tm\u0003b\u0002B[Y\u0001\u0007\u0011\u0011W\u0001\u0004G>d\u0017\u0001F3yiJ\f7\r^*fO6,g\u000e\u001e$jYR,'\u000f\u0006\u0004\u0003<\nu&\u0011\u0019\t\u0006\u0013\n\u0015\"Q\f\u0005\b\u0005\u007fk\u0003\u0019\u0001B/\u0003\u00191\u0017\u000e\u001c;fe\"9!QW\u0017A\u0002\u0005E\u0016!\u00049sk:,7+Z4nK:$8\u000f\u0006\u0004\u0002*\t\u001d'1\u001a\u0005\b\u0005\u0013t\u0003\u0019\u0001B.\u0003\u001d1\u0017\u000e\u001c;feNDqA!4/\u0001\u0004\tI#A\u0004tK\u001e$\u0015N]:\u0002\u0017A\u0014XO\\3TQ\u0006\u0014Hm\u001d\u000b\u0007\u0003S\u0011\u0019N!6\t\u000f\t%w\u00061\u0001\u0003\\!9!QZ\u0018A\u0002\u0005%\u0012AC5oaV$h)\u001b7fgV\u0011!1\u001c\t\u0006\u0013\nu\u00171A\u0005\u0004\u0005?T%!B!se\u0006L\u0018aC:ju\u0016LeNQ=uKN\fqA]3ge\u0016\u001c\b\u000e\u0006\u0002\u0002\u001e\u0006\u0019r-\u001a;FqB\u0014Xm]:j_:\u001c\u0006.\u0019:egRA!1\u001eB}\u0005{\u001c\t\u0001\u0005\u0003\u0003n\nUXB\u0001Bx\u0015\u0011\u0011\tPa=\u0002\u0015\r|G\u000e\\3di&|gNC\u0002\u0003L\u0001KAAa>\u0003p\n1!)\u001b;TKRDqAa?4\u0001\u0004\u0011i&\u0001\u0003fqB\u0014\bb\u0002B\u0000g\u0001\u0007\u00111A\u0001\u0010g\"\f'\u000fZ\"pYVlgNT1nK\"911A\u001aA\u0002\r\u0015\u0011!\u00038v[NC\u0017M\u001d3t!\rI5qA\u0005\u0004\u0007\u0013Q%aA%oi\u0006\t2m\u001c8wKJ$8)Y:u\r&dG/\u001a:\u0015\t\tu3q\u0002\u0005\b\u0005\u007f#\u0004\u0019\u0001B/\u0003)1\u0015\u000e\\3QeVtWM\u001d\t\u0003+Z\u001a\"A\u000e%\u0015\u0005\rM\u0011AD4fiB\u000b'\u000f^5uS>t\u0017\n\u001a\u000b\u0005\u0007\u000b\u0019i\u0002C\u0004\u0004 a\u0002\r!a\u001e\u0002\u0003A\u0004")
public class FilePruner
implements FileIndex,
ResetShufflePartition {
    private Seq<SegmentDirectory> segmentDirs;
    private StructType partitionSchema;
    private StructType timePartitionSchema;
    private StructType shardBySchema;
    private String[] inputFiles;
    private long sizeInBytes;
    private final CubeInstance cubeInstance;
    private final Cuboid cuboid;
    private final SparkSession session;
    private final Map<String, String> options;
    private final long MAX_SHARDING_SIZE_PER_TASK;
    private final LayoutEntity layoutEntity;
    private final StructType dataSchema;
    private String pattern;
    private Attribute timePartitionColumn;
    private Attribute shardByColumn;
    private boolean isResolved;
    private Option<ShardSpec> shardSpec;
    private HashMap<Tuple2<Seq<Expression>, Seq<Expression>>, Seq<PartitionDirectory>> cached;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int getPartitionId(Path path) {
        return FilePruner$.MODULE$.getPartitionId(path);
    }

    @Override
    public void setShufflePartitions(long bytes, SparkSession sparkSession, KylinConfig conf) {
        ResetShufflePartition.setShufflePartitions$(this, bytes, sparkSession, conf);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$((FileIndex)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession session() {
        return this.session;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public long MAX_SHARDING_SIZE_PER_TASK() {
        return this.MAX_SHARDING_SIZE_PER_TASK;
    }

    private Seq<SegmentDirectory> segmentDirs$lzycompute() {
        FilePruner filePruner = this;
        synchronized (filePruner) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.segmentDirs = (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)this.cubeInstance.getSegments()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$segmentDirs$1(x$1)))).map((Function1 & Serializable & scala.Serializable)seg -> new SegmentDirectory(seg.getName(), seg.getStorageLocationIdentifier(), (Seq<FileStatus>)Nil$.MODULE$), Buffer$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.segmentDirs;
    }

    private Seq<SegmentDirectory> segmentDirs() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.segmentDirs$lzycompute() : this.segmentDirs;
    }

    public LayoutEntity layoutEntity() {
        return this.layoutEntity;
    }

    public StructType dataSchema() {
        return this.dataSchema;
    }

    public Seq<Path> rootPaths() {
        return (Seq)this.segmentDirs().map((Function1 & Serializable & scala.Serializable)seg -> new Path(this.toPath(seg.segmentName(), seg.identifier())), Seq$.MODULE$.canBuildFrom());
    }

    public String toPath(String segmentName, String identifier) {
        return PathManager.getParquetStoragePath(this.cubeInstance, segmentName, identifier, Predef$.MODULE$.long2Long(this.cuboid.getId()));
    }

    private StructType partitionSchema$lzycompute() {
        FilePruner filePruner = this;
        synchronized (filePruner) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionSchema = new StructType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public String pattern() {
        return this.pattern;
    }

    public void pattern_$eq(String x$1) {
        this.pattern = x$1;
    }

    private StructType timePartitionSchema$lzycompute() {
        FilePruner filePruner = this;
        synchronized (filePruner) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Seq seq;
                PartitionDesc desc = this.cubeInstance.getModel().getPartitionDesc();
                if (desc != null && desc.getPartitionDateColumnRef() != null) {
                    TblColRef ref = desc.getPartitionDateColumnRef();
                    Option id = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.layoutEntity().getOrderedDimensions()).asScala()).values().find((Function1 & Serializable & scala.Serializable)column -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$timePartitionSchema$1(ref, column)));
                    if (id.isDefined() && (ref.getType().isDateTimeFamily() || ref.getType().isStringFamily() || ref.getType().isIntegerFamily())) {
                        this.pattern_$eq(desc.getPartitionDateFormat());
                        seq = (Seq)this.dataSchema().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$timePartitionSchema$2(id, x$2)));
                    } else {
                        seq = (Seq)Nil$.MODULE$;
                    }
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                this.timePartitionSchema = StructType$.MODULE$.apply(seq);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.timePartitionSchema;
    }

    public StructType timePartitionSchema() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.timePartitionSchema$lzycompute() : this.timePartitionSchema;
    }

    private StructType shardBySchema$lzycompute() {
        FilePruner filePruner = this;
        synchronized (filePruner) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Buffer shardByCols = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.layoutEntity().getShardByColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Buffer$.MODULE$.canBuildFrom());
                this.shardBySchema = StructType$.MODULE$.apply(shardByCols.isEmpty() ? (Seq)Nil$.MODULE$ : (Seq)this.dataSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)shardByCols.contains((Object)f.name()))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.shardBySchema;
    }

    public StructType shardBySchema() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.shardBySchema$lzycompute() : this.shardBySchema;
    }

    private Attribute timePartitionColumn() {
        return this.timePartitionColumn;
    }

    private void timePartitionColumn_$eq(Attribute x$1) {
        this.timePartitionColumn = x$1;
    }

    private Attribute shardByColumn() {
        return this.shardByColumn;
    }

    private void shardByColumn_$eq(Attribute x$1) {
        this.shardByColumn = x$1;
    }

    private boolean isResolved() {
        return this.isResolved;
    }

    private void isResolved_$eq(boolean x$1) {
        this.isResolved = x$1;
    }

    public void resolve(LogicalRelation relation, Function2<String, String, Object> resolver) {
        Seq shardByAttr;
        Seq timePartitionAttr = relation.resolve(this.timePartitionSchema(), resolver);
        if (timePartitionAttr.nonEmpty()) {
            this.timePartitionColumn_$eq((Attribute)timePartitionAttr.head());
        }
        if ((shardByAttr = relation.resolve(this.shardBySchema(), resolver)).nonEmpty()) {
            this.shardByColumn_$eq((Attribute)shardByAttr.head());
        }
        this.isResolved_$eq(true);
    }

    private Option<ShardSpec> shardSpec() {
        return this.shardSpec;
    }

    private void shardSpec_$eq(Option<ShardSpec> x$1) {
        this.shardSpec = x$1;
    }

    public Option<ShardSpec> getShardSpec() {
        return this.shardSpec();
    }

    private Option<ShardSpec> genShardSpec(Seq<SegmentDirectory> selected) {
        None$ none$;
        if (!this.cubeInstance.getConfig().isShardingJoinOptEnabled() || selected.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Seq segments = (Seq)((ParIterableLike)((ParIterableLike)selected.par()).map((Function1 & Serializable & scala.Serializable)segDir -> $this.cubeInstance.getSegment(segDir.segmentName(), SegmentStatusEnum.READY), (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).seq();
            short shardNum = Predef$.MODULE$.Short2short(((CubeSegment)segments.head()).getCuboidShardNum(Predef$.MODULE$.long2Long(this.layoutEntity().getId())));
            if (this.layoutEntity().getShardByColumns().isEmpty() || segments.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$genShardSpec$2(this, shardNum, x$4)))) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shard by column is empty or segments have the different number of shard, skip shard join.");
                none$ = None$.MODULE$;
            } else {
                Map partitionSizePerId = ((TraversableLike)((TraversableLike)selected.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.files(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2.mcIJ.sp(FilePruner$.MODULE$.getPartitionId(f.getPath()), f.getLen()), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6._1$mcI$sp())).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)FilePruner.$anonfun$genShardSpec$7(x$7)));
                if (partitionSizePerId.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$genShardSpec$9(this, x$9)))) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("There are some partition ids which the file size exceeds the ").append("threshold size ").append(this.MAX_SHARDING_SIZE_PER_TASK()).append(", skip shard join.").toString());
                    none$ = None$.MODULE$;
                } else {
                    Seq seq;
                    if (segments.length() == 1) {
                        seq = ((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.layoutEntity().getOrderedDimensions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString(), Set$.MODULE$.canBuildFrom())).toSeq();
                    } else {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Sort order will lost in multiple segments.");
                        seq = (Seq)Nil$.MODULE$;
                    }
                    Seq sortColumns = seq;
                    none$ = new Some((Object)new ShardSpec(shardNum, (Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.shardBySchema().fieldNames())).toSeq(), (Seq<String>)sortColumns));
                }
            }
        }
        return none$;
    }

    public HashMap<Tuple2<Seq<Expression>, Seq<Expression>>, Seq<PartitionDirectory>> cached() {
        return this.cached;
    }

    public void cached_$eq(HashMap<Tuple2<Seq<Expression>, Seq<Expression>>, Seq<PartitionDirectory>> x$1) {
        this.cached = x$1;
    }

    private SegmentDirectory getFileStatusBySeg(SegmentDirectory seg, FileStatusCache fsc) {
        SegmentDirectory segmentDirectory;
        LongRef startT = LongRef.create((long)System.currentTimeMillis());
        Path path = new Path(this.toPath(seg.segmentName(), seg.identifier()));
        FileSystem fs = path.getFileSystem(this.session().sparkContext().hadoopConfiguration());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Get segment filesystem: ").append(System.currentTimeMillis() - startT$1.elem).toString());
        startT.elem = System.currentTimeMillis();
        if (fs.isDirectory(path) && fs.exists(path)) {
            Option maybeStatuses = fsc.getLeafFiles(path);
            if (maybeStatuses.isDefined()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Get segment status from cache: ").append(System.currentTimeMillis() - startT$1.elem).toString());
                segmentDirectory = new SegmentDirectory(seg.segmentName(), seg.identifier(), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])maybeStatuses.get()));
            } else {
                FileStatus[] statuses = fs.listStatus(path);
                fsc.putLeafFiles(path, statuses);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Get segment status and cache: ").append(System.currentTimeMillis() - startT$1.elem).toString());
                segmentDirectory = new SegmentDirectory(seg.segmentName(), seg.identifier(), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
            }
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Segment path ").append(path.toString()).append(" not exists.").toString());
            segmentDirectory = new SegmentDirectory(seg.segmentName(), seg.identifier(), (Seq<FileStatus>)Nil$.MODULE$);
        }
        return segmentDirectory;
    }

    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Seq seq;
        if (this.cached().containsKey(new Tuple2(partitionFilters, dataFilters))) {
            return this.cached().get(new Tuple2(partitionFilters, dataFilters));
        }
        Predef$.MODULE$.require(this.isResolved());
        long startTime = System.nanoTime();
        Seq<Expression> timePartitionFilters = this.getSegmentFilter(dataFilters, this.timePartitionColumn());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Applying time partition filters: ").append(timePartitionFilters.mkString(",")).toString());
        LongRef startT = LongRef.create((long)System.currentTimeMillis());
        FileStatusCache fsc = ShardFileStatusCache$.MODULE$.getFileStatusCache(this.session());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Get file status cache: ").append(System.currentTimeMillis() - startT$2.elem).toString());
        Seq<SegmentDirectory> selected = this.afterPruning("segment", timePartitionFilters, this.segmentDirs(), (Function2<Seq<Expression>, Seq<SegmentDirectory>, Seq<SegmentDirectory>>)(Function2 & Serializable & scala.Serializable)(filters, segDirs) -> this.pruneSegments((Seq<Expression>)filters, (Seq<SegmentDirectory>)segDirs));
        startT.elem = System.currentTimeMillis();
        selected = (Seq<SegmentDirectory>)((ParIterableLike)((ParIterableLike)selected.par()).map((Function1 & Serializable & scala.Serializable)seg -> this.getFileStatusBySeg((SegmentDirectory)seg, fsc), (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$listFiles$5(x$11))).seq();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Get segment status: ").append(System.currentTimeMillis() - startT$2.elem).toString());
        selected = this.afterPruning("shard", dataFilters, selected, (Function2<Seq<Expression>, Seq<SegmentDirectory>, Seq<SegmentDirectory>>)(Function2 & Serializable & scala.Serializable)(filters, segDirs) -> this.pruneShards((Seq<Expression>)filters, (Seq<SegmentDirectory>)segDirs));
        this.shardSpec_$eq(this.genShardSpec(selected));
        long totalFileSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)selected.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.files(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.getLen()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("After files pruning, total file size is ").append(totalFileSize).toString());
        this.setShufflePartitions(totalFileSize, this.session(), this.cubeInstance.getConfig());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Files pruning in ").append((double)(System.nanoTime() - startTime) / (double)1000000).append(" ms").toString());
        if (selected.isEmpty()) {
            Seq value = (Seq)Nil$.MODULE$;
            this.cached().put((Tuple2<Seq<Expression>, Seq<Expression>>)new Tuple2(partitionFilters, dataFilters), (Seq<PartitionDirectory>)value);
            seq = value;
        } else {
            Seq value = (Seq)new .colon.colon((Object)new PartitionDirectory(InternalRow$.MODULE$.empty(), (Seq)selected.flatMap((Function1 & Serializable & scala.Serializable)x$14 -> x$14.files(), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$);
            this.cached().put((Tuple2<Seq<Expression>, Seq<Expression>>)new Tuple2(partitionFilters, dataFilters), (Seq<PartitionDirectory>)value);
            seq = value;
        }
        return seq;
    }

    private Seq<SegmentDirectory> afterPruning(String pruningType, Seq<Expression> specFilters, Seq<SegmentDirectory> inputs, Function2<Seq<Expression>, Seq<SegmentDirectory>, Seq<SegmentDirectory>> pruningFunc) {
        Seq seq;
        if (specFilters.isEmpty()) {
            seq = inputs;
        } else {
            Seq selected = inputs;
            try {
                long startTime = System.nanoTime();
                selected = (Seq)pruningFunc.apply(specFilters, inputs);
                long endTime = System.nanoTime();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(pruningType).append(" pruning in ").append((double)(endTime - startTime) / (double)1000000).append(" ms").toString());
            }
            catch (Throwable th) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error occurs when ").append(specFilters).append(", scan all ").append(pruningType).append("s.").toString(), th);
            }
            seq = selected;
        }
        return seq;
    }

    private Seq<Expression> getSegmentFilter(Seq<Expression> dataFilters, Attribute col) {
        return (Seq)((TraversableLike)((TraversableLike)dataFilters.map((Function1 & Serializable & scala.Serializable)x$15 -> this.extractSegmentFilter((Expression)x$15, col), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isDefined()))).map((Function1 & Serializable & scala.Serializable)x$17 -> (Expression)x$17.get(), Seq$.MODULE$.canBuildFrom());
    }

    private Option<Expression> extractSegmentFilter(Expression filter, Attribute col) {
        None$ none$;
        if (col == null) {
            return None$.MODULE$;
        }
        Expression expression = filter;
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            Option<Expression> leftChild = this.extractSegmentFilter(left, col);
            Option<Expression> rightChild = this.extractSegmentFilter(right, col);
            none$ = leftChild == None$.MODULE$ || rightChild == None$.MODULE$ ? None$.MODULE$ : new Some((Object)new Or((Expression)leftChild.get(), (Expression)rightChild.get()));
        } else if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            None$ leftChild = this.extractSegmentFilter(left, col);
            None$ rightChild = this.extractSegmentFilter(right, col);
            none$ = leftChild != None$.MODULE$ && rightChild != None$.MODULE$ ? new Some((Object)new And((Expression)leftChild.get(), (Expression)rightChild.get())) : (rightChild != None$.MODULE$ ? rightChild : (leftChild != None$.MODULE$ ? leftChild : None$.MODULE$));
        } else {
            none$ = filter.references().subsetOf(AttributeSet$.MODULE$.apply(col)) ? new Some((Object)filter) : None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<SegmentDirectory> pruneSegments(Seq<Expression> filters, Seq<SegmentDirectory> segDirs) {
        void var3_6;
        Seq seq;
        if (filters.isEmpty()) {
            seq = segDirs;
        } else {
            Seq translatedFilter = (Seq)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)filter -> this.convertCastFilter((Expression)filter), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)expr -> Option$.MODULE$.option2Iterable(ExpressionUtils$.MODULE$.translateFilter((Expression)expr)), Seq$.MODULE$.canBuildFrom());
            if (translatedFilter.isEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Can not use filters to prune segments.");
                seq = segDirs;
            } else {
                Filter reducedFilter = (Filter)translatedFilter.reduceLeft((Function2)org.apache.spark.sql.sources.And$.MODULE$);
                Seq pruned = (Seq)segDirs.filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$pruneSegments$4(this, reducedFilter, e)));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Selected files after segments pruning:").append(pruned.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.segmentName(), Seq$.MODULE$.canBuildFrom())).toString());
                seq = pruned;
            }
        }
        Seq filteredStatuses = seq;
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<SegmentDirectory> pruneShards(Seq<Expression> filters, Seq<SegmentDirectory> segDirs) {
        void var3_5;
        Seq seq;
        if (this.layoutEntity().getShardByColumns().size() != 1) {
            seq = segDirs;
        } else {
            Expression normalizedFiltersAndExpr = (Expression)filters.reduce((Function2)And$.MODULE$);
            Seq pruned = (Seq)segDirs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SegmentDirectory segmentDirectory = x0$1;
                if (segmentDirectory == null) {
                    throw new MatchError((Object)segmentDirectory);
                }
                String segName = segmentDirectory.segmentName();
                String segIdentifier = segmentDirectory.identifier();
                Seq<FileStatus> files = segmentDirectory.files();
                CubeSegment segment = $this.cubeInstance.getSegment(segName, SegmentStatusEnum.READY);
                short partitionNumber = Predef$.MODULE$.Short2short(segment.getCuboidShardNum(Predef$.MODULE$.long2Long(this.layoutEntity().getId())));
                Predef$.MODULE$.require(partitionNumber > 0, (Function0 & Serializable & scala.Serializable)() -> "Shards num with shard by col should greater than 0.");
                BitSet bitSet = this.getExpressionShards(normalizedFiltersAndExpr, this.shardByColumn().name(), partitionNumber);
                Seq selected = (Seq)files.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$pruneShards$3(bitSet, f)));
                SegmentDirectory segmentDirectory2 = new SegmentDirectory(segName, segIdentifier, (Seq<FileStatus>)selected);
                return segmentDirectory2;
            }, Seq$.MODULE$.canBuildFrom());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Selected files after shards pruning:").append(((TraversableOnce)((TraversableLike)pruned.flatMap((Function1 & Serializable & scala.Serializable)x$19 -> x$19.files(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.getPath().toString(), Seq$.MODULE$.canBuildFrom())).mkString(";")).toString());
            seq = pruned;
        }
        Seq filteredStatuses = seq;
        return var3_5;
    }

    private String[] inputFiles$lzycompute() {
        FilePruner filePruner = this;
        synchronized (filePruner) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.inputFiles = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.inputFiles;
    }

    public String[] inputFiles() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.inputFiles$lzycompute() : this.inputFiles;
    }

    private long sizeInBytes$lzycompute() {
        FilePruner filePruner = this;
        synchronized (filePruner) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.sizeInBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)this.cubeInstance.getSegments()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$sizeInBytes$1(x$21)))).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)FilePruner.$anonfun$sizeInBytes$2(x$22)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.sizeInBytes;
    }

    public long sizeInBytes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.sizeInBytes$lzycompute() : this.sizeInBytes;
    }

    public void refresh() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BitSet getExpressionShards(Expression expr, String shardColumnName, int numShards) {
        IsNull isNull;
        Expression a;
        BinaryComparison binaryComparison;
        Option option;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a2 = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a2 instanceof Attribute) {
                Attribute attribute = (Attribute)a2;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    String string = attribute.name();
                    String string2 = shardColumnName;
                    if (string == null) {
                        if (string2 == null) return FilePruner.getShardSetFromValue$1(attribute, v, numShards);
                    } else if (string.equals(string2)) {
                        return FilePruner.getShardSetFromValue$1(attribute, v, numShards);
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression a3 = in.value();
            Seq list = in.list();
            if (a3 instanceof Attribute) {
                Attribute attribute = (Attribute)a3;
                if (list.forall((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$getExpressionShards$3(x$23)))) {
                    String string = attribute.name();
                    String string3 = shardColumnName;
                    if (string == null) {
                        if (string3 == null) return FilePruner.getShardSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable & scala.Serializable)e -> e.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom()), numShards);
                    } else if (string.equals(string3)) {
                        return FilePruner.getShardSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable & scala.Serializable)e -> e.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom()), numShards);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression a4 = inSet.child();
            Set hset = inSet.hset();
            if (a4 instanceof Attribute) {
                Attribute attribute = (Attribute)a4;
                if (hset.forall((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)FilePruner.$anonfun$getExpressionShards$5(x$24)))) {
                    String string = attribute.name();
                    String string4 = shardColumnName;
                    if (string == null) {
                        if (string4 == null) return FilePruner.getShardSetFromIterable$1(attribute, (Iterable)hset.map((Function1 & Serializable & scala.Serializable)e -> Literal$.MODULE$.apply(e).eval(package$.MODULE$.EmptyRow()), scala.collection.immutable.Set$.MODULE$.canBuildFrom()), numShards);
                    } else if (string.equals(string4)) {
                        return FilePruner.getShardSetFromIterable$1(attribute, (Iterable)hset.map((Function1 & Serializable & scala.Serializable)e -> Literal$.MODULE$.apply(e).eval(package$.MODULE$.EmptyRow()), scala.collection.immutable.Set$.MODULE$.canBuildFrom()), numShards);
                    }
                }
            }
        }
        if (expression instanceof IsNull && (a = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a;
            String string = attribute.name();
            String string5 = shardColumnName;
            if (string == null) {
                if (string5 == null) return FilePruner.getShardSetFromValue$1(attribute, null, numShards);
            } else if (string.equals(string5)) {
                return FilePruner.getShardSetFromValue$1(attribute, null, numShards);
            }
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return this.getExpressionShards(left, shardColumnName, numShards).$amp(this.getExpressionShards(right, shardColumnName, numShards));
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.getExpressionShards(left, shardColumnName, numShards).$bar(this.getExpressionShards(right, shardColumnName, numShards));
        }
        BitSet matchedShards = new BitSet(numShards);
        matchedShards.setUntil(numShards);
        return matchedShards;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression convertCastFilter(Expression filter) {
        boolean bl = false;
        EqualTo equalTo = null;
        boolean bl2 = false;
        GreaterThan greaterThan = null;
        boolean bl3 = false;
        LessThan lessThan = null;
        boolean bl4 = false;
        GreaterThanOrEqual greaterThanOrEqual = null;
        boolean bl5 = false;
        LessThanOrEqual lessThanOrEqual = null;
        Expression expression = filter;
        if (expression instanceof EqualTo) {
            Cast cast;
            Expression a;
            bl = true;
            equalTo = (EqualTo)expression;
            Expression expression2 = equalTo.left();
            Expression expression3 = equalTo.right();
            if (expression2 instanceof Cast && (a = (cast = (Cast)expression2).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)a;
                if (expression3 instanceof Literal) {
                    Literal literal = (Literal)expression3;
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    return new EqualTo((Expression)attribute, (Expression)new Literal(v, t));
                }
            }
        }
        if (bl) {
            Expression expression4 = equalTo.left();
            Expression expression5 = equalTo.right();
            if (expression4 instanceof Literal) {
                Cast cast;
                Expression a;
                Literal literal = (Literal)expression4;
                Object v = literal.value();
                DataType t = literal.dataType();
                if (expression5 instanceof Cast && (a = (cast = (Cast)expression5).child()) instanceof Attribute) {
                    Attribute attribute = (Attribute)a;
                    return new EqualTo((Expression)new Literal(v, t), (Expression)attribute);
                }
            }
        }
        if (expression instanceof GreaterThan) {
            Cast cast;
            Expression a;
            bl2 = true;
            greaterThan = (GreaterThan)expression;
            Expression expression6 = greaterThan.left();
            Expression expression7 = greaterThan.right();
            if (expression6 instanceof Cast && (a = (cast = (Cast)expression6).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)a;
                if (expression7 instanceof Literal) {
                    Literal literal = (Literal)expression7;
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    return new GreaterThan((Expression)attribute, (Expression)new Literal(v, t));
                }
            }
        }
        if (bl2) {
            Expression expression8 = greaterThan.left();
            Expression expression9 = greaterThan.right();
            if (expression8 instanceof Literal) {
                Cast cast;
                Expression a;
                Literal literal = (Literal)expression8;
                Object v = literal.value();
                DataType t = literal.dataType();
                if (expression9 instanceof Cast && (a = (cast = (Cast)expression9).child()) instanceof Attribute) {
                    Attribute attribute = (Attribute)a;
                    return new GreaterThan((Expression)new Literal(v, t), (Expression)attribute);
                }
            }
        }
        if (expression instanceof LessThan) {
            Cast cast;
            Expression a;
            bl3 = true;
            lessThan = (LessThan)expression;
            Expression expression10 = lessThan.left();
            Expression expression11 = lessThan.right();
            if (expression10 instanceof Cast && (a = (cast = (Cast)expression10).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)a;
                if (expression11 instanceof Literal) {
                    Literal literal = (Literal)expression11;
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    return new LessThan((Expression)attribute, (Expression)new Literal(v, t));
                }
            }
        }
        if (bl3) {
            Expression expression12 = lessThan.left();
            Expression expression13 = lessThan.right();
            if (expression12 instanceof Literal) {
                Cast cast;
                Expression a;
                Literal literal = (Literal)expression12;
                Object v = literal.value();
                DataType t = literal.dataType();
                if (expression13 instanceof Cast && (a = (cast = (Cast)expression13).child()) instanceof Attribute) {
                    Attribute attribute = (Attribute)a;
                    return new LessThan((Expression)new Literal(v, t), (Expression)attribute);
                }
            }
        }
        if (expression instanceof GreaterThanOrEqual) {
            Cast cast;
            Expression a;
            bl4 = true;
            greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression expression14 = greaterThanOrEqual.left();
            Expression expression15 = greaterThanOrEqual.right();
            if (expression14 instanceof Cast && (a = (cast = (Cast)expression14).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)a;
                if (expression15 instanceof Literal) {
                    Literal literal = (Literal)expression15;
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    return new GreaterThanOrEqual((Expression)attribute, (Expression)new Literal(v, t));
                }
            }
        }
        if (bl4) {
            Expression expression16 = greaterThanOrEqual.left();
            Expression expression17 = greaterThanOrEqual.right();
            if (expression16 instanceof Literal) {
                Cast cast;
                Expression a;
                Literal literal = (Literal)expression16;
                Object v = literal.value();
                DataType t = literal.dataType();
                if (expression17 instanceof Cast && (a = (cast = (Cast)expression17).child()) instanceof Attribute) {
                    Attribute attribute = (Attribute)a;
                    return new GreaterThanOrEqual((Expression)new Literal(v, t), (Expression)attribute);
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            Cast cast;
            Expression a;
            bl5 = true;
            lessThanOrEqual = (LessThanOrEqual)expression;
            Expression expression18 = lessThanOrEqual.left();
            Expression expression19 = lessThanOrEqual.right();
            if (expression18 instanceof Cast && (a = (cast = (Cast)expression18).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)a;
                if (expression19 instanceof Literal) {
                    Literal literal = (Literal)expression19;
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    return new LessThanOrEqual((Expression)attribute, (Expression)new Literal(v, t));
                }
            }
        }
        if (bl5) {
            Expression expression20 = lessThanOrEqual.left();
            Expression expression21 = lessThanOrEqual.right();
            if (expression20 instanceof Literal) {
                Cast cast;
                Expression a;
                Literal literal = (Literal)expression20;
                Object v = literal.value();
                DataType t = literal.dataType();
                if (expression21 instanceof Cast && (a = (cast = (Cast)expression21).child()) instanceof Attribute) {
                    Attribute attribute = (Attribute)a;
                    return new LessThanOrEqual((Expression)new Literal(v, t), (Expression)attribute);
                }
            }
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return new Or(this.convertCastFilter(left), this.convertCastFilter(right));
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return new And(this.convertCastFilter(left), this.convertCastFilter(right));
        }
        if (!(expression instanceof Not)) return filter;
        Not not = (Not)expression;
        Expression child = not.child();
        return new Not(this.convertCastFilter(child));
    }

    public static final /* synthetic */ boolean $anonfun$segmentDirs$1(CubeSegment x$1) {
        return x$1.getStatus().equals((Object)SegmentStatusEnum.READY);
    }

    public static final /* synthetic */ boolean $anonfun$timePartitionSchema$1(TblColRef ref$1, ColumnDesc column) {
        return column.columnName().equals(ref$1.getName());
    }

    public static final /* synthetic */ boolean $anonfun$timePartitionSchema$2(Option id$1, StructField x$2) {
        String string = x$2.name();
        String string2 = String.valueOf(((ColumnDesc)id$1.get()).id());
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$genShardSpec$2(FilePruner $this, int shardNum$1, CubeSegment x$4) {
        return Predef$.MODULE$.Short2short(x$4.getCuboidShardNum(Predef$.MODULE$.long2Long($this.layoutEntity().getId()))) != shardNum$1;
    }

    public static final /* synthetic */ long $anonfun$genShardSpec$7(Seq x$7) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$7.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$genShardSpec$9(FilePruner $this, Tuple2 x$9) {
        return x$9._2$mcJ$sp() > $this.MAX_SHARDING_SIZE_PER_TASK();
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$5(SegmentDirectory x$11) {
        return x$11.files().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$pruneSegments$4(FilePruner $this, Filter reducedFilter$1, SegmentDirectory e) {
        boolean bl;
        SegmentRange.TSRange tsRange = $this.cubeInstance.getSegment(e.segmentName(), SegmentStatusEnum.READY).getTSRange();
        Filter filter = new SegFilters(tsRange.startValue(), tsRange.endValue(), $this.pattern()).foldFilter(reducedFilter$1);
        if (AlwaysTrue$.MODULE$.equals(filter)) {
            bl = true;
        } else if (AlwaysFalse$.MODULE$.equals(filter)) {
            bl = false;
        } else {
            throw new MatchError((Object)filter);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pruneShards$3(BitSet bitSet$1, FileStatus f) {
        int partitionId = FilePruner$.MODULE$.getPartitionId(f.getPath());
        return bitSet$1.get(partitionId);
    }

    public static final /* synthetic */ boolean $anonfun$sizeInBytes$1(CubeSegment x$21) {
        return x$21.getStatus().equals((Object)SegmentStatusEnum.READY);
    }

    public static final /* synthetic */ long $anonfun$sizeInBytes$2(CubeSegment x$22) {
        return x$22.getSizeKB() * 1024L;
    }

    private static final int getShardNumber$1(Attribute attr, Object v, int numShards$1) {
        return BucketingUtils$.MODULE$.getBucketIdFromValue(attr, numShards$1, v);
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet getShardSetFromIterable$1(Attribute attr, Iterable iter, int numShards$1) {
        void var3_3;
        BitSet matchedShards = new BitSet(numShards$1);
        ((IterableLike)iter.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)FilePruner.getShardNumber$1(attr, v, numShards$1)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)shardNum -> matchedShards.set(shardNum));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet getShardSetFromValue$1(Attribute attr, Object v, int numShards$1) {
        void var3_3;
        BitSet matchedShards = new BitSet(numShards$1);
        matchedShards.set(FilePruner.getShardNumber$1(attr, v, numShards$1));
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$getExpressionShards$3(Expression x$23) {
        return x$23 instanceof Literal;
    }

    public static final /* synthetic */ boolean $anonfun$getExpressionShards$5(Object x$24) {
        return x$24 instanceof Literal;
    }

    public FilePruner(CubeInstance cubeInstance, Cuboid cuboid, SparkSession session, Map<String, String> options) {
        this.cubeInstance = cubeInstance;
        this.cuboid = cuboid;
        this.session = session;
        this.options = options;
        FileIndex.$init$((FileIndex)this);
        Logging.$init$((Logging)this);
        ResetShufflePartition.$init$(this);
        this.MAX_SHARDING_SIZE_PER_TASK = cubeInstance.getConfig().getMaxShardingSizeMBPerTask() * 1024 * 1024;
        this.layoutEntity = MetadataConverter$.MODULE$.toLayoutEntity(cubeInstance, cuboid);
        this.dataSchema = StructType$.MODULE$.apply((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.layoutEntity().getOrderedDimensions().values()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> new StructField(Integer.toString(column.id()), column.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$plus((GenTraversableOnce)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.layoutEntity().getOrderedMeasures()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new StructField(((Integer)entry._1()).toString(), SparkTypeUtil$.MODULE$.generateFunctionReturnDataType((FunctionDesc)entry._2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom()));
        this.isResolved = false;
        this.shardSpec = None$.MODULE$;
        this.cached = new HashMap();
    }
}

