/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.asyncprofiler;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.ZipFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProfilerUtils {
    private final Logger logger = LoggerFactory.getLogger(AsyncProfilerUtils.class);
    private static AsyncProfilerUtils asyncProfilerUtils;
    CountDownLatch cachedResult;
    long resultCollectionTimeout;
    File localCacheDir;

    public static synchronized AsyncProfilerUtils getInstance() {
        if (asyncProfilerUtils == null) {
            asyncProfilerUtils = new AsyncProfilerUtils();
        }
        return asyncProfilerUtils;
    }

    public void build(CountDownLatch countDownLatch) {
        this.cachedResult = countDownLatch;
    }

    public void build(File localCacheDir) {
        this.localCacheDir = localCacheDir;
    }

    public void build(long resultCollectionTimeout, File localCacheDir) {
        this.resultCollectionTimeout = resultCollectionTimeout;
        this.localCacheDir = localCacheDir;
    }

    public void waitForResult(OutputStream outStream) throws InterruptedException, IOException {
        if (!this.cachedResult.await(this.resultCollectionTimeout, TimeUnit.MILLISECONDS)) {
            this.logger.warn("timeout while waiting for profile result");
        }
        this.logger.debug("profiler stopped and result dumped to {}", (Object)this.localCacheDir);
        ZipFileUtils.compressZipFile((String)this.localCacheDir.getAbsolutePath(), (OutputStream)outStream);
    }

    public String suffix(String content) {
        if (content.startsWith("<!DOCTYPE html>")) {
            return ".html";
        }
        return "";
    }

    public void cacheExecutorResult(String content, String executorId) {
        this.cacheResult(content, "executor-" + executorId + this.suffix(content));
        this.logger.debug("cached result from executor-{}", (Object)executorId);
        this.cachedResult.countDown();
    }

    public void cacheDriverResult(String content) {
        this.cacheResult(content, "driver" + this.suffix(content));
        this.logger.debug("cached result from driver");
        this.cachedResult.countDown();
    }

    public void cacheResult(String content, String destPath) {
        Path path = new File(this.localCacheDir.getAbsolutePath(), destPath).toPath();
        try {
            Files.write(path, content.getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (Exception e) {
            this.logger.error("error writing dumped data to disk", (Throwable)e);
        }
    }

    public void cleanLocalCache() {
        try {
            FileUtils.cleanDirectory((File)this.localCacheDir);
        }
        catch (Exception e) {
            this.logger.error("error clean cache directory", (Throwable)e);
        }
    }
}

