/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.plugin.asyncprofiler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.asyncprofiler.AsyncProfilerTool$;
import org.apache.kylin.common.asyncprofiler.AsyncProfilerUtils;
import org.apache.kylin.common.asyncprofiler.Message$;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.plugin.asyncprofiler.ProfilerStatus$;
import org.apache.spark.SparkContext;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u001c9\u0001\rCQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004h\u0001\u0001\u0006I!\u0019\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019\u0001\b\u0001)A\u0005U\"9\u0011\u000f\u0001b\u0001\n\u0013\u0001\u0007B\u0002:\u0001A\u0003%\u0011\rC\u0004t\u0001\t\u0007I\u0011\u00021\t\rQ\u0004\u0001\u0015!\u0003b\u0011%)\b\u00011AA\u0002\u0013%a\u000fC\u0005{\u0001\u0001\u0007\t\u0019!C\u0005w\"Q\u00111\u0001\u0001A\u0002\u0003\u0005\u000b\u0015B<\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\u0005\u001d\u0001\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0011!\t)\u0003\u0001Q!\n\u0005%\u0001\"CA\u0014\u0001\u0001\u0007I\u0011BA\u0015\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u00028\u0001\u0001\u000b\u0015BA\u0016\u0011%\tI\u0004\u0001a\u0001\n\u0013\tI\u0003C\u0005\u0002<\u0001\u0001\r\u0011\"\u0003\u0002>!A\u0011\u0011\t\u0001!B\u0013\tY\u0003C\u0006\u0002D\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0003bCA,\u0001\u0001\u0007\t\u0019!C\u0005\u00033B1\"!\u0018\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H!Y\u0011q\f\u0001A\u0002\u0003\u0007I\u0011BA1\u0011-\tY\u0007\u0001a\u0001\u0002\u0004%I!!\u001c\t\u0017\u0005E\u0004\u00011A\u0001B\u0003&\u00111\r\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003kB\u0001\"a\u001f\u0001A\u0003%\u0011q\u000f\u0005\n\u0003{\u0002!\u0019!C\u0005\u0003\u007fB\u0001\"a\"\u0001A\u0003%\u0011\u0011\u0011\u0005\f\u0003\u0013\u0003\u0001\u0019!a\u0001\n\u0003\tY\tC\u0006\u0002\u001e\u0002\u0001\r\u00111A\u0005\u0002\u0005}\u0005bCAR\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bC1\"!*\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\f\"Y\u0011q\u0015\u0001A\u0002\u0003\u0007I\u0011AAU\u0011-\ti\u000b\u0001a\u0001\u0002\u0003\u0006K!!$\t\u0017\u0005=\u0006\u00011AA\u0002\u0013\u0005\u00111\u0012\u0005\f\u0003c\u0003\u0001\u0019!a\u0001\n\u0003\t\u0019\fC\u0006\u00028\u0002\u0001\r\u0011!Q!\n\u00055\u0005\"CA]\u0001\u0001\u0007I\u0011AA\u0015\u0011%\tY\f\u0001a\u0001\n\u0003\ti\f\u0003\u0005\u0002B\u0002\u0001\u000b\u0015BA\u0016\u0011%\t\u0019\r\u0001b\u0001\n\u0013\t)\r\u0003\u0005\u0002V\u0002\u0001\u000b\u0011BAd\u0011%\t9\u000e\u0001b\u0001\n\u0013\tI\u000e\u0003\u0005\u0002b\u0002\u0001\u000b\u0011BAn\u0011\u001d\t\u0019\u000f\u0001C!\u0003KDq!!@\u0001\t\u0003\ty\u0010C\u0004\u0003\u0004\u0001!\tA!\u0002\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!1\u0004\u0001\u0005B\t\u0015\u0001b\u0002B\u000f\u0001\u0011\u0005!q\u0004\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0005y\u0011U/\u001b7e\u0003NLhn\u0019)s_\u001aLG.\u001a:Ee&4XM\u001d)mk\u001eLgN\u0003\u0002:u\u0005i\u0011m]=oGB\u0014xNZ5mKJT!a\u000f\u001f\u0002\rAdWoZ5o\u0015\tid(A\u0003ls2LgN\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0011cU\u000b\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\r=\u0013'.Z2u!\ti5+D\u0001O\u0015\tYtJ\u0003\u0002Q#\u0006\u0019\u0011\r]5\u000b\u0005Is\u0014!B:qCJ\\\u0017B\u0001+O\u00051!%/\u001b<feBcWoZ5o!\t1\u0016,D\u0001X\u0015\tA\u0016+\u0001\u0005j]R,'O\\1m\u0013\tQvKA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005i\u0006C\u00010\u0001\u001b\u0005A\u0014\u0001E2iK\u000e\\\u0017N\\4J]R,'O^1m+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001c'\u0001\u0002'p]\u001e\f\u0011c\u00195fG.LgnZ%oi\u0016\u0014h/\u00197!\u00035awnY1m\u0007\u0006\u001c\u0007.\u001a#jeV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002n\u0011\u0006\u0011\u0011n\\\u0005\u0003_2\u0014AAR5mK\u0006qAn\\2bY\u000e\u000b7\r[3ESJ\u0004\u0013a\u0006:fgVdGoQ8mY\u0016\u001cG/[8o)&lWm\\;u\u0003a\u0011Xm];mi\u000e{G\u000e\\3di&|g\u000eV5nK>,H\u000fI\u0001\u0011aJ|g-\u001b7j]\u001e$\u0016.\\3pkR\f\u0011\u0003\u001d:pM&d\u0017N\\4US6,w.\u001e;!\u0003Y!\u0018.\\3pkR,\u00050Z2vi&|g\u000e\u00165sK\u0006$W#A<\u0011\u0005\u0015C\u0018BA=G\u0005\u0019!\u0006N]3bI\u0006QB/[7f_V$X\t_3dkRLwN\u001c+ie\u0016\fGm\u0018\u0013fcR\u0011Ap \t\u0003EvL!A`2\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003Y\u0011\u0011!a\u0001o\u0006\u0019\u0001\u0010J\u0019\u0002/QLW.Z8vi\u0016CXmY;uS>tG\u000b\u001b:fC\u0012\u0004\u0013a\u00038fqR\u001cu.\\7b]\u0012,\"!!\u0003\u0011\t\u0005-\u0011\u0011\u0004\b\u0005\u0003\u001b\t)\u0002E\u0002\u0002\u0010\rl!!!\u0005\u000b\u0007\u0005M!)\u0001\u0004=e>|GOP\u0005\u0004\u0003/\u0019\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u0018\r\fqB\\3yi\u000e{W.\\1oI~#S-\u001d\u000b\u0004y\u0006\r\u0002\"CA\u0001\u001d\u0005\u0005\t\u0019AA\u0005\u00031qW\r\u001f;D_6l\u0017M\u001c3!\u0003\u001d\u0011XO\u001c8j]\u001e,\"!a\u000b\u0011\u0007\t\fi#C\u0002\u00020\r\u0014qAQ8pY\u0016\fg.A\u0006sk:t\u0017N\\4`I\u0015\fHc\u0001?\u00026!I\u0011\u0011A\t\u0002\u0002\u0003\u0007\u00111F\u0001\teVtg.\u001b8hA\u00051A-^7qK\u0012\f!\u0002Z;na\u0016$w\fJ3r)\ra\u0018q\b\u0005\n\u0003\u0003!\u0012\u0011!a\u0001\u0003W\tq\u0001Z;na\u0016$\u0007%\u0001\u0007dC\u000eDW\r\u001a*fgVdG/\u0006\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013AC2p]\u000e,(O]3oi*\u0019\u0011\u0011\u000b%\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\nYE\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\u0002!\r\f7\r[3e%\u0016\u001cX\u000f\u001c;`I\u0015\fHc\u0001?\u0002\\!I\u0011\u0011A\f\u0002\u0002\u0003\u0007\u0011qI\u0001\u000eG\u0006\u001c\u0007.\u001a3SKN,H\u000e\u001e\u0011\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\u0016\u0005\u0005\r\u0004\u0003BA3\u0003Oj\u0011!U\u0005\u0004\u0003S\n&\u0001D*qCJ\\7i\u001c8uKb$\u0018\u0001E:qCJ\\7i\u001c8uKb$x\fJ3r)\ra\u0018q\u000e\u0005\n\u0003\u0003Q\u0012\u0011!a\u0001\u0003G\nQb\u001d9be.\u001cuN\u001c;fqR\u0004\u0013!\u0004$M\u0003\u001e{f)\u0013'F?\u0012K%+\u0006\u0002\u0002xA\u0019Q)!\u001f\n\u0007\u0005ma)\u0001\bG\u0019\u0006;uLR%M\u000b~#\u0015J\u0015\u0011\u0002\u0017\u0019d\u0017m\u001a$jY\u0016$\u0015N]\u000b\u0003\u0003\u0003\u0003RAYAB\u0003oJ1!!\"d\u0005\u0019y\u0005\u000f^5p]\u0006aa\r\\1h\r&dW\rR5sA\u0005q\u0011m\u0019;j_:4\u0015\u000e\\3QCRDWCAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b!AZ:\u000b\u0007\u0005]e(\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u00037\u000b\tJ\u0001\u0003QCRD\u0017AE1di&|gNR5mKB\u000bG\u000f[0%KF$2\u0001`AQ\u0011%\t\t!IA\u0001\u0002\u0004\ti)A\bbGRLwN\u001c$jY\u0016\u0004\u0016\r\u001e5!\u00039\u0019H/\u0019;vg\u001aKG.\u001a(b[\u0016\f!c\u001d;biV\u001ch)\u001b7f\u001d\u0006lWm\u0018\u0013fcR\u0019A0a+\t\u0013\u0005\u0005A%!AA\u0002\u00055\u0015aD:uCR,8OR5mK:\u000bW.\u001a\u0011\u0002\u0019\u0011,X\u000e\u001d$jY\u0016t\u0015-\\3\u0002!\u0011,X\u000e\u001d$jY\u0016t\u0015-\\3`I\u0015\fHc\u0001?\u00026\"I\u0011\u0011A\u0014\u0002\u0002\u0003\u0007\u0011QR\u0001\u000eIVl\u0007OR5mK:\u000bW.\u001a\u0011\u0002\u000f]|'o[5oO\u0006Yqo\u001c:lS:<w\fJ3r)\ra\u0018q\u0018\u0005\n\u0003\u0003Q\u0013\u0011!a\u0001\u0003W\t\u0001b^8sW&tw\rI\u0001\u0013CNLhn\u0019)s_\u001aLG.\u001a:Vi&d7/\u0006\u0002\u0002HB!\u0011\u0011ZAi\u001b\t\tYMC\u0002:\u0003\u001bT1!a4=\u0003\u0019\u0019w.\\7p]&!\u00111[Af\u0005I\t5/\u001f8d!J|g-\u001b7feV#\u0018\u000e\\:\u0002'\u0005\u001c\u0018P\\2Qe>4\u0017\u000e\\3s+RLGn\u001d\u0011\u00021M\u001c\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0006\u0002\u0002\\B!\u0011\u0011JAo\u0013\u0011\ty.a\u0013\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-A\rtG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013\u0001B5oSR$b!a:\u0002p\u0006M\b\u0003CAu\u0003W\fI!!\u0003\u000e\u0005\u0005=\u0013\u0002BAw\u0003\u001f\u00121!T1q\u0011\u001d\t\t\u0010\ra\u0001\u0003G\n!a]2\t\u000f\u0005U\b\u00071\u0001\u0002x\u0006i\u0001\u000f\\;hS:\u001cuN\u001c;fqR\u00042!TA}\u0013\r\tYP\u0014\u0002\u000e!2,x-\u001b8D_:$X\r\u001f;\u0002\u001b%t\u0017\u000e\u001e#je\u0016\u001cGo\u001c:z)\ra(\u0011\u0001\u0005\b\u0003{\n\u0004\u0019AA\u0005\u0003-\u0019\u0007.Z2l\u0003\u000e$\u0018n\u001c8\u0015\u0003q\fqA]3dK&4X\r\u0006\u0003\u0003\f\tE\u0001c\u00012\u0003\u000e%\u0019!qB2\u0003\r\u0005s\u0017PU3g\u0011\u001d\u0011\u0019b\ra\u0001\u0005+\tq!\\3tg\u0006<W\rE\u0002c\u0005/I1A!\u0007d\u0005\r\te._\u0001\tg\",H\u000fZ8x]\u0006)1\u000f^1siR\u0019AP!\t\t\u000f\t\rR\u00071\u0001\u0002\n\u00051\u0001/\u0019:b[N\fA\u0001Z;naR\u0019AP!\u000b\t\u000f\t\rb\u00071\u0001\u0002\n\u0001")
public class BuildAsyncProfilerDriverPlugin
implements DriverPlugin,
Logging {
    private final long checkingInterval;
    private final File localCacheDir;
    private final long resultCollectionTimeout;
    private final long profilingTimeout;
    private Thread timeoutExecutionThread;
    private String nextCommand;
    private boolean running;
    private boolean dumped;
    private CountDownLatch cachedResult;
    private SparkContext sparkContext;
    private final String FLAG_FILE_DIR;
    private final Option<String> flagFileDir;
    private Path actionFilePath;
    private Path statusFileName;
    private Path dumpFileName;
    private boolean working;
    private final AsyncProfilerUtils asyncProfilerUtils;
    private final ScheduledExecutorService scheduledExecutorService;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void registerMetrics(String x$1, PluginContext x$2) {
        super.registerMetrics(x$1, x$2);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long checkingInterval() {
        return this.checkingInterval;
    }

    private File localCacheDir() {
        return this.localCacheDir;
    }

    private long resultCollectionTimeout() {
        return this.resultCollectionTimeout;
    }

    private long profilingTimeout() {
        return this.profilingTimeout;
    }

    private Thread timeoutExecutionThread() {
        return this.timeoutExecutionThread;
    }

    private void timeoutExecutionThread_$eq(Thread x$1) {
        this.timeoutExecutionThread = x$1;
    }

    private String nextCommand() {
        return this.nextCommand;
    }

    private void nextCommand_$eq(String x$1) {
        this.nextCommand = x$1;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private boolean dumped() {
        return this.dumped;
    }

    private void dumped_$eq(boolean x$1) {
        this.dumped = x$1;
    }

    private CountDownLatch cachedResult() {
        return this.cachedResult;
    }

    private void cachedResult_$eq(CountDownLatch x$1) {
        this.cachedResult = x$1;
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    private String FLAG_FILE_DIR() {
        return this.FLAG_FILE_DIR;
    }

    private Option<String> flagFileDir() {
        return this.flagFileDir;
    }

    public Path actionFilePath() {
        return this.actionFilePath;
    }

    public void actionFilePath_$eq(Path x$1) {
        this.actionFilePath = x$1;
    }

    public Path statusFileName() {
        return this.statusFileName;
    }

    public void statusFileName_$eq(Path x$1) {
        this.statusFileName = x$1;
    }

    public Path dumpFileName() {
        return this.dumpFileName;
    }

    public void dumpFileName_$eq(Path x$1) {
        this.dumpFileName = x$1;
    }

    public boolean working() {
        return this.working;
    }

    public void working_$eq(boolean x$1) {
        this.working = x$1;
    }

    private AsyncProfilerUtils asyncProfilerUtils() {
        return this.asyncProfilerUtils;
    }

    private ScheduledExecutorService scheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public Map<String, String> init(SparkContext sc, PluginContext pluginContext) {
        Object object;
        this.sparkContext_$eq(sc);
        if (this.flagFileDir().isEmpty()) {
            this.working_$eq(false);
            this.log().error("Missing system parameter spark.profiler.flags.dir");
            object = BoxedUnit.UNIT;
        } else {
            this.actionFilePath_$eq(new Path(new StringBuilder(7).append((String)this.flagFileDir().get()).append("/action").toString()));
            this.statusFileName_$eq(new Path(new StringBuilder(7).append((String)this.flagFileDir().get()).append("/status").toString()));
            this.dumpFileName_$eq(new Path(new StringBuilder(12).append((String)this.flagFileDir().get()).append("/dump.tar.gz").toString()));
            this.initDirectory((String)this.flagFileDir().get());
            Runnable profile = new Runnable(this){
                private final /* synthetic */ BuildAsyncProfilerDriverPlugin $outer;

                public void run() {
                    this.$outer.checkAction();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            String deployMode = sc.getConf().get("spark.submit.deployMode", "");
            this.log().info("Current spark.submit.deployMode: {}", new Object[]{deployMode});
            AsyncProfilerTool$.MODULE$.loadAsyncProfilerLib(deployMode.equals("client"));
            this.log().info(new StringBuilder(22).append("AsyncProfiler status: ").append(AsyncProfilerTool$.MODULE$.status()).toString());
            object = this.scheduledExecutorService().scheduleWithFixedDelay(profile, 0L, this.checkingInterval(), TimeUnit.MILLISECONDS);
        }
        return super.init(sc, pluginContext);
    }

    public void initDirectory(String flagFileDir) {
        Path flagFileDirPath;
        FileSystem fs = HadoopUtil.getFileSystem((String)flagFileDir);
        Object object = !fs.exists(flagFileDirPath = new Path(flagFileDir)) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(flagFileDirPath)) : BoxedUnit.UNIT;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(flagFileDirPath))).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)fs.delete(file.getPath(), true)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)Message$.MODULE$.createDriverMessage(Message$.MODULE$.NOP(), Message$.MODULE$.createDriverMessage$default$2()), (Path)this.actionFilePath());
        HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.IDLE(), (Path)this.statusFileName());
    }

    public void checkAction() {
        block6: {
            try {
                FileSystem fs = HadoopUtil.getFileSystem((String)((String)this.flagFileDir().get()));
                String reply = HadoopUtil.readStringFromHdfs((FileSystem)fs, (Path)this.actionFilePath());
                Tuple3<String, String, String> tuple3 = Message$.MODULE$.processMessage(reply);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                String command = (String)tuple3._1();
                String param = (String)tuple3._3();
                Tuple2 tuple2 = new Tuple2((Object)command, (Object)param);
                Tuple2 tuple22 = tuple2;
                String command2 = (String)tuple22._1();
                String param2 = (String)tuple22._2();
                String string = command2;
                String string2 = Message$.MODULE$.START();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null) && !this.running()) {
                    this.start(param2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                String string4 = Message$.MODULE$.STOP();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null) && this.running()) {
                    this.dump(param2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                String string6 = Message$.MODULE$.DUMP();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && !this.dumped()) {
                    this.dump(param2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "error while communication/profiling", e);
            }
        }
    }

    public Object receive(Object message) {
        String string;
        Tuple3<String, String, String> tuple3 = Message$.MODULE$.processMessage(message.toString());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String command = (String)tuple3._1();
        String executorId = (String)tuple3._2();
        String param = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)command, (Object)executorId, (Object)param);
        Tuple3 tuple33 = tuple32;
        String command2 = (String)tuple33._1();
        String executorId2 = (String)tuple33._2();
        String param2 = (String)tuple33._3();
        String string2 = command2;
        String string3 = Message$.MODULE$.NEXT_COMMAND();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = this.nextCommand();
        } else {
            String string5 = Message$.MODULE$.RESULT();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.asyncProfilerUtils().cacheExecutorResult(param2, executorId2);
                string = "";
            } else {
                string = "";
            }
        }
        return string;
    }

    public void shutdown() {
        FileSystem fs = HadoopUtil.getFileSystem((Path)this.statusFileName());
        HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.CLOSED(), (Path)this.statusFileName());
        ExecutorServiceUtil.shutdownGracefully((ExecutorService)this.scheduledExecutorService(), (int)3);
        super.shutdown();
    }

    public void start(String params) {
        String startParam = (String)Option$.MODULE$.apply((Object)params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "start,event=cpu");
        AsyncProfilerTool$ asyncProfilerTool$ = AsyncProfilerTool$.MODULE$;
        synchronized (asyncProfilerTool$) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler start");
            this.running_$eq(true);
            this.dumped_$eq(false);
            this.nextCommand_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.START(), startParam));
            AsyncProfilerTool$.MODULE$.start(startParam);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler started");
            FileSystem fs = HadoopUtil.getFileSystem((Path)this.statusFileName());
            fs.delete(this.dumpFileName(), true);
            HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.RUNNING(), (Path)this.statusFileName());
            this.timeoutExecutionThread_$eq(new Thread(() -> {
                try {
                    Thread.sleep(this.profilingTimeout());
                }
                catch (InterruptedException interruptedException) {
                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler stopped normally, timeout thread interrupted and exit");
                    Thread.currentThread().interrupt();
                }
                if (!Thread.interrupted()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("profiling timeout after ").append(this.profilingTimeout()).append("ms, stopping profiling").toString());
                    AsyncProfilerTool$ asyncProfilerTool$ = AsyncProfilerTool$.MODULE$;
                    synchronized (asyncProfilerTool$) {
                        if (this.running()) {
                            this.running_$eq(false);
                            this.nextCommand_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.STOP(), Message$.MODULE$.createDriverMessage$default$2()));
                            AsyncProfilerTool$.MODULE$.stop();
                            HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.STOPPED(), (Path)this.statusFileName());
                            HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)Message$.MODULE$.createDriverMessage(Message$.MODULE$.NOP(), Message$.MODULE$.createDriverMessage$default$2()), (Path)this.actionFilePath());
                        }
                    }
                }
            }));
            this.timeoutExecutionThread().start();
        }
    }

    public void dump(String params) {
        block11: {
            String dumpParam = (String)Option$.MODULE$.apply((Object)params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "flamegraph");
            AsyncProfilerTool$ asyncProfilerTool$ = AsyncProfilerTool$.MODULE$;
            synchronized (asyncProfilerTool$) {
                block9: {
                    if (this.dumped()) break block9;
                    if (this.running()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler stop");
                        this.running_$eq(false);
                        this.timeoutExecutionThread().interrupt();
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiling is not started");
                    }
                    this.dumped_$eq(true);
                    this.asyncProfilerUtils().cleanLocalCache();
                    this.cachedResult_$eq(new CountDownLatch(this.sparkContext().getExecutorMemoryStatus().size()));
                    this.asyncProfilerUtils().build(this.cachedResult());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("expecting ").append(this.cachedResult().getCount()).append(" to be collected").toString());
                    this.nextCommand_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.DUMP(), dumpParam));
                    this.asyncProfilerUtils().cacheDriverResult(AsyncProfilerTool$.MODULE$.dump(dumpParam));
                    FileSystem fs = HadoopUtil.getFileSystem((Path)this.statusFileName());
                    try (FSDataOutputStream outStream = null;){
                        outStream = fs.create(this.dumpFileName());
                        this.asyncProfilerUtils().waitForResult((OutputStream)outStream);
                    }
                    HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.DUMPED(), (Path)this.statusFileName());
                    break block11;
                }
                return;
            }
        }
    }

    public BuildAsyncProfilerDriverPlugin() {
        Logging.$init$((Logging)this);
        this.checkingInterval = 1000L;
        this.localCacheDir = Files.createTempDirectory("ke-build-async-profiler-result-", new FileAttribute[0]).toFile();
        this.localCacheDir().deleteOnExit();
        this.resultCollectionTimeout = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.props().get("spark.profiler.collection.timeout").getOrElse((Function0 & Serializable & scala.Serializable)() -> "60000"))).toLong();
        this.profilingTimeout = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.props().get("spark.profiler.profiling.timeout").getOrElse((Function0 & Serializable & scala.Serializable)() -> "300000"))).toLong();
        this.nextCommand = Message$.MODULE$.createDriverMessage(Message$.MODULE$.NOP(), Message$.MODULE$.createDriverMessage$default$2());
        this.running = false;
        this.dumped = false;
        this.FLAG_FILE_DIR = "spark.profiler.flagsDir";
        this.flagFileDir = package$.MODULE$.props().get(this.FLAG_FILE_DIR());
        this.working = true;
        this.asyncProfilerUtils = AsyncProfilerUtils.getInstance();
        this.asyncProfilerUtils().build(this.resultCollectionTimeout(), this.localCacheDir());
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("profiler-action-check-%d").build());
    }
}

