/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.spark.common.logging;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.spark.common.logging.AbstractHdfsLogAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.spark.SparkEnv;

@Plugin(name="ExecutorHdfsRollingAppender", category="Core", elementType="appender", printObject=true)
public class SparkExecutorHdfsRollingLogAppender
extends AbstractHdfsLogAppender {
    String logPath;
    String executorId;
    boolean logPathInit = false;
    int rollingPeriod = 5;
    private long rollingByteSize;
    private String metadataId;
    private String category;
    private String identifier;
    private String jobName;
    private String project;
    private String jobTimeStamp;

    protected SparkExecutorHdfsRollingLogAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, Property[] properties, AbstractHdfsLogAppender.HdfsManager manager) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
    }

    @PluginFactory
    public static SparkExecutorHdfsRollingLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="workingDir") String workingDir, @PluginAttribute(value="metadataId") String metadataId, @PluginAttribute(value="category") String category, @PluginAttribute(value="identifier") String identifier, @PluginAttribute(value="jobName") String jobName, @PluginAttribute(value="project") String project, @PluginAttribute(value="jobTimeStamp") String jobTimeStamp, @PluginAttribute(value="rollingPeriod") int rollingPeriod, @PluginAttribute(value="logQueueCapacity") int logQueueCapacity, @PluginAttribute(value="flushInterval") int flushInterval, @PluginAttribute(value="rollingByteSize") long rollingByteSize, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Properties") Property[] properties) {
        AbstractHdfsLogAppender.HdfsManager manager = new AbstractHdfsLogAppender.HdfsManager(name, layout);
        SparkExecutorHdfsRollingLogAppender appender = new SparkExecutorHdfsRollingLogAppender(name, layout, filter, false, false, properties, manager);
        appender.setWorkingDir(workingDir);
        appender.setMetadataId(metadataId);
        appender.setCategory(category);
        appender.setIdentifier(identifier);
        appender.setJobName(jobName);
        appender.setProject(project);
        appender.setRollingByteSize(rollingByteSize);
        if (appender.getRollingByteSize() == 0L) {
            appender.setRollingByteSize(524288000L);
        }
        appender.setJobTimeStamp(jobTimeStamp);
        appender.setRollingPeriod(rollingPeriod);
        appender.setLogQueueCapacity(logQueueCapacity);
        appender.setFlushInterval(flushInterval);
        return appender;
    }

    @Override
    String getAppenderName() {
        return "SparkExecutorHdfsRollingLogAppender";
    }

    @Override
    public void init() {
        StatusLogger.getLogger().warn("metadataIdentifier -> {}", (Object)this.getMetadataId());
        StatusLogger.getLogger().warn("category -> {}", (Object)this.getCategory());
        StatusLogger.getLogger().warn("identifier -> {}", (Object)this.getIdentifier());
        if (null != this.getProject()) {
            StatusLogger.getLogger().warn("project -> {}", (Object)this.getProject());
        }
        if (null != this.getJobName()) {
            StatusLogger.getLogger().warn("jobName -> {}", (Object)this.getJobName());
        }
    }

    @Override
    boolean isSkipCheckAndFlushLog() {
        if (SparkEnv.get() == null && StringUtils.isBlank((CharSequence)this.executorId)) {
            StatusLogger.getLogger().warn("Waiting for spark executor to start");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                StatusLogger.getLogger().error("Waiting for spark executor starting is interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    @Override
    void doWriteLog(int size, List<LogEvent> transaction) throws IOException, InterruptedException {
        if (!this.logPathInit) {
            this.setLogPath(this.getInitLogPath());
            this.logPathInit = true;
        }
        UserGroupInformation ugi = this.getUGI();
        this.initFileSystemWithToken(ugi);
        if (this.needRollingFile(this.getLogPath(), this.getRollingByteSize())) {
            StatusLogger.getLogger().debug("current log file size > {}, need to rolling", (Object)this.getRollingByteSize());
            this.setLogPath(this.updateOutPutPath(this.getLogPath()));
        }
        if (!this.isWriterInited()) {
            Path file = new Path(this.getLogPath());
            if (ugi != null) {
                ugi.doAs(() -> {
                    if (!this.initHdfsWriter(file, new Configuration())) {
                        StatusLogger.getLogger().error("Failed to init the hdfs writer!");
                    }
                    return null;
                });
            } else if (!this.initHdfsWriter(file, new Configuration())) {
                StatusLogger.getLogger().error("Failed to init the hdfs writer!");
            }
        }
        while (size > 0) {
            LogEvent loggingEvent = this.getLogBufferQue().take();
            transaction.add(loggingEvent);
            this.writeLogEvent(loggingEvent);
            --size;
        }
    }

    private UserGroupInformation getUGI() throws IOException {
        String sparkuser = System.getenv("SPARK_USER");
        String user = System.getenv("USER");
        StatusLogger.getLogger().warn(" out login user is {} SPARK_USER is {} USER is {}", (Object)UserGroupInformation.getLoginUser(), (Object)sparkuser, (Object)user);
        return SparkEnv.getUGI();
    }

    private void initFileSystemWithToken(UserGroupInformation ugi) throws IOException, InterruptedException {
        if (ObjectUtils.isEmpty((Object)ugi)) {
            StatusLogger.getLogger().warn("UserGroupInformation is null");
            return;
        }
        ugi.doAs(() -> {
            this.getFileSystem();
            return null;
        });
    }

    @Override
    String getLogPathAfterRolling(String logPath) {
        Path pathProcess = new Path(logPath);
        return String.format(Locale.ROOT, "%s/executor-%s.%s.log_processing", pathProcess.getParent().toString(), this.executorId, System.currentTimeMillis());
    }

    @Override
    String getLogPathRollingDone(String logPath) {
        return StringUtils.replace((String)logPath, (String)"_processing", (String)"");
    }

    private String getInitLogPath() {
        if (StringUtils.isBlank((CharSequence)this.executorId)) {
            this.executorId = SparkEnv.get() != null ? SparkEnv.get().executorId() : UUID.randomUUID().toString();
            StatusLogger.getLogger().warn("executorId set to {}", (Object)this.executorId);
        }
        switch (this.getCategory()) {
            case "streaming_job": {
                return String.format(Locale.ROOT, "%s/%s/%s/executor-%s.%s.log_processing", this.getRootPathName(), this.getIdentifier(), this.getJobTimeStamp(), this.executorId, this.getJobTimeStamp());
            }
        }
        throw new IllegalArgumentException("illegal category: " + this.getCategory());
    }

    @VisibleForTesting
    String getRootPathName() {
        switch (this.getCategory()) {
            case "streaming_job": {
                return String.format(Locale.ROOT, "%s/streaming/spark_logs/%s", this.parseHdfsWordingDir(), this.getProject());
            }
        }
        throw new IllegalArgumentException("illegal category: " + this.getCategory());
    }

    public String getIdentifier() {
        try {
            return StringUtils.isBlank((CharSequence)this.identifier) ? SparkEnv.get().conf().getAppId() : this.identifier;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String parseHdfsWordingDir() {
        return StringUtils.appendIfMissing((String)this.getWorkingDir(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + StringUtils.replace((String)this.getMetadataId(), (String)"/", (String)"-");
    }

    @Generated
    public String getLogPath() {
        return this.logPath;
    }

    @Generated
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Generated
    public int getRollingPeriod() {
        return this.rollingPeriod;
    }

    @Generated
    public void setRollingPeriod(int rollingPeriod) {
        this.rollingPeriod = rollingPeriod;
    }

    @Generated
    public void setRollingByteSize(long rollingByteSize) {
        this.rollingByteSize = rollingByteSize;
    }

    @Generated
    public long getRollingByteSize() {
        return this.rollingByteSize;
    }

    @Generated
    public String getMetadataId() {
        return this.metadataId;
    }

    @Generated
    public void setMetadataId(String metadataId) {
        this.metadataId = metadataId;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public String getJobTimeStamp() {
        return this.jobTimeStamp;
    }

    @Generated
    public void setJobTimeStamp(String jobTimeStamp) {
        this.jobTimeStamp = jobTimeStamp;
    }
}

