/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.udaf;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.KryoDataInput;
import java.io.DataInput;
import org.apache.kylin.measure.sumlc.SumLCCounter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.udaf.DoubleSerializer;
import org.apache.spark.sql.udaf.JavaBigDecimalSerializer;
import org.apache.spark.sql.udaf.LongSerializer;
import org.apache.spark.sql.udaf.NullSafeValueSerializer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;

public final class SumLCUtil$
implements Logging {
    public static SumLCUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SumLCUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SumLCCounter decodeToSumLCCounter(byte[] bytes, NullSafeValueSerializer codec) {
        SumLCCounter sumLCCounter;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).nonEmpty()) {
            KryoDataInput in = new KryoDataInput(new Input(bytes));
            Number sumLC = (Number)codec.deserialize((DataInput)in);
            long timestamp = in.readLong();
            sumLCCounter = new SumLCCounter(sumLC, Predef$.MODULE$.long2Long(timestamp));
        } else {
            sumLCCounter = new SumLCCounter();
        }
        return sumLCCounter;
    }

    public NullSafeValueSerializer getNumericNullSafeSerializerByDataType(DataType dataType) {
        NullSafeValueSerializer nullSafeValueSerializer;
        DataType dataType2 = dataType;
        if (LongType$.MODULE$.equals(dataType2)) {
            nullSafeValueSerializer = new LongSerializer();
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            nullSafeValueSerializer = new DoubleSerializer();
        } else if (DecimalType$.MODULE$.unapply(dataType2)) {
            nullSafeValueSerializer = new JavaBigDecimalSerializer();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(35).append("Unsupported sum_lc dimension type: ").append(dataType2).toString());
        }
        return nullSafeValueSerializer;
    }

    private SumLCUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

