/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.query.StructField;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.parser.ParserUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.springframework.util.Base64Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparderTypeUtil$
implements Logging {
    public static SparderTypeUtil$ MODULE$;
    private final List<String> DATETIME_FAMILY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparderTypeUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<String> DATETIME_FAMILY() {
        return this.DATETIME_FAMILY;
    }

    public boolean isDateTimeFamilyType(String dataType) {
        return this.DATETIME_FAMILY().contains((Object)dataType.toLowerCase());
    }

    public boolean isDateType(String dataType) {
        return "date".equalsIgnoreCase(dataType);
    }

    public boolean isDateTime(SqlTypeName sqlTypeName) {
        return SqlTypeName.DATETIME_TYPES.contains(sqlTypeName);
    }

    public DataType kylinTypeToSparkResultType(org.apache.kylin.metadata.datatype.DataType dataTp) {
        LongType$ longType$;
        String string = dataTp.getName();
        if (string.startsWith("hllc")) {
            longType$ = LongType$.MODULE$;
        } else if (string.startsWith("percentile")) {
            longType$ = DoubleType$.MODULE$;
        } else if (string.startsWith("bitmap")) {
            longType$ = LongType$.MODULE$;
        } else {
            boolean bl = "decimal".equals(string) ? true : "numeric".equals(string);
            if (bl) {
                longType$ = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
            } else if ("date".equals(string)) {
                longType$ = IntegerType$.MODULE$;
            } else if ("time".equals(string)) {
                longType$ = LongType$.MODULE$;
            } else if ("timestamp".equals(string)) {
                longType$ = LongType$.MODULE$;
            } else if ("datetime".equals(string)) {
                longType$ = LongType$.MODULE$;
            } else if ("tinyint".equals(string)) {
                longType$ = ByteType$.MODULE$;
            } else if ("smallint".equals(string)) {
                longType$ = ShortType$.MODULE$;
            } else if ("integer".equals(string)) {
                longType$ = IntegerType$.MODULE$;
            } else if ("int4".equals(string)) {
                longType$ = IntegerType$.MODULE$;
            } else if ("bigint".equals(string)) {
                longType$ = LongType$.MODULE$;
            } else if ("long8".equals(string)) {
                longType$ = LongType$.MODULE$;
            } else if ("float".equals(string)) {
                longType$ = FloatType$.MODULE$;
            } else if ("double".equals(string)) {
                longType$ = DoubleType$.MODULE$;
            } else if (string.startsWith("varchar")) {
                longType$ = StringType$.MODULE$;
            } else if (string.startsWith("char")) {
                longType$ = StringType$.MODULE$;
            } else if ("bitmap".equals(string)) {
                longType$ = LongType$.MODULE$;
            } else if ("dim_dc".equals(string)) {
                longType$ = LongType$.MODULE$;
            } else if ("boolean".equals(string)) {
                longType$ = BooleanType$.MODULE$;
            } else {
                throw new IllegalArgumentException();
            }
        }
        return longType$;
    }

    public DataType toSparkType(org.apache.kylin.metadata.datatype.DataType dataTp, boolean isSum) {
        DateType$ dateType$;
        String string = dataTp.getName();
        boolean bl = "decimal".equals(string) ? true : "numeric".equals(string);
        if (bl) {
            DecimalType decimalType;
            if (isSum) {
                int i = dataTp.getPrecision() + 10;
                decimalType = new DecimalType(Math.min(DecimalType$.MODULE$.MAX_PRECISION(), i), dataTp.getScale());
            } else {
                decimalType = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
            }
            dateType$ = decimalType;
        } else if ("date".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("time".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("timestamp".equals(string)) {
            dateType$ = TimestampType$.MODULE$;
        } else if ("datetime".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("tinyint".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : ByteType$.MODULE$;
        } else if ("smallint".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : ShortType$.MODULE$;
        } else if ("integer".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : IntegerType$.MODULE$;
        } else if ("int4".equals(string)) {
            dateType$ = isSum ? LongType$.MODULE$ : IntegerType$.MODULE$;
        } else if ("bigint".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("long8".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("float".equals(string)) {
            dateType$ = isSum ? DoubleType$.MODULE$ : FloatType$.MODULE$;
        } else if ("double".equals(string)) {
            dateType$ = DoubleType$.MODULE$;
        } else if (string.startsWith("varchar")) {
            dateType$ = StringType$.MODULE$;
        } else if (string.startsWith("char")) {
            dateType$ = StringType$.MODULE$;
        } else if ("dim_dc".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("boolean".equals(string)) {
            dateType$ = BooleanType$.MODULE$;
        } else if (string.startsWith("hllc")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("bitmap")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("extendedcolumn")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("percentile")) {
            dateType$ = BinaryType$.MODULE$;
        } else if (string.startsWith("raw")) {
            dateType$ = BinaryType$.MODULE$;
        } else if ("any".equals(string)) {
            dateType$ = StringType$.MODULE$;
        } else {
            throw new IllegalArgumentException(dataTp.toString());
        }
        return dateType$;
    }

    public boolean toSparkType$default$2() {
        return false;
    }

    public DataType convertSqlTypeToSparkType(RelDataType dt) {
        StringType$ stringType$;
        SqlTypeName sqlTypeName = dt.getSqlTypeName();
        if (SqlTypeName.DECIMAL.equals(sqlTypeName)) {
            stringType$ = new DecimalType(dt.getPrecision(), dt.getScale());
        } else if (SqlTypeName.CHAR.equals(sqlTypeName)) {
            stringType$ = StringType$.MODULE$;
        } else if (SqlTypeName.VARCHAR.equals(sqlTypeName)) {
            stringType$ = StringType$.MODULE$;
        } else if (SqlTypeName.INTEGER.equals(sqlTypeName)) {
            stringType$ = IntegerType$.MODULE$;
        } else if (SqlTypeName.TINYINT.equals(sqlTypeName)) {
            stringType$ = ByteType$.MODULE$;
        } else if (SqlTypeName.SMALLINT.equals(sqlTypeName)) {
            stringType$ = ShortType$.MODULE$;
        } else if (SqlTypeName.BIGINT.equals(sqlTypeName)) {
            stringType$ = LongType$.MODULE$;
        } else if (SqlTypeName.FLOAT.equals(sqlTypeName)) {
            stringType$ = FloatType$.MODULE$;
        } else if (SqlTypeName.DOUBLE.equals(sqlTypeName)) {
            stringType$ = DoubleType$.MODULE$;
        } else if (SqlTypeName.DATE.equals(sqlTypeName)) {
            stringType$ = DateType$.MODULE$;
        } else if (SqlTypeName.TIMESTAMP.equals(sqlTypeName)) {
            stringType$ = TimestampType$.MODULE$;
        } else if (SqlTypeName.BOOLEAN.equals(sqlTypeName)) {
            stringType$ = BooleanType$.MODULE$;
        } else if (SqlTypeName.ANY.equals(sqlTypeName)) {
            stringType$ = StringType$.MODULE$;
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(24).append("unsupported SqlTypeName ").append(dt).toString());
        }
        return stringType$;
    }

    public String convertSparkTypeToSqlType(DataType dt) {
        String string;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.VARCHAR.getName();
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.INTEGER.getName();
        } else if (ByteType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.TINYINT.getName();
        } else if (ShortType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.SMALLINT.getName();
        } else if (LongType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.BIGINT.getName();
        } else if (FloatType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.FLOAT.getName();
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.DOUBLE.getName();
        } else if (DateType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.DATE.getName();
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.TIMESTAMP.getName();
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            string = SqlTypeName.BOOLEAN.getName();
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            string = new java.lang.StringBuilder(3).append(SqlTypeName.DECIMAL.getName()).append("(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(24).append("unsupported SqlTypeName ").append(dt).toString());
        }
        return string;
    }

    public String getValueFromNlsString(NlsString s) {
        String string;
        if (!KylinConfig.getInstanceFromEnv().isQueryEscapedLiteral()) {
            StringBuilder ret = new StringBuilder();
            ret.append("'");
            ret.append(s.getValue().replace("'", "\\'"));
            ret.append("'");
            String res = ret.toString();
            string = ParserUtils$.MODULE$.unescapeSQLString(res);
        } else {
            string = s.getValue();
        }
        return string;
    }

    public Object getValueFromRexLit(RexLiteral literal) {
        Object object;
        Comparable comparable = literal.getValue();
        if (comparable instanceof NlsString) {
            NlsString nlsString = (NlsString)comparable;
            object = this.getValueFromNlsString(nlsString);
        } else if (comparable instanceof GregorianCalendar) {
            object = literal.getTypeName().getName().equals("DATE") ? new Date(BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)literal.toString()), ZoneId.systemDefault()).get()) / 1000L) : new Timestamp(BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)literal.toString()), ZoneId.systemDefault()).get()) / 1000L);
        } else if (comparable instanceof TimeUnitRange) {
            TimeUnitRange timeUnitRange = (TimeUnitRange)comparable;
            object = timeUnitRange.name();
        } else if (comparable instanceof Boolean) {
            Boolean bl = (Boolean)comparable;
            object = bl;
        } else if (comparable instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)comparable;
            SqlTypeName sqlTypeName = literal.getType().getSqlTypeName();
            Number number = SqlTypeName.BIGINT.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToLong((long)bigDecimal.longValue()) : (Number)(SqlTypeName.INTEGER.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToInteger((int)bigDecimal.intValue()) : (Number)(SqlTypeName.DOUBLE.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()) : (Number)(SqlTypeName.FLOAT.equals(sqlTypeName) ? (Number)BoxesRunTime.boxToFloat((float)bigDecimal.floatValue()) : (Number)(SqlTypeName.SMALLINT.equals(sqlTypeName) ? BoxesRunTime.boxToShort((short)bigDecimal.shortValue()) : bigDecimal))));
            object = number;
        } else if (comparable instanceof Float) {
            Float f = (Float)comparable;
            object = f;
        } else if (comparable instanceof Double) {
            Double d = (Double)comparable;
            object = d;
        } else if (comparable instanceof Integer) {
            Integer n = (Integer)comparable;
            object = n;
        } else if (comparable instanceof Byte) {
            Byte by = (Byte)comparable;
            object = by;
        } else if (comparable instanceof Short) {
            Short s = (Short)comparable;
            object = s;
        } else if (comparable instanceof Long) {
            Long l = (Long)comparable;
            object = l;
        } else {
            object = comparable == null ? null : literal.getValue().toString();
        }
        String ret = object;
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertToStringWithCalciteType(Object rawValue, RelDataType relType, boolean wrapped) {
        Object value2;
        Object value3;
        Object value4;
        Object str;
        Object dt;
        Object ts;
        Object object;
        Function1 & Serializable & scala.Serializable formatStringValue = (Function1 & Serializable & scala.Serializable)value -> wrapped ? new java.lang.StringBuilder(2).append("\"").append((String)value).append("\"").toString() : value;
        Tuple2 tuple2 = new Tuple2(rawValue, (Object)relType.getSqlTypeName());
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return null;
        }
        if (tuple2 != null) {
            Object value5 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value5 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)value5;
                if (SqlTypeName.DECIMAL.equals(sqlTypeName)) {
                    return bigDecimal.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object value6 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value6 instanceof Integer) {
                Integer n = (Integer)value6;
                if (SqlTypeName.INTEGER.equals(sqlTypeName)) {
                    return n.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object value7 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value7 instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)value7);
                if (SqlTypeName.TINYINT.equals(sqlTypeName)) {
                    return Byte.toString(by);
                }
            }
        }
        if (tuple2 != null) {
            Object value8 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value8 instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)value8);
                if (SqlTypeName.SMALLINT.equals(sqlTypeName)) {
                    return Short.toString(s);
                }
            }
        }
        if (tuple2 != null) {
            Object value9 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value9 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value9);
                if (SqlTypeName.BIGINT.equals(sqlTypeName)) {
                    return Long.toString(l);
                }
            }
        }
        if (tuple2 != null) {
            Object value10 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value10 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)value10);
                boolean bl = SqlTypeName.FLOAT.equals(sqlTypeName) ? true : SqlTypeName.REAL.equals(sqlTypeName);
                if (bl) {
                    return Float.toString(f);
                }
            }
        }
        if (tuple2 != null) {
            Object value11 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value11 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)value11);
                if (SqlTypeName.DOUBLE.equals(sqlTypeName)) {
                    return Double.toString(d);
                }
            }
        }
        if (tuple2 != null) {
            Object value12 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value12 instanceof Date) {
                Date date = (Date)value12;
                if (SqlTypeName.DATE.equals(sqlTypeName)) {
                    return date.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object value13 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value13 instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value13;
                if (SqlTypeName.TIMESTAMP.equals(sqlTypeName)) {
                    return DateFormat.castTimestampToString((long)timestamp.getTime());
                }
            }
        }
        if (tuple2 != null) {
            Object value14 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value14 instanceof Time) {
                Time time = (Time)value14;
                if (SqlTypeName.TIME.equals(sqlTypeName)) {
                    return time.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object value15 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value15 instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)value15);
                if (SqlTypeName.BOOLEAN.equals(sqlTypeName)) {
                    return Boolean.toString(bl);
                }
            }
        }
        if (tuple2 != null) {
            Object value16 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value16 instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value16;
                boolean bl = SqlTypeName.CHAR.equals(sqlTypeName) ? true : SqlTypeName.VARCHAR.equals(sqlTypeName);
                if (bl) {
                    return (String)formatStringValue.apply((Object)DateFormat.castTimestampToString((long)timestamp.getTime()));
                }
            }
        }
        if (tuple2 != null) {
            Object value17 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value17 instanceof Date) {
                Date date = (Date)value17;
                boolean bl = SqlTypeName.CHAR.equals(sqlTypeName) ? true : SqlTypeName.VARCHAR.equals(sqlTypeName);
                if (bl) {
                    return (String)formatStringValue.apply((Object)DateFormat.formatToDateStr((long)date.getTime()));
                }
            }
        }
        if (tuple2 != null) {
            Object value18 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            boolean bl = SqlTypeName.CHAR.equals(sqlTypeName) ? true : SqlTypeName.VARCHAR.equals(sqlTypeName);
            if (bl) {
                return (String)formatStringValue.apply((Object)value18.toString());
            }
        }
        if (tuple2 != null) {
            Object value19 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value19 instanceof Object) {
                Object object2 = value19;
                if (SqlTypeName.DECIMAL.equals(sqlTypeName)) {
                    return new BigDecimal(object2.toString()).setScale(relType.getScale(), 6).toString();
                }
            }
        }
        if (tuple2 != null) {
            Object value20 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value20 instanceof Object) {
                Object object3 = value20;
                boolean bl = SqlTypeName.INTEGER.equals(sqlTypeName) ? true : (SqlTypeName.TINYINT.equals(sqlTypeName) ? true : (SqlTypeName.SMALLINT.equals(sqlTypeName) ? true : SqlTypeName.BIGINT.equals(sqlTypeName)));
                if (bl) {
                    String string;
                    Object object4 = object3;
                    if (object4 instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)object4);
                        string = Long.toString((long)d);
                        return string;
                    } else if (object4 instanceof Float) {
                        float f = BoxesRunTime.unboxToFloat((Object)object4);
                        string = Long.toString((long)f);
                        return string;
                    } else if (object4 instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)object4;
                        string = Long.toString(bigDecimal.longValue());
                        return string;
                    } else {
                        string = Long.toString(new BigDecimal(object4.toString()).setScale(0, 6).longValue());
                    }
                    return string;
                }
            }
        }
        if (tuple2 != null) {
            Object value21 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value21 instanceof Object) {
                Object object5 = value21;
                boolean bl = SqlTypeName.FLOAT.equals(sqlTypeName) ? true : SqlTypeName.REAL.equals(sqlTypeName);
                if (bl) {
                    return Float.toString(Float.parseFloat(object5.toString()));
                }
            }
        }
        if (tuple2 != null) {
            Object value22 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value22 instanceof Object) {
                Object object6 = value22;
                if (SqlTypeName.DOUBLE.equals(sqlTypeName)) {
                    return Double.toString(Double.parseDouble(object6.toString()));
                }
            }
        }
        if (tuple2 != null) {
            Object value23 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value23 instanceof Object) {
                Object object7 = value23;
                if (SqlTypeName.TIME.equals(sqlTypeName)) {
                    return object7.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object value24 = tuple2._1();
            SqlTypeName sqlTypeName = (SqlTypeName)tuple2._2();
            if (value24 instanceof Object) {
                Object object8 = value24;
                boolean bl = SqlTypeName.DATE.equals(sqlTypeName) ? true : SqlTypeName.TIMESTAMP.equals(sqlTypeName);
                if (bl) {
                    long millis = DateFormat.stringToMillis((String)object8.toString());
                    SqlTypeName sqlTypeName2 = relType.getSqlTypeName();
                    SqlTypeName sqlTypeName3 = SqlTypeName.TIMESTAMP;
                    return !(sqlTypeName2 != null ? !sqlTypeName2.equals(sqlTypeName3) : sqlTypeName3 != null) ? DateFormat.castTimestampToString((long)millis) : DateFormat.formatToDateStr((long)new Date(millis).getTime());
                }
            }
        }
        if (tuple2 != null && (ts = tuple2._1()) instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)ts;
            return DateFormat.castTimestampToString((long)timestamp.getTime());
        }
        if (tuple2 != null && (dt = tuple2._1()) instanceof Date) {
            Date date = (Date)dt;
            return DateFormat.formatToDateStr((long)date.getTime());
        }
        if (tuple2 != null && (str = tuple2._1()) instanceof String) {
            String string = (String)str;
            return (String)formatStringValue.apply((Object)string);
        }
        if (tuple2 != null && (value4 = tuple2._1()) instanceof WrappedArray.ofRef) {
            WrappedArray.ofRef ofRef2 = (WrappedArray.ofRef)value4;
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)ofRef2.array()).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.convertToStringWithCalciteType(v, relType, true), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]");
        }
        if (tuple2 != null && (value3 = tuple2._1()) instanceof Map) {
            Map map = (Map)value3;
            return ((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)v -> new java.lang.StringBuilder(1).append(MODULE$.convertToStringWithCalciteType(v._1(), relType, true)).append(":").append(MODULE$.convertToStringWithCalciteType(v._2(), relType, true)).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
        }
        if (tuple2 != null && (value2 = tuple2._1()) instanceof byte[]) {
            byte[] byArray = (byte[])value2;
            return Base64Utils.encodeToString((byte[])byArray);
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object other = tuple2._1();
        return other.toString();
    }

    public boolean convertToStringWithCalciteType$default$3() {
        return false;
    }

    public Object convertStringToValue(Object s, RelDataType rowType, boolean toCalcite) {
        Object object;
        SqlTypeName sqlTypeName = rowType.getSqlTypeName();
        if (s == null) {
            object = null;
        } else if (s.toString().isEmpty()) {
            SqlTypeName sqlTypeName2 = sqlTypeName;
            Object object2 = SqlTypeName.DECIMAL.equals(sqlTypeName2) ? new BigDecimal(0) : (SqlTypeName.CHAR.equals(sqlTypeName2) ? s.toString() : (SqlTypeName.VARCHAR.equals(sqlTypeName2) ? s.toString() : (SqlTypeName.INTEGER.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToInteger((int)0) : (Number)(SqlTypeName.TINYINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToByte((byte)((byte)0)) : (Number)(SqlTypeName.SMALLINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToShort((short)((short)0)) : (Number)(SqlTypeName.BIGINT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToLong((long)0L) : (Number)(SqlTypeName.FLOAT.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToFloat((float)0.0f) : (Number)(SqlTypeName.REAL.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToFloat((float)0.0f) : (Number)(SqlTypeName.DOUBLE.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToDouble((double)0.0) : (Number)(SqlTypeName.DATE.equals(sqlTypeName2) ? (Number)BoxesRunTime.boxToInteger((int)0) : (Number)(SqlTypeName.TIMESTAMP.equals(sqlTypeName2) ? BoxesRunTime.boxToLong((long)0L) : (SqlTypeName.TIME.equals(sqlTypeName2) ? BoxesRunTime.boxToLong((long)0L) : (SqlTypeName.BOOLEAN.equals(sqlTypeName2) ? null : (sqlTypeName2 == null ? null : null))))))))))))));
            object = object2;
        } else {
            try {
                Object object3;
                SqlTypeName sqlTypeName3 = sqlTypeName;
                if (SqlTypeName.DECIMAL.equals(sqlTypeName3)) {
                    object3 = s instanceof Double || s instanceof Float || s.toString().contains(".") ? new BigDecimal(s.toString()).setScale(rowType.getScale(), 6) : new BigDecimal(s.toString());
                } else if (SqlTypeName.CHAR.equals(sqlTypeName3)) {
                    object3 = s.toString();
                } else if (SqlTypeName.VARCHAR.equals(sqlTypeName3)) {
                    object3 = s.toString();
                } else if (SqlTypeName.INTEGER.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toInt());
                } else if (SqlTypeName.TINYINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toByte());
                } else if (SqlTypeName.SMALLINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toShort());
                } else if (SqlTypeName.BIGINT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toLong());
                } else if (SqlTypeName.FLOAT.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
                } else if (SqlTypeName.DOUBLE.equals(sqlTypeName3)) {
                    object3 = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
                } else if (SqlTypeName.DATE.equals(sqlTypeName3)) {
                    Object object4;
                    String string = s.toString();
                    if (string.contains("-")) {
                        long time = DateFormat.stringToDate((String)string).getTime();
                        object4 = toCalcite ? DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)string)).get() : BoxesRunTime.boxToLong((long)(time / 1000L));
                    } else {
                        object4 = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(this.toCalciteTimestamp(DateFormat.stringToMillis((String)string)) / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)(DateFormat.stringToMillis((String)string) / 1000L));
                    }
                    object3 = object4;
                } else {
                    boolean bl = SqlTypeName.TIMESTAMP.equals(sqlTypeName3) ? true : SqlTypeName.TIME.equals(sqlTypeName3);
                    if (bl) {
                        String ts = ((Timestamp)s).toString();
                        object3 = toCalcite ? BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)ts), TimeZone.getTimeZone("UTC").toZoneId()).get()) / 1000L)) : BoxesRunTime.boxToLong((long)(((Timestamp)s).getTime() / 1000L));
                    } else {
                        object3 = SqlTypeName.BOOLEAN.equals(sqlTypeName3) ? s : s.toString();
                    }
                }
                String a = object3;
                object = a;
            }
            catch (Throwable th) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(61).append("convertStringToValue failed: {\"v\": \"").append(s).append("\", \"cls\": \"").append(s.getClass()).append("\", \"type\": \"").append(sqlTypeName).append("\"}").toString());
                object = this.safetyConvertStringToValue(s, rowType, toCalcite);
            }
        }
        return object;
    }

    public DataType kylinRawTableSQLTypeToSparkType(org.apache.kylin.metadata.datatype.DataType dataTp) {
        DateType$ dateType$;
        String string = dataTp.getName();
        boolean bl = "decimal".equals(string) ? true : "numeric".equals(string);
        if (bl) {
            dateType$ = new DecimalType(dataTp.getPrecision(), dataTp.getScale());
        } else if ("date".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("time".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("timestamp".equals(string)) {
            dateType$ = TimestampType$.MODULE$;
        } else if ("datetime".equals(string)) {
            dateType$ = DateType$.MODULE$;
        } else if ("tinyint".equals(string)) {
            dateType$ = ByteType$.MODULE$;
        } else if ("smallint".equals(string)) {
            dateType$ = ShortType$.MODULE$;
        } else if ("integer".equals(string)) {
            dateType$ = IntegerType$.MODULE$;
        } else if ("int4".equals(string)) {
            dateType$ = IntegerType$.MODULE$;
        } else if ("bigint".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("long8".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("float".equals(string)) {
            dateType$ = FloatType$.MODULE$;
        } else if ("double".equals(string)) {
            dateType$ = DoubleType$.MODULE$;
        } else if ("real".equals(string)) {
            dateType$ = DoubleType$.MODULE$;
        } else if (string.startsWith("char")) {
            dateType$ = StringType$.MODULE$;
        } else if (string.startsWith("varchar")) {
            dateType$ = StringType$.MODULE$;
        } else if ("bitmap".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("dim_dc".equals(string)) {
            dateType$ = LongType$.MODULE$;
        } else if ("boolean".equals(string)) {
            dateType$ = BooleanType$.MODULE$;
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(24).append("No supported data type: ").append(string).toString());
        }
        return dateType$;
    }

    public Object safetyConvertStringToValue(Object s, RelDataType rowType, boolean toCalcite) {
        String string;
        try {
            Object object;
            SqlTypeName sqlTypeName = rowType.getSqlTypeName();
            if (SqlTypeName.DECIMAL.equals(sqlTypeName)) {
                object = s instanceof Double || s instanceof Float || s.toString().contains(".") ? new BigDecimal(s.toString()).setScale(rowType.getScale(), 6) : new BigDecimal(s.toString());
            } else if (SqlTypeName.CHAR.equals(sqlTypeName)) {
                object = s.toString();
            } else if (SqlTypeName.VARCHAR.equals(sqlTypeName)) {
                object = s.toString();
            } else if (SqlTypeName.INTEGER.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToInteger((int)((int)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.TINYINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToByte((byte)((byte)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.SMALLINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToShort((short)((short)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.BIGINT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToLong((long)((long)new StringOps(Predef$.MODULE$.augmentString(s.toString())).toDouble()));
            } else if (SqlTypeName.FLOAT.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToFloat((float)Float.parseFloat(s.toString()));
            } else if (SqlTypeName.DOUBLE.equals(sqlTypeName)) {
                object = BoxesRunTime.boxToDouble((double)Double.parseDouble(s.toString()));
            } else if (SqlTypeName.DATE.equals(sqlTypeName)) {
                Number number;
                String string2 = s.toString();
                if (string2.contains("-")) {
                    long time = DateFormat.stringToDate((String)string2).getTime();
                    number = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(time / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)(time / 1000L));
                } else {
                    number = toCalcite ? (Number)BoxesRunTime.boxToInteger((int)((int)(this.toCalciteTimestamp(DateFormat.stringToMillis((String)string2)) / 86400000L))) : (Number)BoxesRunTime.boxToLong((long)DateFormat.stringToMillis((String)string2));
                }
                object = number;
            } else {
                boolean bl = SqlTypeName.TIMESTAMP.equals(sqlTypeName) ? true : SqlTypeName.TIME.equals(sqlTypeName);
                if (bl) {
                    long ts = ((Timestamp)s).getTime();
                    object = toCalcite ? BoxesRunTime.boxToLong((long)ts) : BoxesRunTime.boxToLong((long)(ts / 1000L));
                } else {
                    object = SqlTypeName.BOOLEAN.equals(sqlTypeName) ? s : s.toString();
                }
            }
            string = object;
        }
        catch (Throwable th) {
            throw new RuntimeException(new java.lang.StringBuilder(36).append("Error for convert value : ").append(s).append(" , class: ").append(s.getClass()).toString(), th);
        }
        return string;
    }

    public Long toSparkTimestamp(long calciteTimestamp) {
        return Predef$.MODULE$.long2Long(calciteTimestamp / 1000L);
    }

    public long toCalciteTimestamp(long sparkTimestamp) {
        return sparkTimestamp * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    public Column[] alignDataTypeAndName(StructType origin, StructType goal) {
        void var3_3;
        Column[] columns = (Column[])((TraversableOnce)((TraversableLike)origin.zip((GenIterable)goal, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DataType goalDataType;
                StructField sparkField = (StructField)tuple2._1();
                StructField goalField = (StructField)tuple2._2();
                DataType sparkDataType = sparkField.dataType();
                if (!sparkDataType.sameType(goalDataType = goalField.dataType())) {
                    if (Cast$.MODULE$.canCast(sparkDataType, goalDataType)) {
                        column = functions$.MODULE$.col(sparkField.name()).cast(goalDataType).as(sparkField.name().toUpperCase(Locale.ROOT));
                    } else {
                        MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(57).append("Error for cast datatype from  ").append(sparkDataType).append(" to ").append(goalDataType).append(" with column name is : ").append(sparkField.name()).toString());
                        column = functions$.MODULE$.col(sparkField.name()).as(sparkField.name().toUpperCase(Locale.ROOT));
                    }
                } else {
                    column = functions$.MODULE$.col(sparkField.name()).as(sparkField.name().toUpperCase(Locale.ROOT));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Column column2 = column;
            return column2;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Align data type is ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).mkString(",")).toString());
        return var3_3;
    }

    public org.apache.kylin.metadata.query.StructField convertSparkFieldToJavaField(StructField field) {
        StructField.StructFieldBuilder structFieldBuilder;
        StructField.StructFieldBuilder builder = new StructField.StructFieldBuilder();
        builder.setName(field.name());
        DataType dataType = field.dataType();
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            builder.setPrecision(decimalType.precision());
            builder.setScale(decimalType.scale());
            builder.setDataType(3);
            structFieldBuilder = builder.setDataTypeName(new java.lang.StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            builder.setDataType(-2);
            structFieldBuilder = builder.setDataTypeName("BINARY");
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            builder.setDataType(16);
            structFieldBuilder = builder.setDataTypeName("BOOLEAN");
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            builder.setDataType(8);
            structFieldBuilder = builder.setDataTypeName("DOUBLE");
        } else if (FloatType$.MODULE$.equals(dataType)) {
            builder.setDataType(6);
            structFieldBuilder = builder.setDataTypeName("FLOAT");
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            builder.setDataType(4);
            structFieldBuilder = builder.setDataTypeName("INTEGER");
        } else if (LongType$.MODULE$.equals(dataType)) {
            builder.setDataType(-5);
            structFieldBuilder = builder.setDataTypeName("BIGINT");
        } else if (ShortType$.MODULE$.equals(dataType)) {
            builder.setDataType(5);
            structFieldBuilder = builder.setDataTypeName("SMALLINT");
        } else if (ByteType$.MODULE$.equals(dataType)) {
            builder.setDataType(-6);
            structFieldBuilder = builder.setDataTypeName("TINYINT");
        } else if (DateType$.MODULE$.equals(dataType)) {
            builder.setDataType(91);
            structFieldBuilder = builder.setDataTypeName("DATE");
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            builder.setDataType(93);
            structFieldBuilder = builder.setDataTypeName("TIMESTAMP");
        } else if (StringType$.MODULE$.equals(dataType)) {
            builder.setDataType(12);
            structFieldBuilder = builder.setDataTypeName("VARCHAR");
        } else {
            builder.setDataType(1111);
            structFieldBuilder = builder.setDataTypeName(field.dataType().sql());
        }
        builder.setNullable(field.nullable());
        return builder.createStructField();
    }

    private SparderTypeUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.DATETIME_FAMILY = new .colon.colon((Object)"time", (List)new .colon.colon((Object)"date", (List)new .colon.colon((Object)"timestamp", (List)new .colon.colon((Object)"datetime", (List)Nil$.MODULE$))));
    }
}

