/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.storage.StorageFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMergeAssist
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(CubeMergeAssist.class);
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private LayoutEntity layout;
    private SegmentInfo newSegment;
    private List<SegmentInfo> toMergeSegments;
    private SparkSession ss;
    private final List<LayoutEntity> toMergeCuboids = new ArrayList<LayoutEntity>();

    public void setSs(SparkSession ss) {
        this.ss = ss;
    }

    public void setLayout(LayoutEntity layout) {
        this.layout = layout;
    }

    public LayoutEntity getLayout() {
        return this.layout;
    }

    public List<LayoutEntity> getCuboids() {
        return this.toMergeCuboids;
    }

    public void addCuboid(LayoutEntity cuboid) {
        this.toMergeCuboids.add(cuboid);
    }

    public void setToMergeSegments(List<SegmentInfo> segments) {
        this.toMergeSegments = segments;
    }

    public void setNewSegment(SegmentInfo segment) {
        this.newSegment = segment;
    }

    public SegmentInfo getSegment() {
        return this.newSegment;
    }

    public Dataset<Row> merge(KylinConfig config, String cubeId) {
        Dataset mergeDataset = null;
        for (int i = 0; i < this.toMergeSegments.size(); ++i) {
            Dataset layoutDataset = ((NSparkCubingEngine.NSparkCubingStorage)StorageFactory.createEngineAdapter((IStorageAware)this.layout, NSparkCubingEngine.NSparkCubingStorage.class)).getFrom(PathManager.getParquetStoragePath((KylinConfig)config, (String)cubeId, (String)this.toMergeSegments.get(i).name(), (String)this.toMergeSegments.get(i).identifier(), (String)String.valueOf(this.layout.getId())), this.ss);
            mergeDataset = mergeDataset == null ? layoutDataset : mergeDataset.union(layoutDataset);
        }
        return mergeDataset;
    }
}

