/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBuildSourceInfo {
    protected static final Logger logger = LoggerFactory.getLogger(NBuildSourceInfo.class);
    private Dataset<Row> flatTableDS;
    private String viewFactTablePath;
    private SparkSession ss;
    private long byteSize;
    private long count;
    private long layoutId;
    private LayoutEntity layoutEntity;
    private String parentStoragePath;
    private Collection<LayoutEntity> toBuildCuboids = new LinkedHashSet<LayoutEntity>();

    public long getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    public void setFlatTableDS(Dataset<Row> flatTableDS) {
        this.flatTableDS = flatTableDS;
    }

    public Dataset<Row> getFlatTableDS() {
        return this.flatTableDS;
    }

    public Dataset<Row> getParentDS() {
        if (!StringUtils.isBlank((String)this.parentStoragePath)) {
            logger.info("parent storage path exists, read from it. path:{}", (Object)this.parentStoragePath);
            Preconditions.checkNotNull((Object)this.ss, (Object)"SparkSession is null is NBuildSourceInfo.");
            return this.ss.read().parquet(this.parentStoragePath);
        }
        Preconditions.checkState((this.flatTableDS != null ? 1 : 0) != 0, (Object)"Path and DS can no be empty at the same time.");
        logger.info("parent storage path not exists, use flatTable dataset.");
        return this.flatTableDS;
    }

    public void setSparkSession(SparkSession ss) {
        this.ss = ss;
    }

    public String getViewFactTablePath() {
        return this.viewFactTablePath;
    }

    public void setViewFactTablePath(String viewFactTablePath) {
        this.viewFactTablePath = viewFactTablePath;
    }

    public void setLayoutId(long layoutId) {
        this.layoutId = layoutId;
    }

    public void setLayout(LayoutEntity layoutEntity) {
        this.layoutEntity = layoutEntity;
    }

    public LayoutEntity getLayout() {
        return this.layoutEntity;
    }

    public long getLayoutId() {
        return this.layoutId;
    }

    public void setToBuildCuboids(Collection<LayoutEntity> toBuildCuboids) {
        this.toBuildCuboids = toBuildCuboids;
    }

    public Collection<LayoutEntity> getToBuildCuboids() {
        return this.toBuildCuboids;
    }

    public void addCuboid(LayoutEntity cuboid) {
        this.toBuildCuboids.add(cuboid);
    }

    public void setParentStoragePath(String parentStoragePath) {
        this.parentStoragePath = parentStoragePath;
    }
}

