/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.engine.spark.utils.UpdateMetadataUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkCubingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkCubingStep.class);

    public NSparkCubingStep() {
    }

    public NSparkCubingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Build Cube with Spark");
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        String cubeId = this.getParam("cubeId");
        CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)config).getCubeByUuid(cubeId);
        return MetaDumpUtil.collectCubeMetadata(cubeInstance);
    }

    @Override
    public boolean needMergeMetadata() {
        return true;
    }

    @Override
    protected void updateMetaAfterOperation(KylinConfig config) throws IOException {
        UpdateMetadataUtil.syncLocalMetadataToRemote(config, this);
    }

    @Override
    protected Map<String, String> getJobMetricsInfo(KylinConfig config) {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)config);
        CubeInstance cube = cubeManager.getCube(this.getCubeName());
        HashMap joblogInfo = Maps.newHashMap();
        joblogInfo.put("sourceSizeBytes", String.valueOf(cube.getInputRecordSizeBytes()));
        joblogInfo.put("byteSizeBytes", String.valueOf(cube.getSizeKB()));
        return joblogInfo;
    }

    public void cleanup(ExecuteResult result) throws ExecuteException {
        if (result != null && result.state().ordinal() == ExecuteResult.State.SUCCEED.ordinal()) {
            PathManager.deleteJobTempPath((KylinConfig)this.getConfig(), (String)this.getParam("project"), (String)this.getParam("jobId"));
        }
    }

    public static class Mockup {
        public static void main(String[] args) {
            logger.info(Mockup.class + ".main() invoked, args: " + Arrays.toString(args));
        }
    }
}

