/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.spark.sql.Column;

public class NSparkCubingUtil {
    private static final Pattern DOT_PATTERN = Pattern.compile("(\\S+)\\.(\\D+)");
    public static final String SEPARATOR = "_0_DOT_0_";

    static String ids2Str(Set<? extends Number> ids) {
        return String.join((CharSequence)",", ids.stream().map(String::valueOf).collect(Collectors.toList()));
    }

    static Set<Long> str2Longs(String str) {
        LinkedHashSet<Long> r = new LinkedHashSet<Long>();
        for (String id : str.split(",")) {
            r.add(Long.parseLong(id));
        }
        return r;
    }

    public static Column[] getColumns(Set<Integer> indices1, Set<Integer> indices2) {
        LinkedHashSet<Integer> ret = new LinkedHashSet<Integer>();
        ret.addAll(indices1);
        ret.addAll(indices2);
        return NSparkCubingUtil.getColumns(ret);
    }

    public static Column[] getColumns(Collection<Integer> indices) {
        Column[] ret = new Column[indices.size()];
        int index = 0;
        for (Integer i : indices) {
            ret[index] = new Column(String.valueOf(i));
            ++index;
        }
        return ret;
    }

    public static Column getFirstColumn(Collection<Integer> indices) {
        return NSparkCubingUtil.getColumns(indices)[0];
    }

    public static String convertFromDot(String withDot) {
        Matcher m = DOT_PATTERN.matcher(withDot);
        String withoutDot = withDot;
        while (m.find()) {
            withoutDot = m.replaceAll("$1_0_DOT_0_$2");
            m = DOT_PATTERN.matcher(withoutDot);
        }
        return withoutDot;
    }

    public static String getStoragePath(CubeSegment segment, Long layoutId) {
        return PathManager.getParquetStoragePath((CubeInstance)segment.getCubeInstance(), (String)segment.getName(), (String)segment.getStorageLocationIdentifier(), (Long)layoutId);
    }

    static Set<String> toSegmentNames(Segments<CubeSegment> segments) {
        LinkedHashSet s = Sets.newLinkedHashSet();
        s.addAll(segments.stream().map(CubeSegment::getName).collect(Collectors.toList()));
        return s;
    }

    public static String getStoragePathWithoutPrefix(String project, String cubeId, String segmentId, long layoutId) {
        return project + "/parquet/" + cubeId + "/" + segmentId + "/" + layoutId;
    }
}

