/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkMergeStatisticsStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkMergeStatisticsStep.class);
    private List<CubeSegment> mergingSegments = Lists.newArrayList();
    protected Map<Long, HLLCounter> cuboidHLLMap = Maps.newHashMap();

    public NSparkMergeStatisticsStep() {
        this.setName("Merge Cuboid Statistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String jobId = this.getParam("jobId");
        String cubeId = this.getParam("cubeId");
        String mergedSegmentUuid = this.getParam("segmentIds");
        KylinConfig kylinConfig = this.wrapConfig(context);
        CubeInstance cube = CubeManager.getInstance((KylinConfig)kylinConfig).getCubeByUuid(cubeId);
        CubeSegment mergedSeg = cube.getSegmentById(mergedSegmentUuid);
        String jobTmpDir = kylinConfig.getJobTmpDir(cube.getProject()) + "/" + jobId;
        Path statisticsDir = new Path(jobTmpDir + "/" + "/cube_statistics" + "/" + cubeId + "/" + mergedSeg.getUuid() + "/");
        this.mergingSegments = cube.getMergingSegments(mergedSeg);
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        ResourceStore rs = ResourceStore.getStore((KylinConfig)kylinConfig);
        try {
            int averageSamplingPercentage = 0;
            long sourceRecordCount = 0L;
            for (CubeSegment segment : this.mergingSegments) {
                String segmentId = segment.getUuid();
                String fileKey = CubeSegment.getStatisticsResourcePath((String)cube.getName(), (String)segmentId);
                InputStream is = rs.getResource(fileKey).content();
                File tempFile = null;
                FileOutputStream tempFileStream = null;
                try {
                    tempFile = Files.createTempFile(segmentId, ".seq", new FileAttribute[0]).toFile();
                    tempFileStream = new FileOutputStream(tempFile);
                    IOUtils.copy((InputStream)is, (OutputStream)tempFileStream);
                }
                catch (Throwable throwable) {
                    org.apache.hadoop.io.IOUtils.closeStream((Closeable)is);
                    org.apache.hadoop.io.IOUtils.closeStream(tempFileStream);
                    throw throwable;
                }
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)is);
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)tempFileStream);
                FileSystem fs = HadoopUtil.getFileSystem((String)("file:///" + tempFile.getAbsolutePath()));
                SequenceFile.Reader reader = null;
                try {
                    reader = new SequenceFile.Reader(fs, new Path(tempFile.getAbsolutePath()), conf);
                    LongWritable key = (LongWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                    BytesWritable value = (BytesWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                    while (reader.next((Writable)key, (Writable)value)) {
                        if (key.get() == 0L) {
                            averageSamplingPercentage += Bytes.toInt((byte[])value.getBytes());
                            continue;
                        }
                        if (key.get() == -3L) {
                            long perSourceRecordCount = Bytes.toLong((byte[])value.getBytes());
                            if (perSourceRecordCount <= 0L) continue;
                            sourceRecordCount += perSourceRecordCount;
                            continue;
                        }
                        if (key.get() <= 0L) continue;
                        HLLCounter hll = new HLLCounter(kylinConfig.getCubeStatsHLLPrecision());
                        ByteArray byteArray = new ByteArray(value.getBytes());
                        hll.readRegisters(byteArray.asBuffer());
                        if (this.cuboidHLLMap.get(key.get()) != null) {
                            this.cuboidHLLMap.get(key.get()).merge(hll);
                            continue;
                        }
                        this.cuboidHLLMap.put(key.get(), hll);
                    }
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        org.apache.hadoop.io.IOUtils.closeStream(reader);
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                        throw throwable;
                    }
                }
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)reader);
                if (tempFile == null) continue;
                tempFile.delete();
            }
            CubeStatsWriter.writeCuboidStatistics((Configuration)conf, (Path)statisticsDir, this.cuboidHLLMap, (int)(averageSamplingPercentage /= this.mergingSegments.size()), (long)sourceRecordCount);
            Path statisticsFilePath = new Path(statisticsDir, "cuboid_statistics.seq");
            FileSystem fs = HadoopUtil.getFileSystem((Path)statisticsFilePath, (Configuration)conf);
            FSDataInputStream is = fs.open(statisticsFilePath);
            try {
                String statisticsFileName = mergedSeg.getStatisticsResourcePath();
                rs.putResource(statisticsFileName, (InputStream)is, System.currentTimeMillis());
            }
            finally {
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)is);
            }
            return ExecuteResult.createSucceed();
        }
        catch (IOException e) {
            logger.error("fail to merge cuboid statistics", (Throwable)e);
            return ExecuteResult.createError((Throwable)e);
        }
    }
}

