/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.spark.job.JobStepFactory;
import org.apache.kylin.engine.spark.job.JobStepType;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkMergingStep;
import org.apache.kylin.engine.spark.job.NSparkUpdateMetaAndCleanupAfterMergeStep;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkMergingJob
extends CubingJob {
    private static final Logger logger = LoggerFactory.getLogger(NSparkMergingJob.class);

    public static NSparkMergingJob merge(CubeSegment mergedSegment, String submitter) {
        return NSparkMergingJob.merge(mergedSegment, submitter, CubingJob.CubingJobTypeEnum.MERGE, UUID.randomUUID().toString());
    }

    public static NSparkMergingJob merge(CubeSegment mergedSegment, String submitter, CubingJob.CubingJobTypeEnum jobType, String jobId) {
        CubeInstance cube = mergedSegment.getCubeInstance();
        NSparkMergingJob job = new NSparkMergingJob();
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone(cube.getConfig().getTimeZone()));
        StringBuilder builder = new StringBuilder();
        builder.append(jobType).append(" CUBE - ");
        builder.append(mergedSegment.getCubeInstance().getDisplayName()).append(" - ").append(mergedSegment.getName()).append(" - ");
        builder.append(format.format(new Date(System.currentTimeMillis())));
        job.setName(builder.toString());
        job.setId(jobId);
        job.setTargetSubject(mergedSegment.getModel().getUuid());
        job.setTargetSegments(Lists.newArrayList((Object[])new String[]{String.valueOf(mergedSegment.getUuid())}));
        job.setProject(mergedSegment.getProject());
        job.setSubmitter(submitter);
        job.setParam("jobId", jobId);
        job.setParam("project", cube.getProject());
        job.setParam("targetModel", job.getTargetSubject());
        job.setParam("cubeId", cube.getId());
        job.setParam("cubeName", cube.getName());
        job.setParam("segmentIds", String.join((CharSequence)",", job.getTargetSegments()));
        job.setParam("segmentId", mergedSegment.getUuid());
        job.setParam("segmentName", mergedSegment.getName());
        job.setParam("dataRangeStart", mergedSegment.getSegRange().start.toString());
        job.setParam("dataRangeEnd", mergedSegment.getSegRange().end.toString());
        job.setParam("outputMetaUrl", cube.getConfig().getMetadataUrl().toString());
        job.setParam("jobType", String.valueOf(jobType));
        job.setParam("cuboidsNum", String.valueOf(cube.getDescriptor().getAllCuboids().size()));
        job.setDeployEnvName(KylinConfig.getInstanceFromEnv().getDeployEnv());
        job.setNotifyList(cube.getDescriptor().getNotifyList());
        JobStepFactory.addStep((DefaultChainedExecutable)job, JobStepType.RESOURCE_DETECT, cube);
        JobStepFactory.addStep((DefaultChainedExecutable)job, JobStepType.MERGING, cube);
        if (KylinConfig.getInstanceFromEnv().isSegmentStatisticsEnabled()) {
            JobStepFactory.addStep((DefaultChainedExecutable)job, JobStepType.MERGE_STATISTICS, cube);
        }
        JobStepFactory.addStep((DefaultChainedExecutable)job, JobStepType.CLEAN_UP_AFTER_MERGE, cube);
        return job;
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        String cubeId = this.getParam("cubeId");
        CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)config).getCubeByUuid(cubeId);
        return MetaDumpUtil.collectCubeMetadata(cubeInstance);
    }

    public NSparkMergingStep getSparkMergingStep() {
        return (NSparkMergingStep)this.getTask(NSparkMergingStep.class);
    }

    public NResourceDetectStep getResourceDetectStep() {
        return (NResourceDetectStep)this.getTask(NResourceDetectStep.class);
    }

    public NSparkUpdateMetaAndCleanupAfterMergeStep getCleanUpAfterMergeStep() {
        return (NSparkUpdateMetaAndCleanupAfterMergeStep)this.getTask(NSparkUpdateMetaAndCleanupAfterMergeStep.class);
    }
}

