/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.CuboidStatsReaderUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterCheckpointStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkUpdateCubeInfoAfterOptimizeStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCubeInfoAfterCheckpointStep.class);

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = cubeManager.getCube(CubingExecutableUtil.getCubeName((Map)this.getParams()));
        Set recommendCuboids = cube.getCuboidsRecommend();
        try {
            Segments newSegments = cube.getSegments(SegmentStatusEnum.READY_PENDING);
            Map recommendCuboidsWithStats = CuboidStatsReaderUtil.readCuboidStatsFromSegments((Set)recommendCuboids, (List)newSegments);
            if (recommendCuboidsWithStats == null) {
                throw new RuntimeException("Fail to get statistics info for recommended cuboids after optimization!!!");
            }
            cubeManager.promoteCheckpointOptimizeSegments(cube, recommendCuboidsWithStats, newSegments.toArray(new CubeSegment[newSegments.size()]));
            return new ExecuteResult();
        }
        catch (Exception e) {
            logger.error("fail to update cube after build", (Throwable)e);
            return ExecuteResult.createError((Throwable)e);
        }
    }
}

