/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.constant.JobTypeEnum;
import org.apache.kylin.engine.spark.job.JobStepType;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NTableSamplingStep;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTableSamplingJob
extends DefaultChainedExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NTableSamplingJob.class);

    public Set<String> getMetadataDumpList(KylinConfig config) {
        String table = this.getParam("table");
        String project = this.getParam("project");
        TableDesc tableDesc = TableMetadataManager.getInstance((KylinConfig)config).getTableDesc(table, project);
        ProjectInstance projectInstance = ProjectManager.getInstance((KylinConfig)config).getProject(project);
        return Sets.newHashSet((Object[])new String[]{tableDesc.getResourcePath(), projectInstance.getResourcePath()});
    }

    public static NTableSamplingJob create(TableDesc tableDesc, String project, String submitter, long rows) {
        Preconditions.checkArgument((tableDesc != null ? 1 : 0) != 0, (Object)"Create table sampling job failed for table not exist!");
        logger.info("start creating a table sampling job on table {}", (Object)tableDesc.getIdentity());
        NTableSamplingJob job = new NTableSamplingJob();
        job.setId(UUID.randomUUID().toString());
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone(tableDesc.getConfig().getTimeZone()));
        StringBuilder builder = new StringBuilder();
        builder.append(JobTypeEnum.TABLE_SAMPLING).append(" - ").append(tableDesc.getIdentity()).append(" - ").append(format.format(new Date(System.currentTimeMillis())));
        job.setName(builder.toString());
        job.setProject(project);
        job.setJobType(JobTypeEnum.TABLE_SAMPLING);
        job.setTargetSubject(tableDesc.getIdentity());
        job.setSubmitter(submitter);
        job.setParam("project", project);
        job.setParam("jobId", job.getId());
        job.setParam("table", tableDesc.getIdentity());
        job.setPriority(3);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        long configuredMaxRows = config.getSparkSampleTableMaxRows();
        if (configuredMaxRows < rows) {
            logger.info("sampling rows {} exceed configured rows {}, using configured rows {} to sample table!", new Object[]{rows, configuredMaxRows, configuredMaxRows});
            rows = configuredMaxRows;
        }
        job.setParam("maxSampleCount", String.valueOf(rows));
        JobStepType.RESOURCE_DETECT.createStep(job, config);
        JobStepType.SAMPLING.createStep(job, config);
        logger.info("sampling job create success on table {}", (Object)tableDesc.getIdentity());
        return job;
    }

    public NResourceDetectStep getResourceDetectStep() {
        return (NResourceDetectStep)this.getTask(NResourceDetectStep.class);
    }

    public NTableSamplingStep getSamplingStep() {
        return (NTableSamplingStep)this.getTask(NTableSamplingStep.class);
    }
}

