/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.utils.UpdateMetadataUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTableSamplingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NTableSamplingStep.class);

    public NTableSamplingStep() {
    }

    public NTableSamplingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Sample Table");
    }

    private String getTableIdentity() {
        return this.getParam("table");
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        return super.doWork(context);
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        TableDesc table;
        HashSet dumpList = Sets.newHashSet();
        String project = this.getParam("project");
        ProjectInstance instance = ProjectManager.getInstance((KylinConfig)config).getProject(project);
        dumpList.add(instance.getResourcePath());
        TableMetadataManager tableMetadataManager = TableMetadataManager.getInstance((KylinConfig)config);
        TableExtDesc tableExtDesc = tableMetadataManager.getTableExt(tableMetadataManager.getTableDesc(this.getTableIdentity(), project));
        if (tableExtDesc != null) {
            dumpList.add(tableExtDesc.getResourcePath());
        }
        if ((table = tableMetadataManager.getTableDesc(this.getTableIdentity(), project)) != null) {
            dumpList.add(table.getResourcePath());
        }
        return dumpList;
    }

    @Override
    protected void updateMetaAfterOperation(KylinConfig config) throws IOException {
        UpdateMetadataUtil.updateMetadataAfterSamplingTable(config, this);
    }
}

