/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.NBuildSourceInfo;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.ParentSourceChooser;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.ManagerHub;
import org.apache.kylin.engine.spark.metadata.cube.model.ForestSpanningTree;
import org.apache.kylin.engine.spark.metadata.cube.model.SpanningTree;
import org.apache.kylin.engine.spark.utils.SparkUtils;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ResourceDetectBeforeCubingJob
extends SparkApplication {
    protected volatile SpanningTree spanningTree;
    protected volatile List<NBuildSourceInfo> sources = new ArrayList<NBuildSourceInfo>();
    protected static final Logger logger = LoggerFactory.getLogger(ResourceDetectBeforeCubingJob.class);

    @Override
    protected void doExecute() throws Exception {
        logger.info("Start detect resource before cube.");
        HashSet segmentIds = Sets.newHashSet((Object[])StringUtils.split((String)this.getParam("segmentIds")));
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        CubeInstance cubeInstance = cubeManager.getCubeByUuid(this.getParam("cubeId"));
        for (String segId : segmentIds) {
            SegmentInfo seg = ManagerHub.getSegmentInfo((KylinConfig)this.config, (String)this.getParam("cubeId"), (String)segId);
            CubeSegment segment = cubeInstance.getSegmentById(segId);
            this.spanningTree = new ForestSpanningTree(JavaConversions.asJavaCollection((Iterable)seg.toBuildLayouts()));
            ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), ResourceDetectUtils.countDistinctSuffix()), (Object)ResourceDetectUtils.findCountDistinctMeasure((Collection)JavaConversions.asJavaCollection((Iterable)seg.toBuildLayouts())));
            ParentSourceChooser datasetChooser = new ParentSourceChooser(this.spanningTree, seg, segment, this.jobId, this.ss, this.config, false);
            datasetChooser.decideSources();
            NBuildSourceInfo buildFromFlatTable = datasetChooser.flatTableSource();
            if (buildFromFlatTable != null) {
                this.sources.add(buildFromFlatTable);
            }
            Map<Long, NBuildSourceInfo> buildFromLayouts = datasetChooser.reuseSources();
            this.sources.addAll(buildFromLayouts.values());
            HashMap resourcePaths = Maps.newHashMap();
            HashMap layoutLeafTaskNums = Maps.newHashMap();
            this.infos.clearSparkPlans();
            for (NBuildSourceInfo source : this.sources) {
                Dataset<Row> dataset = source.getParentDS();
                RDD actionRdd = dataset.queryExecution().toRdd();
                logger.info("leaf nodes is: {} ", SparkUtils.leafNodes(actionRdd));
                this.infos.recordSparkPlan(dataset.queryExecution().sparkPlan());
                List paths = JavaConversions.seqAsJavaList((Seq)ResourceDetectUtils.getPaths((SparkPlan)dataset.queryExecution().sparkPlan()));
                List pathList = paths.stream().map(Path::toString).collect(Collectors.toList());
                resourcePaths.put(String.valueOf(source.getLayoutId()), pathList);
                layoutLeafTaskNums.put(String.valueOf(source.getLayoutId()), SparkUtils.leafNodePartitionNums(actionRdd));
            }
            ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), segId + "_" + ResourceDetectUtils.fileName()), (Object)resourcePaths);
            ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), segId + "_" + ResourceDetectUtils.cubingDetectItemFileSuffix()), (Object)layoutLeafTaskNums);
        }
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeCubingJobInfo();
    }

    public static void main(String[] args) {
        ResourceDetectBeforeCubingJob resourceDetectJob = new ResourceDetectBeforeCubingJob();
        resourceDetectJob.execute(args);
    }
}

