/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.CubeMergeAssist;
import org.apache.kylin.engine.spark.job.CubeMergeJob;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.metadata.MetadataConverter;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ResourceDetectBeforeMergingJob
extends SparkApplication {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceDetectBeforeMergingJob.class);

    public static void main(String[] args) {
        ResourceDetectBeforeMergingJob resourceDetectJob = new ResourceDetectBeforeMergingJob();
        resourceDetectJob.execute(args);
    }

    @Override
    protected void doExecute() throws Exception {
        logger.info("Start detect resource before merge.");
        String cubeId = this.getParam("cubeId");
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        CubeInstance cube = cubeManager.getCubeByUuid(cubeId);
        CubeSegment mergedSeg = cube.getSegmentById(this.getParam("segmentIds"));
        SegmentInfo mergedSegInfo = MetadataConverter.getSegmentInfo((CubeInstance)cube, (String)mergedSeg.getUuid(), (String)mergedSeg.getName(), (String)mergedSeg.getStorageLocationIdentifier());
        Segments mergingSegments = cube.getMergingSegments(mergedSeg);
        ArrayList segmentInfos = Lists.newArrayList();
        Collections.sort(mergingSegments);
        for (CubeSegment cubeSegment : mergingSegments) {
            segmentInfos.add(MetadataConverter.getSegmentInfo((CubeInstance)cube, (String)cubeSegment.getUuid(), (String)cubeSegment.getName(), (String)cubeSegment.getStorageLocationIdentifier()));
        }
        this.infos.clearMergingSegments();
        this.infos.recordMergingSegments(segmentInfos);
        Map<Long, CubeMergeAssist> mergeCuboidsAssist = CubeMergeJob.generateMergeAssist(segmentInfos, this.ss);
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), ResourceDetectUtils.countDistinctSuffix()), (Object)ResourceDetectUtils.findCountDistinctMeasure((Collection)JavaConversions.asJavaCollection((Iterable)mergedSegInfo.toBuildLayouts())));
        HashMap resourcePaths = Maps.newHashMap();
        this.infos.clearSparkPlans();
        for (Map.Entry<Long, CubeMergeAssist> entry : mergeCuboidsAssist.entrySet()) {
            Dataset<Row> afterMerge = entry.getValue().merge(this.config, this.getParam("cubeName"));
            this.infos.recordSparkPlan(afterMerge.queryExecution().sparkPlan());
            List paths = JavaConversions.seqAsJavaList((Seq)ResourceDetectUtils.getPaths((SparkPlan)afterMerge.queryExecution().sparkPlan()));
            List pathStrs = paths.stream().map(Path::toString).collect(Collectors.toList());
            resourcePaths.put(String.valueOf(entry.getKey()), pathStrs);
        }
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), mergedSeg.getUuid() + "_" + ResourceDetectUtils.fileName()), (Object)resourcePaths);
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeMergingJobInfo();
    }
}

