/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.constant.JobTypeEnum;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMetadataUtil {
    protected static final Logger logger = LoggerFactory.getLogger(UpdateMetadataUtil.class);

    public static void syncLocalMetadataToRemote(KylinConfig config, NSparkExecutable nsparkExecutable) throws IOException {
        KylinConfig kylinDistConfig;
        CubeInstance distCube;
        CubeSegment toUpdateSeg;
        String cubeId = nsparkExecutable.getParam("cubeId");
        HashSet segmentIds = Sets.newHashSet((Object[])StringUtils.split((String)nsparkExecutable.getParam("segmentId"), (String)" "));
        String segmentId = (String)segmentIds.iterator().next();
        String remoteResourceStore = nsparkExecutable.getDistMetaUrl();
        String jobType = nsparkExecutable.getParam("jobType");
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)config);
        CubeInstance currentInstanceCopy = cubeManager.getCubeByUuid(cubeId).latestCopyForWrite();
        Segments tobeSegments = currentInstanceCopy.calculateToBeSegments(toUpdateSeg = (distCube = CubeManager.getInstance((KylinConfig)(kylinDistConfig = MetaDumpUtil.loadKylinConfigFromHdfs(remoteResourceStore))).getCubeByUuid(cubeId)).getSegmentById(segmentId));
        if (!tobeSegments.contains(toUpdateSeg)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s is expected but not in the tobe %s", currentInstanceCopy.toString(), toUpdateSeg.toString(), tobeSegments.toString()));
        }
        String resKey = toUpdateSeg.getStatisticsResourcePath();
        String statisticsDir = config.getJobTmpDir(currentInstanceCopy.getProject()) + "/" + nsparkExecutable.getParam("jobId") + "/" + "/cube_statistics" + "/" + cubeId + "/" + segmentId + "/";
        Path statisticsFile = new Path(statisticsDir, "cuboid_statistics.seq");
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(statisticsFile)) {
            FSDataInputStream is = fs.open(statisticsFile);
            ResourceStore.getStore((KylinConfig)config).putBigResource(resKey, (InputStream)is, System.currentTimeMillis());
        }
        CubeUpdate update = new CubeUpdate(currentInstanceCopy);
        update.setCuboids(distCube.getCuboids());
        ArrayList toRemoveSegs = Lists.newArrayList();
        if (String.valueOf(JobTypeEnum.MERGE).equals(jobType)) {
            toUpdateSeg.getSnapshots().clear();
            for (Map.Entry entry : currentInstanceCopy.getLatestReadySegment().getSnapshots().entrySet()) {
                toUpdateSeg.putSnapshotResPath((String)entry.getKey(), (String)entry.getValue());
            }
        } else if (String.valueOf(JobTypeEnum.OPTIMIZE).equals(jobType)) {
            CubeSegment origSeg = currentInstanceCopy.getOriginalSegmentToOptimize(toUpdateSeg);
            toUpdateSeg.getDictionaries().putAll(origSeg.getDictionaries());
            toUpdateSeg.getSnapshots().putAll(origSeg.getSnapshots());
            toUpdateSeg.getRowkeyStats().addAll(origSeg.getRowkeyStats());
            CubeStatsReader optSegStatsReader = new CubeStatsReader(toUpdateSeg, config, true);
            CubeStatsReader origSegStatsReader = new CubeStatsReader(origSeg, config, true);
            HashMap cuboidHLLMap = Maps.newHashMap();
            if (origSegStatsReader.getCuboidRowHLLCounters() == null) {
                logger.warn("Cuboid statistics of original segment do not exist. Please check the config of kylin.engine.segment-statistics-enabled.");
            } else {
                UpdateMetadataUtil.addFromCubeStatsReader(origSegStatsReader, cuboidHLLMap);
                UpdateMetadataUtil.addFromCubeStatsReader(optSegStatsReader, cuboidHLLMap);
                Set recommendCuboids = currentInstanceCopy.getCuboidsByMode(CuboidModeEnum.RECOMMEND);
                HashMap resultCuboidHLLMap = Maps.newHashMapWithExpectedSize((int)recommendCuboids.size());
                Iterator iterator = recommendCuboids.iterator();
                while (iterator.hasNext()) {
                    long cuboid = (Long)iterator.next();
                    HLLCounter hll = (HLLCounter)cuboidHLLMap.get(cuboid);
                    if (hll == null) {
                        logger.warn("Cannot get the row count stats for cuboid " + cuboid);
                        continue;
                    }
                    resultCuboidHLLMap.put(cuboid, hll);
                }
                if (fs.exists(statisticsFile)) {
                    fs.delete(statisticsFile, false);
                }
                CubeStatsWriter.writeCuboidStatistics((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(statisticsDir), (Map)resultCuboidHLLMap, (int)1, (long)origSegStatsReader.getSourceRowCount());
                FSDataInputStream is = fs.open(statisticsFile);
                ResourceStore.getStore((KylinConfig)config).putBigResource(resKey, (InputStream)is, System.currentTimeMillis());
            }
            toUpdateSeg.setStatus(SegmentStatusEnum.READY_PENDING);
        } else {
            toUpdateSeg.setStatus(SegmentStatusEnum.READY);
            for (CubeSegment segment : currentInstanceCopy.getSegments()) {
                if (tobeSegments.contains(segment)) continue;
                toRemoveSegs.add(segment);
            }
            Collections.sort(toRemoveSegs);
            if (currentInstanceCopy.getConfig().isJobAutoReadyCubeEnabled()) {
                update.setStatus(RealizationStatusEnum.READY);
            }
        }
        logger.info("Promoting cube {}, new segment {}, to remove segments {}", new Object[]{currentInstanceCopy, toUpdateSeg, toRemoveSegs});
        toUpdateSeg.setLastBuildTime(System.currentTimeMillis());
        update.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[0])).setToUpdateSegs(new CubeSegment[]{toUpdateSeg});
        cubeManager.updateCube(update);
    }

    public static void updateMetadataAfterMerge(String cubeId, String segmentId, KylinConfig config) throws IOException {
        CubeSegment toUpdateSegs;
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)config);
        CubeInstance currentInstanceCopy = cubeManager.getCubeByUuid(cubeId).latestCopyForWrite();
        Segments tobeSegments = currentInstanceCopy.calculateToBeSegments(toUpdateSegs = currentInstanceCopy.getSegmentById(segmentId));
        if (!tobeSegments.contains(toUpdateSegs)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s is expected but not in the tobe %s", currentInstanceCopy.toString(), toUpdateSegs.toString(), tobeSegments.toString()));
        }
        CubeUpdate update = new CubeUpdate(currentInstanceCopy);
        ArrayList toRemoveSegs = Lists.newArrayList();
        toUpdateSegs.setStatus(SegmentStatusEnum.READY);
        for (CubeSegment segment : currentInstanceCopy.getSegments()) {
            if (tobeSegments.contains(segment)) continue;
            toRemoveSegs.add(segment);
        }
        Collections.sort(toRemoveSegs);
        if (currentInstanceCopy.getConfig().isJobAutoReadyCubeEnabled()) {
            update.setStatus(RealizationStatusEnum.READY);
        }
        logger.info("Promoting cube {}, new segment {}, to remove segments {}", new Object[]{currentInstanceCopy, toUpdateSegs, toRemoveSegs});
        toUpdateSegs.setLastBuildTime(System.currentTimeMillis());
        update.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[0])).setToUpdateSegs(new CubeSegment[]{toUpdateSegs});
        cubeManager.updateCube(update);
    }

    public static void updateMetadataAfterSamplingTable(KylinConfig config, NSparkExecutable nsparkExecutable) throws IOException {
        String remoteResourceStore = nsparkExecutable.getDistMetaUrl();
        String project = nsparkExecutable.getParam("project");
        String tableIdentity = nsparkExecutable.getParam("table");
        TableMetadataManager tableMetadataManager = TableMetadataManager.getInstance((KylinConfig)config);
        TableExtDesc currentTableExtDesc = tableMetadataManager.getTableExt(tableIdentity, project);
        KylinConfig kylinDistConfig = MetaDumpUtil.loadKylinConfigFromHdfs(remoteResourceStore);
        TableExtDesc distTableExtDesc = TableMetadataManager.getInstance((KylinConfig)kylinDistConfig).getTableExt(tableIdentity, project);
        currentTableExtDesc.setCardinality(distTableExtDesc.getCardinality());
        currentTableExtDesc.setSampleRows(distTableExtDesc.getSampleRows());
        currentTableExtDesc.setColumnStats(distTableExtDesc.getColumnStats());
        logger.info("Updating table external desc {} of table {} in project {}", new Object[]{distTableExtDesc, tableIdentity, project});
        try {
            tableMetadataManager.saveTableExt(currentTableExtDesc, project);
        }
        catch (IOException e) {
            logger.error("save {} table ext found error !", (Object)currentTableExtDesc);
            e.printStackTrace();
        }
        logger.info("Table {} update table ext desc done.", (Object)tableIdentity);
    }

    private static void addFromCubeStatsReader(CubeStatsReader cubeStatsReader, Map<Long, HLLCounter> cuboidHLLMap) {
        for (Map.Entry entry : cubeStatsReader.getCuboidRowHLLCounters().entrySet()) {
            if (cuboidHLLMap.get(entry.getKey()) != null) {
                cuboidHLLMap.get(entry.getKey()).merge((HLLCounter)entry.getValue());
                continue;
            }
            cuboidHLLMap.put((Long)entry.getKey(), (HLLCounter)entry.getValue());
        }
    }
}

