/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.metadata;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.ColumnDesc$;
import org.apache.kylin.engine.spark.metadata.ComputedColumnDesc;
import org.apache.kylin.engine.spark.metadata.DTType;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.JoinDesc;
import org.apache.kylin.engine.spark.metadata.LiteralColumnDesc;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.SegmentInfo$;
import org.apache.kylin.engine.spark.metadata.TableDesc;
import org.apache.kylin.engine.spark.metadata.cube.BitUtils;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MetadataConverter$ {
    public static MetadataConverter$ MODULE$;
    private final Pattern DOT_PATTERN;
    private final String SEPARATOR;

    static {
        new MetadataConverter$();
    }

    public SegmentInfo getSegmentInfo(CubeInstance cubeInstance, String segmentId, String segmentName, String identifier) {
        return this.getSegmentInfo(cubeInstance, segmentId, segmentName, identifier, CuboidModeEnum.CURRENT);
    }

    public SegmentInfo getSegmentInfo(CubeInstance cubeInstance, String segmentId, String segmentName, String identifier, CuboidModeEnum cuboidMode) {
        Tuple2<LinkedHashMap<Integer, ColumnDesc>, LinkedHashMap<Integer, ColumnDesc>> tuple2 = this.extractAllColumnDesc(cubeInstance);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinkedHashMap allColumnDesc = (LinkedHashMap)tuple2._1();
        LinkedHashMap allRowKeyCols = (LinkedHashMap)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)allColumnDesc, (Object)allRowKeyCols);
        Tuple2 tuple23 = tuple22;
        LinkedHashMap allColumnDesc2 = (LinkedHashMap)tuple23._1();
        LinkedHashMap allRowKeyCols2 = (LinkedHashMap)tuple23._2();
        Tuple2<List<LayoutEntity>, scala.collection.immutable.Map<Integer, FunctionDesc>> tuple24 = this.extractEntityAndMeasures(cubeInstance, cuboidMode);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        List layoutEntities = (List)tuple24._1();
        scala.collection.immutable.Map measure = (scala.collection.immutable.Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)layoutEntities, (Object)measure);
        Tuple2 tuple26 = tuple25;
        List layoutEntities2 = (List)tuple26._1();
        scala.collection.immutable.Map measure2 = (scala.collection.immutable.Map)tuple26._2();
        scala.collection.immutable.Set dictColumn = ((TraversableOnce)((TraversableLike)measure2.values().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataConverter$.$anonfun$getSegmentInfo$1(x$3)))).map((Function1 & Serializable & scala.Serializable)x$4 -> (ColumnDesc)x$4.pra().head(), Iterable$.MODULE$.canBuildFrom())).toSet();
        return new SegmentInfo(segmentId, segmentName, identifier, cubeInstance.getProject(), cubeInstance.getConfig(), this.extractFactTable(cubeInstance), this.extractLookupTable(cubeInstance), this.extractLookupTable(cubeInstance), this.extractJoinTable(cubeInstance), (List<ColumnDesc>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)allColumnDesc2).asScala()).values().toList(), (List<LayoutEntity>)layoutEntities2, (scala.collection.mutable.Set<LayoutEntity>)((scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)layoutEntities2)), (scala.collection.immutable.Set<ColumnDesc>)dictColumn, (scala.collection.immutable.Set<ColumnDesc>)dictColumn, this.extractPartitionExp(cubeInstance.getSegmentById(segmentId)), this.extractFilterCondition(cubeInstance.getSegmentById(segmentId)), (List<ColumnDesc>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)allRowKeyCols2).asScala()).values().toList(), SegmentInfo$.MODULE$.apply$default$18());
    }

    public CubeUpdate getCubeUpdate(SegmentInfo segmentInfo) {
        return null;
    }

    public TableDesc extractFactTable(CubeInstance cubeInstance) {
        return this.toTableDesc(cubeInstance.getModel().getRootFactTable());
    }

    public List<TableDesc> extractLookupTable(CubeInstance cubeInstance) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cubeInstance.getModel().getJoinTables())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetadataConverter$.$anonfun$extractLookupTable$1(x$5))))).map((Function1 & Serializable & scala.Serializable)join -> MODULE$.toTableDesc(join.getTableRef()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TableDesc.class))))).toList();
    }

    public JoinDesc[] extractJoinTable(CubeInstance cubeInstance) {
        ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(cubeInstance.getModel().getAllTables()).asScala()).map((Function1 & Serializable & scala.Serializable)tb -> MODULE$.toTableDesc((TableRef)tb), Set$.MODULE$.canBuildFrom());
        String[] table = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(cubeInstance.getModel().getJoinsTree().getTableChains()).asScala()).keys().toArray(ClassTag$.MODULE$.apply(String.class)))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetadataConverter$.$anonfun$extractJoinTable$2(cubeInstance, x$6)));
        scala.collection.immutable.Map tableMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cubeInstance.getModel().getJoinTables())).map((Function1 & Serializable & scala.Serializable)join -> new Tuple2((Object)join.getAlias(), (Object)MODULE$.toJoinDesc((JoinTableDesc)join)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return (JoinDesc[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table)).map((Function1 & Serializable & scala.Serializable)key -> (JoinDesc)tableMap.apply(key), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JoinDesc.class)));
    }

    public JoinDesc toJoinDesc(JoinTableDesc joinTableDesc) {
        TableDesc desc = this.toTableDesc(joinTableDesc.getTableRef());
        ColumnDesc[] PKS = (ColumnDesc[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joinTableDesc.getJoin().getPrimaryKeyColumns())).map((Function1 & Serializable & scala.Serializable)col -> MODULE$.toColumnDesc((TblColRef)col, MODULE$.toColumnDesc$default$2(), MODULE$.toColumnDesc$default$3()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnDesc.class)));
        ColumnDesc[] FKS = (ColumnDesc[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joinTableDesc.getJoin().getForeignKeyColumns())).map((Function1 & Serializable & scala.Serializable)col -> MODULE$.toColumnDesc((TblColRef)col, MODULE$.toColumnDesc$default$2(), MODULE$.toColumnDesc$default$3()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnDesc.class)));
        return new JoinDesc(desc, PKS, FKS, joinTableDesc.getJoin().getType());
    }

    public TableDesc toTableDesc(TableRef tb) {
        TableMetadataManager tableMgr = TableMetadataManager.getInstance((KylinConfig)tb.getModel().getConfig());
        TableExtDesc tableExt = tableMgr.getTableExt(tb.getTableIdentity(), tb.getModel().getProject());
        Map addInfo = tableExt.getDataSourceProp();
        addInfo.put("project", tb.getModel().getProject());
        return new TableDesc(tb.getTableName(), tb.getTableDesc().getDatabase(), (List<ColumnDesc>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tb.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)ref -> MODULE$.toColumnDesc((TblColRef)ref, MODULE$.toColumnDesc$default$2(), MODULE$.toColumnDesc$default$3()), Iterable$.MODULE$.canBuildFrom())).toList(), tb.getAlias(), tb.getTableDesc().getSourceType(), addInfo);
    }

    public Tuple2<LinkedHashMap<Integer, ColumnDesc>, LinkedHashMap<Integer, ColumnDesc>> extractAllColumnDesc(CubeInstance cubeInstance) {
        LinkedHashMap dimensions = new LinkedHashMap();
        RowKeyColDesc[] columns = cubeInstance.getDescriptor().getRowkey().getRowKeyColumns();
        Tuple2[] dimensionMapping = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)co -> new Tuple2((Object)co.getColRef(), (Object)BoxesRunTime.boxToInteger((int)co.getBitIndex())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        scala.collection.immutable.Set set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimensionMapping)).map((Function1 & Serializable & scala.Serializable)x$7 -> (TblColRef)x$7._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TblColRef.class))))).toSet();
        scala.collection.mutable.Set measureCols = (scala.collection.mutable.Set)((SetLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(cubeInstance.getAllColumns()).asScala()).diff((GenSet)set).zipWithIndex(Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp._1(), (Object)BoxesRunTime.boxToInteger((int)(tp._2$mcI$sp() + dimensionMapping.length))), Set$.MODULE$.canBuildFrom());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimensionMapping)).foreach((Function1 & Serializable & scala.Serializable)co -> dimensions.put(Predef$.MODULE$.int2Integer(co._2$mcI$sp()), MODULE$.toColumnDesc((TblColRef)co._1(), co._2$mcI$sp(), true)));
        LinkedHashMap allColumns = new LinkedHashMap();
        allColumns.putAll(dimensions);
        measureCols.foreach((Function1 & Serializable & scala.Serializable)co -> allColumns.put(Predef$.MODULE$.int2Integer(co._2$mcI$sp()), MODULE$.toColumnDesc((TblColRef)co._1(), co._2$mcI$sp(), false)));
        return new Tuple2(allColumns, dimensions);
    }

    public LayoutEntity toLayoutEntity(CubeInstance cubeInstance, Cuboid cuboid) {
        Tuple4<List<Integer>, List<Integer>, Map<Integer, ColumnDesc>, Map<Integer, FunctionDesc>> tuple4 = this.genIDToColumnMap(cubeInstance);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        List columnIndexes = (List)tuple4._1();
        List shardByColumnsId = (List)tuple4._2();
        Map idToColumnMap = (Map)tuple4._3();
        Map measureId = (Map)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)columnIndexes, (Object)shardByColumnsId, (Object)idToColumnMap, (Object)measureId);
        Tuple4 tuple43 = tuple42;
        List columnIndexes2 = (List)tuple43._1();
        List shardByColumnsId2 = (List)tuple43._2();
        Map idToColumnMap2 = (Map)tuple43._3();
        Map measureId2 = (Map)tuple43._4();
        return this.genLayoutEntity((List<Integer>)columnIndexes2, (List<Integer>)shardByColumnsId2, idToColumnMap2, measureId2, Predef$.MODULE$.long2Long(cuboid.getId()));
    }

    public Tuple2<List<LayoutEntity>, scala.collection.immutable.Map<Integer, FunctionDesc>> extractEntityAndMeasures(CubeInstance cubeInstance) {
        return this.extractEntityAndMeasures(cubeInstance, CuboidModeEnum.CURRENT);
    }

    public Tuple2<List<LayoutEntity>, scala.collection.immutable.Map<Integer, FunctionDesc>> extractEntityAndMeasures(CubeInstance cubeInstance, CuboidModeEnum cuboidMode) {
        boolean buildBaseCuboid = cubeInstance.getConfig().isBuildBaseCuboid() || cuboidMode.equals((Object)CuboidModeEnum.CURRENT_WITH_BASE);
        Tuple4<List<Integer>, List<Integer>, Map<Integer, ColumnDesc>, Map<Integer, FunctionDesc>> tuple4 = this.genIDToColumnMap(cubeInstance);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        List columnIndexes = (List)tuple4._1();
        List shardByColumnsId = (List)tuple4._2();
        Map idToColumnMap = (Map)tuple4._3();
        Map measureId = (Map)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)columnIndexes, (Object)shardByColumnsId, (Object)idToColumnMap, (Object)measureId);
        Tuple4 tuple43 = tuple42;
        List columnIndexes2 = (List)tuple43._1();
        List shardByColumnsId2 = (List)tuple43._2();
        Map idToColumnMap2 = (Map)tuple43._3();
        Map measureId2 = (Map)tuple43._4();
        return new Tuple2((Object)((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(cubeInstance.getCuboidsByMode(cuboidMode)).asScala()).filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)MetadataConverter$.$anonfun$extractEntityAndMeasures$1(buildBaseCuboid, cubeInstance, id)))).map((Function1 & Serializable & scala.Serializable)l -> MODULE$.genLayoutEntity((List<Integer>)columnIndexes2, (List<Integer>)shardByColumnsId2, idToColumnMap2, measureId2, (Long)l), Set$.MODULE$.canBuildFrom())).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(measureId2).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    private LayoutEntity genLayoutEntity(List<Integer> columnIndexes, List<Integer> shardByColumnsId, Map<Integer, ColumnDesc> idToColumnMap, Map<Integer, FunctionDesc> measureId, Long l) {
        java.util.List<Integer> dimension = BitUtils.tailor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(columnIndexes).asJava(), Predef$.MODULE$.Long2long(l));
        LinkedHashMap<Integer, ColumnDesc> integerToDesc = new LinkedHashMap<Integer, ColumnDesc>();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dimension).asScala()).foreach((Function1 & Serializable & scala.Serializable)index -> (ColumnDesc)integerToDesc.put((Integer)index, (ColumnDesc)idToColumnMap.get(index)));
        LayoutEntity entity = new LayoutEntity();
        entity.setId(Predef$.MODULE$.Long2long(l));
        entity.setOrderedDimensions(integerToDesc);
        entity.setOrderedMeasures(measureId);
        List shards = (List)shardByColumnsId.filter((Function1 & Serializable & scala.Serializable)column -> BoxesRunTime.boxToBoolean((boolean)dimension.contains(column)));
        entity.setShardByColumns((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)shards).asJava());
        return entity;
    }

    private Tuple4<List<Integer>, List<Integer>, Map<Integer, ColumnDesc>, Map<Integer, FunctionDesc>> genIDToColumnMap(CubeInstance cubeInstance) {
        LinkedHashMap dimensionIndex = new LinkedHashMap();
        RowKeyColDesc[] columns = cubeInstance.getDescriptor().getRowkey().getRowKeyColumns();
        Tuple2[] dimensionMapping = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)co -> new Tuple2((Object)co.getColRef(), (Object)BoxesRunTime.boxToInteger((int)co.getBitIndex())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Set shardByColumns = cubeInstance.getDescriptor().getRowkey().getShardByColumns();
        scala.collection.immutable.Map dimensionMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimensionMapping)).toMap(Predef$.MODULE$.$conforms());
        List shardByColumnsId = (List)((List)((TraversableLike)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(shardByColumns).asScala()).toList().map((Function1 & Serializable & scala.Serializable)column -> dimensionMap.get(column), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)MetadataConverter$.$anonfun$genIDToColumnMap$3(v)))).map((Function1 & Serializable & scala.Serializable)column -> BoxesRunTime.unboxToInt((Object)column.get()), List$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set set = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimensionMapping)).map((Function1 & Serializable & scala.Serializable)x$10 -> (TblColRef)x$10._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TblColRef.class))))).toSet();
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)((SetLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(cubeInstance.getAllColumns()).asScala()).diff((GenSet)set).zipWithIndex(Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp._1(), (Object)BoxesRunTime.boxToInteger((int)(tp._2$mcI$sp() + dimensionMapping.length))), Set$.MODULE$.canBuildFrom());
        Tuple2[] columnIDTuples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimensionMapping)).$plus$plus((GenTraversableOnce)refs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        scala.collection.immutable.Map colToIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnIDTuples)).toMap(Predef$.MODULE$.$conforms());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnIDTuples)).foreach((Function1 & Serializable & scala.Serializable)co -> dimensionIndex.put(Predef$.MODULE$.int2Integer(co._2$mcI$sp()), MODULE$.toColumnDesc((TblColRef)co._1(), co._2$mcI$sp(), MODULE$.toColumnDesc$default$3())));
        List idToColumnMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimensionMapping)).map((Function1 & Serializable & scala.Serializable)tp -> tp._2$mcI$sp(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toList();
        LinkedHashMap measureIndex = new LinkedHashMap();
        ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cubeInstance.getMeasures()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            MeasureDesc measure = (MeasureDesc)tuple2._1();
            int in = tuple2._2$mcI$sp();
            int index = in + dimensionIndex.size();
            ParameterDesc parameter = measure.getFunction().getParameter();
            org.apache.kylin.metadata.datatype.DataType dataType = measure.getFunction().getReturnDataType();
            String string = parameter.getType();
            if ("column".equals(string)) {
                list = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parameter.getColRefs()).asScala()).map((Function1 & Serializable & scala.Serializable)col -> (ColumnDesc)dimensionIndex.get(colToIndex.apply(col)), Buffer$.MODULE$.canBuildFrom())).toList();
            } else {
                if (!"constant".equals(string)) throw new MatchError((Object)string);
                list = new .colon.colon((Object)new LiteralColumnDesc(null, SparkTypeUtil$.MODULE$.toSparkType(dataType, SparkTypeUtil$.MODULE$.toSparkType$default$2()), null, null, -1, parameter.getValue()), (List)Nil$.MODULE$);
            }
            List parametrs = list;
            FunctionDesc desc = new FunctionDesc(measure.getName(), new DTType(dataType.getName(), dataType.getPrecision(), dataType.getScale()), (List<ColumnDesc>)parametrs, measure.getFunction().getExpression());
            return measureIndex.put(index, desc);
        });
        return new Tuple4((Object)idToColumnMap, (Object)shardByColumnsId, dimensionIndex, measureIndex);
    }

    public java.util.List<LayoutEntity> extractEntityList2JavaList(CubeInstance cubeInstance) {
        return this.extractEntityList2JavaList(cubeInstance, CuboidModeEnum.CURRENT);
    }

    public java.util.List<LayoutEntity> extractEntityList2JavaList(CubeInstance cubeInstance, CuboidModeEnum cuboidMode) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.extractEntityAndMeasures(cubeInstance, cuboidMode)._1()).asJava();
    }

    private ColumnDesc toColumnDesc(TblColRef ref, int index, boolean rowKey) {
        DataType dataType = SparkTypeUtil$.MODULE$.toSparkType(org.apache.kylin.metadata.datatype.DataType.getType((String)ref.getDatatype()), SparkTypeUtil$.MODULE$.toSparkType$default$2());
        ColumnDesc columnDesc = ref.getColumnDesc().isComputedColumn() ? new ComputedColumnDesc(ref.getName(), dataType, ref.getTableRef().getTableName(), ref.getTableRef().getAlias(), index, ref.getExpressionInSourceDB()) : ColumnDesc$.MODULE$.apply(ref.getName(), dataType, ref.getTableRef().getTableName(), ref.getTableRef().getAlias(), index, rowKey);
        return columnDesc;
    }

    private int toColumnDesc$default$2() {
        return -1;
    }

    private boolean toColumnDesc$default$3() {
        return false;
    }

    public String extractPartitionExp(CubeSegment cubeSegment) {
        String string;
        if (cubeSegment.getTSRange().startValue() == 0L && cubeSegment.getTSRange().endValue() == Long.MAX_VALUE) {
            string = "";
        } else {
            Tuple2 tuple2;
            PartitionDesc partitionDesc = cubeSegment.getModel().getPartitionDesc();
            Tuple2 tuple22 = tuple2 = partitionDesc.getPartitionDateColumnRef() != null ? new Tuple2((Object)partitionDesc.getPartitionDateColumnRef().getIdentity(), (Object)this.convertFromDot(partitionDesc.getPartitionDateColumnRef().getIdentity())) : new Tuple2((Object)partitionDesc.getPartitionTimeColumnRef().getIdentity(), (Object)this.convertFromDot(partitionDesc.getPartitionTimeColumnRef().getIdentity()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String originPartitionColumn = (String)tuple2._1();
            String convertedPartitionColumn = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)originPartitionColumn, (Object)convertedPartitionColumn);
            Tuple2 tuple24 = tuple23;
            String originPartitionColumn2 = (String)tuple24._1();
            String convertedPartitionColumn2 = (String)tuple24._2();
            String originString = partitionDesc.getPartitionConditionBuilder().buildDateRangeCondition(partitionDesc, null, cubeSegment.getSegRange(), null);
            string = StringUtils.replace((String)originString, (String)originPartitionColumn2, (String)convertedPartitionColumn2);
        }
        return string;
    }

    public String extractFilterCondition(CubeSegment cubeSegment) {
        String filterCondition = cubeSegment.getModel().getFilterCondition();
        return filterCondition == null ? "" : this.convertFromDot(cubeSegment.getModel().getFilterCondition());
    }

    private Pattern DOT_PATTERN() {
        return this.DOT_PATTERN;
    }

    public String SEPARATOR() {
        return this.SEPARATOR;
    }

    /*
     * WARNING - void declaration
     */
    public String convertFromDot(String withDot) {
        void var3_3;
        Matcher m = this.DOT_PATTERN().matcher(withDot);
        String withoutDot = withDot;
        while (m.find()) {
            withoutDot = m.replaceAll(new StringBuilder(4).append("$1").append(this.SEPARATOR()).append("$2").toString());
            m = this.DOT_PATTERN().matcher(withoutDot);
        }
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$getSegmentInfo$1(FunctionDesc x$3) {
        return x$3.returnType().dataType().equals("bitmap");
    }

    public static final /* synthetic */ boolean $anonfun$extractLookupTable$1(JoinTableDesc x$5) {
        return x$5.getKind().equals((Object)DataModelDesc.TableKind.LOOKUP);
    }

    public static final /* synthetic */ boolean $anonfun$extractJoinTable$2(CubeInstance cubeInstance$1, String x$6) {
        return !x$6.equals(cubeInstance$1.getModel().getRootFactTable().getAlias());
    }

    public static final /* synthetic */ boolean $anonfun$extractEntityAndMeasures$1(boolean buildBaseCuboid$1, CubeInstance cubeInstance$2, Long id) {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)buildBaseCuboid$1)).equals(BoxesRunTime.boxToBoolean((boolean)true)) || !id.equals(BoxesRunTime.boxToLong((long)cubeInstance$2.getCuboidScheduler().getBaseCuboidId()));
    }

    public static final /* synthetic */ boolean $anonfun$genIDToColumnMap$3(Option v) {
        return v != null;
    }

    private MetadataConverter$() {
        MODULE$ = this;
        this.DOT_PATTERN = Pattern.compile("(\\S+)\\.(\\D+)");
        this.SEPARATOR = "_0_DOT_0_";
    }
}

