/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.engine.spark.metadata.cube.model.SpanningTree;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Collections2;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForestSpanningTree
extends SpanningTree {
    @JsonProperty(value="nodes")
    private Map<Long, SpanningTree.TreeNode> nodesMap = Maps.newTreeMap();
    private final Map<Long, LayoutEntity> layoutMap = Maps.newHashMap();
    @JsonProperty(value="roots")
    private final List<SpanningTree.TreeNode> roots = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(ForestSpanningTree.class);
    private static final Function<SpanningTree.TreeNode, LayoutEntity> TRANSFORM_FUNC = new Function<SpanningTree.TreeNode, LayoutEntity>(){

        @Override
        @Nullable
        public LayoutEntity apply(@Nullable SpanningTree.TreeNode input) {
            return input == null ? null : input.indexEntity;
        }
    };

    public ForestSpanningTree(Collection<LayoutEntity> cuboids) {
        super(cuboids);
        this.init();
    }

    @Override
    public boolean isValid(long requestCuboid) {
        return this.nodesMap.containsKey(requestCuboid);
    }

    @Override
    public int getCuboidCount() {
        return this.nodesMap.size();
    }

    @Override
    public Collection<LayoutEntity> getRootIndexEntities() {
        return Collections2.transform(this.roots, TRANSFORM_FUNC::apply);
    }

    @Override
    public LayoutEntity getLayoutEntity(long cuboidId) {
        if (this.nodesMap.get(cuboidId) == null) {
            throw new IllegalStateException("Cuboid\uff08ID:" + cuboidId + ") does not exist!");
        }
        return this.nodesMap.get((Object)Long.valueOf((long)cuboidId)).indexEntity;
    }

    @Override
    public Collection<LayoutEntity> getChildrenByIndexPlan(LayoutEntity parent) {
        SpanningTree.TreeNode parentNode = this.nodesMap.get(parent.getId());
        Preconditions.checkState((boolean)parentNode.hasBeenDecided, (Object)"Node must have been decided before get its children.");
        return Collections2.transform(parentNode.children, TRANSFORM_FUNC::apply);
    }

    @Override
    public Collection<LayoutEntity> getAllIndexEntities() {
        return Collections2.transform(this.nodesMap.values(), TRANSFORM_FUNC::apply);
    }

    private void init() {
        new TreeBuilder(this.cuboids).build();
    }

    @Override
    public void decideTheNextLayer(Collection<LayoutEntity> currentLayer, SegmentInfo segment) {
        Comparator<LayoutEntity> c1 = Comparator.comparingLong(o -> o.rows);
        Comparator<LayoutEntity> c2 = Comparator.comparingLong(LayoutEntity::getId);
        List<LayoutEntity> orderedIndexes = currentLayer.stream().sorted(c1.thenComparing(c2)).collect(Collectors.toList());
        orderedIndexes.forEach(index -> {
            this.adjustTree((LayoutEntity)index, segment);
            logger.info("Adjust spanning tree. Current index entity: {}. Its children: {}\n", (Object)index.getId(), (Object)Arrays.toString(this.getChildrenByIndexPlan((LayoutEntity)index).stream().map(LayoutEntity::getId).toArray()));
        });
    }

    private void adjustTree(LayoutEntity parent, SegmentInfo seg) {
        SpanningTree.TreeNode parentNode = this.nodesMap.get(parent.getId());
        List<SpanningTree.TreeNode> children = this.nodesMap.values().stream().filter(node -> this.shouldBeAdded((SpanningTree.TreeNode)node, parent, seg)).collect(Collectors.toList());
        children.forEach(node -> {
            node.level = parentNode.level + 1;
            node.parent = parentNode;
        });
        parentNode.children.addAll(children);
        parentNode.hasBeenDecided = true;
    }

    private boolean shouldBeAdded(SpanningTree.TreeNode node, LayoutEntity parent, SegmentInfo seg) {
        return node.parent == null && node.parentCandidates != null && node.parentCandidates.stream().allMatch(c -> this.isBuilt((LayoutEntity)c, seg)) && node.parentCandidates.stream().anyMatch(en -> en.getId() == parent.getId());
    }

    public boolean isBuilt(LayoutEntity ie, SegmentInfo seg) {
        return !seg.toBuildLayouts().contains((Object)ie);
    }

    private class TreeBuilder {
        private SortedSet<LayoutEntity> sortedCuboids = Sets.newTreeSet((o1, o2) -> {
            int c1 = Integer.compare(o1.getOrderedDimensions().size(), o2.getOrderedDimensions().size());
            int c2 = Integer.compare(o1.getOrderedMeasures().size(), o2.getOrderedMeasures().size());
            if (c1 != 0) {
                return c1;
            }
            if (c2 != 0) {
                return c2;
            }
            return Long.compare(o1.getId(), o2.getId());
        });

        private TreeBuilder(Collection<LayoutEntity> cuboids) {
            if (cuboids != null) {
                this.sortedCuboids.addAll(cuboids);
            }
        }

        private void build() {
            for (LayoutEntity cuboid : this.sortedCuboids) {
                this.addCuboid(cuboid);
            }
        }

        private void addCuboid(LayoutEntity cuboid) {
            SpanningTree.TreeNode node = new SpanningTree.TreeNode(cuboid);
            List<LayoutEntity> candidates = this.findDirectParentCandidates(cuboid);
            if (!candidates.isEmpty()) {
                node.parentCandidates = candidates;
            } else {
                node.level = 0;
                ForestSpanningTree.this.roots.add(node);
            }
            ForestSpanningTree.this.nodesMap.put(cuboid.getId(), node);
        }

        private List<LayoutEntity> findDirectParentCandidates(LayoutEntity entity) {
            ArrayList<LayoutEntity> candidates = new ArrayList<LayoutEntity>();
            for (LayoutEntity cuboid : this.sortedCuboids) {
                if (cuboid == entity || !cuboid.fullyDerive(entity) || !candidates.stream().noneMatch(candidate -> cuboid.fullyDerive((LayoutEntity)candidate))) continue;
                candidates.add(cuboid);
            }
            return candidates;
        }
    }
}

